/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="label object")
public class MailLabel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_COLOR = "color";
    @SerializedName(value="color")
    private String color = ColorEnum.FFFFFF.getValue();
    private ColorEnum colorEnum = ColorEnum.FFFFFF;
    public static final String SERIALIZED_NAME_LABEL_ID = "label_id";
    @SerializedName(value="label_id")
    private Integer labelId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_UNREAD_COUNT = "unread_count";
    @SerializedName(value="unread_count")
    private Integer unreadCount;

    public MailLabel color(ColorEnum colorEnum) {
        this.colorEnum = colorEnum;
        return this;
    }

    public MailLabel colorString(String color) {
        this.color = color;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="color string")
    public ColorEnum getColor() {
        if (this.colorEnum == null) {
            this.colorEnum = ColorEnum.fromValue(this.color);
        }
        return this.colorEnum;
    }

    public String getColorString() {
        return this.color;
    }

    public void setColor(ColorEnum colorEnum) {
        this.colorEnum = colorEnum;
    }

    public void setColorString(String color) {
        this.color = color;
    }

    public MailLabel labelId(Integer labelId) {
        this.labelId = labelId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="label_id integer")
    public Integer getLabelId() {
        return this.labelId;
    }

    public void setLabelId(Integer labelId) {
        this.labelId = labelId;
    }

    public MailLabel name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name string")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MailLabel unreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="unread_count integer")
    public Integer getUnreadCount() {
        return this.unreadCount;
    }

    public void setUnreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailLabel mailLabel = (MailLabel)o;
        return Objects.equals(this.color, mailLabel.color) && Objects.equals(this.labelId, mailLabel.labelId) && Objects.equals(this.name, mailLabel.name) && Objects.equals(this.unreadCount, mailLabel.unreadCount);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.labelId, this.name, this.unreadCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MailLabel {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    labelId: ").append(this.toIndentedString(this.labelId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    unreadCount: ").append(this.toIndentedString(this.unreadCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ColorEnum {
        _0000FE("#0000fe"),
        _006634("#006634"),
        _0099FF("#0099ff"),
        _00FF33("#00ff33"),
        _01FFFF("#01ffff"),
        _349800("#349800"),
        _660066("#660066"),
        _666666("#666666"),
        _999999("#999999"),
        _99FFFF("#99ffff"),
        _9A0000("#9a0000"),
        CCFF9A("#ccff9a"),
        E6E6E6("#e6e6e6"),
        FE0000("#fe0000"),
        FF6600("#ff6600"),
        FFFF01("#ffff01"),
        FFFFCD("#ffffcd"),
        FFFFFF("#ffffff");

        private String value;

        private ColorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ColorEnum fromValue(String value) {
            for (ColorEnum b : ColorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ColorEnum> {
            public void write(JsonWriter jsonWriter, ColorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ColorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ColorEnum.fromValue(value);
            }
        }
    }
}

