/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="200 ok object")
public class FleetMembersResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CHARACTER_ID = "character_id";
    @SerializedName(value="character_id")
    private Integer characterId;
    public static final String SERIALIZED_NAME_JOIN_TIME = "join_time";
    @SerializedName(value="join_time")
    private OffsetDateTime joinTime;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private String role;
    private RoleEnum roleEnum;
    public static final String SERIALIZED_NAME_ROLE_NAME = "role_name";
    @SerializedName(value="role_name")
    private String roleName;
    public static final String SERIALIZED_NAME_SHIP_TYPE_ID = "ship_type_id";
    @SerializedName(value="ship_type_id")
    private Integer shipTypeId;
    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(value="solar_system_id")
    private Integer solarSystemId;
    public static final String SERIALIZED_NAME_SQUAD_ID = "squad_id";
    @SerializedName(value="squad_id")
    private Long squadId;
    public static final String SERIALIZED_NAME_STATION_ID = "station_id";
    @SerializedName(value="station_id")
    private Long stationId;
    public static final String SERIALIZED_NAME_TAKES_FLEET_WARP = "takes_fleet_warp";
    @SerializedName(value="takes_fleet_warp")
    private Boolean takesFleetWarp;
    public static final String SERIALIZED_NAME_WING_ID = "wing_id";
    @SerializedName(value="wing_id")
    private Long wingId;

    public FleetMembersResponse characterId(Integer characterId) {
        this.characterId = characterId;
        return this;
    }

    @ApiModelProperty(required=true, value="character_id integer")
    public Integer getCharacterId() {
        return this.characterId;
    }

    public void setCharacterId(Integer characterId) {
        this.characterId = characterId;
    }

    public FleetMembersResponse joinTime(OffsetDateTime joinTime) {
        this.joinTime = joinTime;
        return this;
    }

    @ApiModelProperty(required=true, value="join_time string")
    public OffsetDateTime getJoinTime() {
        return this.joinTime;
    }

    public void setJoinTime(OffsetDateTime joinTime) {
        this.joinTime = joinTime;
    }

    public FleetMembersResponse role(RoleEnum roleEnum) {
        this.roleEnum = roleEnum;
        return this;
    }

    public FleetMembersResponse roleString(String role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(required=true, value="Member\u2019s role in fleet")
    public RoleEnum getRole() {
        if (this.roleEnum == null) {
            this.roleEnum = RoleEnum.fromValue(this.role);
        }
        return this.roleEnum;
    }

    public String getRoleString() {
        return this.role;
    }

    public void setRole(RoleEnum roleEnum) {
        this.roleEnum = roleEnum;
    }

    public void setRoleString(String role) {
        this.role = role;
    }

    public FleetMembersResponse roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @ApiModelProperty(required=true, value="Localized role names")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public FleetMembersResponse shipTypeId(Integer shipTypeId) {
        this.shipTypeId = shipTypeId;
        return this;
    }

    @ApiModelProperty(required=true, value="ship_type_id integer")
    public Integer getShipTypeId() {
        return this.shipTypeId;
    }

    public void setShipTypeId(Integer shipTypeId) {
        this.shipTypeId = shipTypeId;
    }

    public FleetMembersResponse solarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    @ApiModelProperty(required=true, value="Solar system the member is located in")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public FleetMembersResponse squadId(Long squadId) {
        this.squadId = squadId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the squad the member is in. If not applicable, will be set to -1")
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(Long squadId) {
        this.squadId = squadId;
    }

    public FleetMembersResponse stationId(Long stationId) {
        this.stationId = stationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Station in which the member is docked in, if applicable")
    public Long getStationId() {
        return this.stationId;
    }

    public void setStationId(Long stationId) {
        this.stationId = stationId;
    }

    public FleetMembersResponse takesFleetWarp(Boolean takesFleetWarp) {
        this.takesFleetWarp = takesFleetWarp;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the member take fleet warps")
    public Boolean getTakesFleetWarp() {
        return this.takesFleetWarp;
    }

    public void setTakesFleetWarp(Boolean takesFleetWarp) {
        this.takesFleetWarp = takesFleetWarp;
    }

    public FleetMembersResponse wingId(Long wingId) {
        this.wingId = wingId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the wing the member is in. If not applicable, will be set to -1")
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(Long wingId) {
        this.wingId = wingId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetMembersResponse fleetMembersResponse = (FleetMembersResponse)o;
        return Objects.equals(this.characterId, fleetMembersResponse.characterId) && Objects.equals(this.joinTime, fleetMembersResponse.joinTime) && Objects.equals(this.role, fleetMembersResponse.role) && Objects.equals(this.roleName, fleetMembersResponse.roleName) && Objects.equals(this.shipTypeId, fleetMembersResponse.shipTypeId) && Objects.equals(this.solarSystemId, fleetMembersResponse.solarSystemId) && Objects.equals(this.squadId, fleetMembersResponse.squadId) && Objects.equals(this.stationId, fleetMembersResponse.stationId) && Objects.equals(this.takesFleetWarp, fleetMembersResponse.takesFleetWarp) && Objects.equals(this.wingId, fleetMembersResponse.wingId);
    }

    public int hashCode() {
        return Objects.hash(this.characterId, this.joinTime, this.role, this.roleName, this.shipTypeId, this.solarSystemId, this.squadId, this.stationId, this.takesFleetWarp, this.wingId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetMembersResponse {\n");
        sb.append("    characterId: ").append(this.toIndentedString(this.characterId)).append("\n");
        sb.append("    joinTime: ").append(this.toIndentedString(this.joinTime)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("    shipTypeId: ").append(this.toIndentedString(this.shipTypeId)).append("\n");
        sb.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        sb.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        sb.append("    stationId: ").append(this.toIndentedString(this.stationId)).append("\n");
        sb.append("    takesFleetWarp: ").append(this.toIndentedString(this.takesFleetWarp)).append("\n");
        sb.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        WING_COMMANDER("wing_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }
}

