/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="200 ok object")
public class CharacterOrdersHistoryResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private Integer duration;
    public static final String SERIALIZED_NAME_ESCROW = "escrow";
    @SerializedName(value="escrow")
    private Double escrow;
    public static final String SERIALIZED_NAME_IS_BUY_ORDER = "is_buy_order";
    @SerializedName(value="is_buy_order")
    private Boolean isBuyOrder;
    public static final String SERIALIZED_NAME_IS_CORPORATION = "is_corporation";
    @SerializedName(value="is_corporation")
    private Boolean isCorporation;
    public static final String SERIALIZED_NAME_ISSUED = "issued";
    @SerializedName(value="issued")
    private OffsetDateTime issued;
    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(value="location_id")
    private Long locationId;
    public static final String SERIALIZED_NAME_MIN_VOLUME = "min_volume";
    @SerializedName(value="min_volume")
    private Integer minVolume;
    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(value="order_id")
    private Long orderId;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private Double price;
    public static final String SERIALIZED_NAME_RANGE = "range";
    @SerializedName(value="range")
    private String range;
    private RangeEnum rangeEnum;
    public static final String SERIALIZED_NAME_REGION_ID = "region_id";
    @SerializedName(value="region_id")
    private Integer regionId;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    private StateEnum stateEnum;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_VOLUME_REMAIN = "volume_remain";
    @SerializedName(value="volume_remain")
    private Integer volumeRemain;
    public static final String SERIALIZED_NAME_VOLUME_TOTAL = "volume_total";
    @SerializedName(value="volume_total")
    private Integer volumeTotal;

    public CharacterOrdersHistoryResponse duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of days the order was valid for (starting from the issued date). An order expires at time issued + duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public CharacterOrdersHistoryResponse escrow(Double escrow) {
        this.escrow = escrow;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For buy orders, the amount of ISK in escrow")
    public Double getEscrow() {
        return this.escrow;
    }

    public void setEscrow(Double escrow) {
        this.escrow = escrow;
    }

    public CharacterOrdersHistoryResponse isBuyOrder(Boolean isBuyOrder) {
        this.isBuyOrder = isBuyOrder;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the order is a bid (buy) order")
    public Boolean getIsBuyOrder() {
        return this.isBuyOrder;
    }

    public void setIsBuyOrder(Boolean isBuyOrder) {
        this.isBuyOrder = isBuyOrder;
    }

    public CharacterOrdersHistoryResponse isCorporation(Boolean isCorporation) {
        this.isCorporation = isCorporation;
        return this;
    }

    @ApiModelProperty(required=true, value="Signifies whether the buy/sell order was placed on behalf of a corporation.")
    public Boolean getIsCorporation() {
        return this.isCorporation;
    }

    public void setIsCorporation(Boolean isCorporation) {
        this.isCorporation = isCorporation;
    }

    public CharacterOrdersHistoryResponse issued(OffsetDateTime issued) {
        this.issued = issued;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time when this order was issued")
    public OffsetDateTime getIssued() {
        return this.issued;
    }

    public void setIssued(OffsetDateTime issued) {
        this.issued = issued;
    }

    public CharacterOrdersHistoryResponse locationId(Long locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the location where order was placed")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    public CharacterOrdersHistoryResponse minVolume(Integer minVolume) {
        this.minVolume = minVolume;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For buy orders, the minimum quantity that will be accepted in a matching sell order")
    public Integer getMinVolume() {
        return this.minVolume;
    }

    public void setMinVolume(Integer minVolume) {
        this.minVolume = minVolume;
    }

    public CharacterOrdersHistoryResponse orderId(Long orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique order ID")
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public CharacterOrdersHistoryResponse price(Double price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(required=true, value="Cost per unit for this order")
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public CharacterOrdersHistoryResponse range(RangeEnum rangeEnum) {
        this.rangeEnum = rangeEnum;
        return this;
    }

    public CharacterOrdersHistoryResponse rangeString(String range) {
        this.range = range;
        return this;
    }

    @ApiModelProperty(required=true, value="Valid order range, numbers are ranges in jumps")
    public RangeEnum getRange() {
        if (this.rangeEnum == null) {
            this.rangeEnum = RangeEnum.fromValue(this.range);
        }
        return this.rangeEnum;
    }

    public String getRangeString() {
        return this.range;
    }

    public void setRange(RangeEnum rangeEnum) {
        this.rangeEnum = rangeEnum;
    }

    public void setRangeString(String range) {
        this.range = range;
    }

    public CharacterOrdersHistoryResponse regionId(Integer regionId) {
        this.regionId = regionId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the region where order was placed")
    public Integer getRegionId() {
        return this.regionId;
    }

    public void setRegionId(Integer regionId) {
        this.regionId = regionId;
    }

    public CharacterOrdersHistoryResponse state(StateEnum stateEnum) {
        this.stateEnum = stateEnum;
        return this;
    }

    public CharacterOrdersHistoryResponse stateString(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="Current order state")
    public StateEnum getState() {
        if (this.stateEnum == null) {
            this.stateEnum = StateEnum.fromValue(this.state);
        }
        return this.stateEnum;
    }

    public String getStateString() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.stateEnum = stateEnum;
    }

    public void setStateString(String state) {
        this.state = state;
    }

    public CharacterOrdersHistoryResponse typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The type ID of the item transacted in this order")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public CharacterOrdersHistoryResponse volumeRemain(Integer volumeRemain) {
        this.volumeRemain = volumeRemain;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity of items still required or offered")
    public Integer getVolumeRemain() {
        return this.volumeRemain;
    }

    public void setVolumeRemain(Integer volumeRemain) {
        this.volumeRemain = volumeRemain;
    }

    public CharacterOrdersHistoryResponse volumeTotal(Integer volumeTotal) {
        this.volumeTotal = volumeTotal;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity of items required or offered at time order was placed")
    public Integer getVolumeTotal() {
        return this.volumeTotal;
    }

    public void setVolumeTotal(Integer volumeTotal) {
        this.volumeTotal = volumeTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterOrdersHistoryResponse characterOrdersHistoryResponse = (CharacterOrdersHistoryResponse)o;
        return Objects.equals(this.duration, characterOrdersHistoryResponse.duration) && Objects.equals(this.escrow, characterOrdersHistoryResponse.escrow) && Objects.equals(this.isBuyOrder, characterOrdersHistoryResponse.isBuyOrder) && Objects.equals(this.isCorporation, characterOrdersHistoryResponse.isCorporation) && Objects.equals(this.issued, characterOrdersHistoryResponse.issued) && Objects.equals(this.locationId, characterOrdersHistoryResponse.locationId) && Objects.equals(this.minVolume, characterOrdersHistoryResponse.minVolume) && Objects.equals(this.orderId, characterOrdersHistoryResponse.orderId) && Objects.equals(this.price, characterOrdersHistoryResponse.price) && Objects.equals(this.range, characterOrdersHistoryResponse.range) && Objects.equals(this.regionId, characterOrdersHistoryResponse.regionId) && Objects.equals(this.state, characterOrdersHistoryResponse.state) && Objects.equals(this.typeId, characterOrdersHistoryResponse.typeId) && Objects.equals(this.volumeRemain, characterOrdersHistoryResponse.volumeRemain) && Objects.equals(this.volumeTotal, characterOrdersHistoryResponse.volumeTotal);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.escrow, this.isBuyOrder, this.isCorporation, this.issued, this.locationId, this.minVolume, this.orderId, this.price, this.range, this.regionId, this.state, this.typeId, this.volumeRemain, this.volumeTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterOrdersHistoryResponse {\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    escrow: ").append(this.toIndentedString(this.escrow)).append("\n");
        sb.append("    isBuyOrder: ").append(this.toIndentedString(this.isBuyOrder)).append("\n");
        sb.append("    isCorporation: ").append(this.toIndentedString(this.isCorporation)).append("\n");
        sb.append("    issued: ").append(this.toIndentedString(this.issued)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    minVolume: ").append(this.toIndentedString(this.minVolume)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    range: ").append(this.toIndentedString(this.range)).append("\n");
        sb.append("    regionId: ").append(this.toIndentedString(this.regionId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    volumeRemain: ").append(this.toIndentedString(this.volumeRemain)).append("\n");
        sb.append("    volumeTotal: ").append(this.toIndentedString(this.volumeTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        CANCELLED("cancelled"),
        EXPIRED("expired");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RangeEnum {
        _1("1"),
        _10("10"),
        _2("2"),
        _20("20"),
        _3("3"),
        _30("30"),
        _4("4"),
        _40("40"),
        _5("5"),
        REGION("region"),
        SOLARSYSTEM("solarsystem"),
        STATION("station");

        private String value;

        private RangeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RangeEnum fromValue(String value) {
            for (RangeEnum b : RangeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RangeEnum> {
            public void write(JsonWriter jsonWriter, RangeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RangeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RangeEnum.fromValue(value);
            }
        }
    }
}

