/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.auth.Authentication;
import net.troja.eve.esi.auth.JWT;

public class OAuth
implements Authentication {
    private static final String URI_OAUTH = "https://login.eveonline.com/v2/oauth";
    private static final String URI_AUTHENTICATION = "https://login.eveonline.com/v2/oauth/authorize";
    private static final String URI_ACCESS_TOKEN = "https://login.eveonline.com/v2/oauth/token";
    private static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
    private static final SecureRandom RND = new SecureRandom();
    private static final int LEN = 128;
    private String codeVerifier;
    private AccountData account;
    private static final Map<String, AccountData> ACCOUNTS = new ConcurrentHashMap<String, AccountData>();

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        AccountData accountData = this.getAccountData();
        if (accountData != null) {
            headerParams.put("Authorization", "Bearer " + accountData.getAccessToken());
        }
    }

    public void setAccessToken(String accessToken) {
        if (this.account == null) {
            this.account = new AccountData(null, null);
        }
        this.account.setAccessToken(accessToken);
    }

    public String getRefreshToken() {
        if (this.account != null) {
            return this.account.getRefreshToken();
        }
        return null;
    }

    public String getClientId() {
        if (this.account != null) {
            return this.account.getClientId();
        }
        return null;
    }

    public void setAuth(String clientId, String refreshToken) {
        AccountData accountData = new AccountData(clientId, refreshToken);
        AccountData old = ACCOUNTS.putIfAbsent(accountData.getKey(), accountData);
        if (old != null) {
            accountData = old;
        }
        if (this.account != null) {
            accountData.setAccessToken(this.account.getAccessToken());
        }
        this.account = accountData;
    }

    public void setClientId(String clientId) {
        this.setAuth(clientId, null);
    }

    public String getAccessToken() {
        AccountData accessTokenData = this.getAccountData();
        if (accessTokenData != null) {
            return accessTokenData.getAccessToken();
        }
        return null;
    }

    public JWT getJWT() {
        AccountData accountData = this.getAccountData();
        if (accountData == null) {
            return null;
        }
        try {
            String accessToken = accountData.getAccessToken();
            if (accessToken == null) {
                return null;
            }
            String[] parts = accessToken.split("\\.");
            if (parts.length != 3) {
                return null;
            }
            Gson gson = new GsonBuilder().registerTypeAdapter(JWT.Payload.class, (Object)new JWT.PayloadDeserializer()).create();
            JWT.Header header = (JWT.Header)gson.fromJson(new String(Base64.getUrlDecoder().decode(parts[0])), JWT.Header.class);
            JWT.Payload payload = (JWT.Payload)gson.fromJson(new String(Base64.getUrlDecoder().decode(parts[1])), JWT.Payload.class);
            String signature = parts[2];
            return new JWT(header, payload, signature);
        }
        catch (JsonSyntaxException ex) {
            return null;
        }
    }

    private AccountData getAccountData() {
        if (this.account == null) {
            return null;
        }
        this.account.update();
        return this.account;
    }

    public String getAuthorizationUri(String redirectUri, Set<String> scopes, String state) {
        if (this.account == null) {
            throw new IllegalArgumentException("Auth is not set");
        }
        if (this.account.getClientId() == null) {
            throw new IllegalArgumentException("client_id is not set");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(URI_AUTHENTICATION);
        builder.append("?");
        builder.append("response_type=");
        builder.append(OAuth.encode("code"));
        builder.append("&redirect_uri=");
        builder.append(OAuth.encode(redirectUri));
        builder.append("&client_id=");
        builder.append(OAuth.encode(this.account.getClientId()));
        builder.append("&scope=");
        builder.append(OAuth.encode(this.getScopesString(scopes)));
        builder.append("&state=");
        builder.append(OAuth.encode(state));
        builder.append("&code_challenge");
        builder.append(this.getCodeChallenge());
        builder.append("&code_challenge_method=");
        builder.append(OAuth.encode("S256"));
        return builder.toString();
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void finishFlow(String code, String state, String codeVerifier) throws ApiException {
        this.codeVerifier = codeVerifier;
        this.finishFlow(code, state);
    }

    public void finishFlow(String code, String state) throws ApiException {
        if (this.account == null) {
            throw new IllegalArgumentException("Auth is not set");
        }
        if (this.codeVerifier == null) {
            throw new IllegalArgumentException("code_verifier is not set");
        }
        if (this.account.getClientId() == null) {
            throw new IllegalArgumentException("client_id is not set");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("grant_type=");
        builder.append(OAuth.encode("authorization_code"));
        builder.append("&client_id=");
        builder.append(OAuth.encode(this.account.getClientId()));
        builder.append("&code=");
        builder.append(OAuth.encode(code));
        builder.append("&code_verifier=");
        builder.append(OAuth.encode(this.codeVerifier));
        OAuth.update(this.account, builder.toString());
    }

    private static void refreshToken(AccountData accountData) throws ApiException {
        StringBuilder builder = new StringBuilder();
        builder.append("grant_type=");
        builder.append(OAuth.encode("refresh_token"));
        builder.append("&client_id=");
        builder.append(OAuth.encode(accountData.getClientId()));
        builder.append("&refresh_token=");
        builder.append(OAuth.encode(accountData.getRefreshToken()));
        OAuth.update(accountData, builder.toString());
    }

    private static void update(AccountData accountData, String urlParameters) throws ApiException {
        try {
            StringBuilder response;
            URL obj = new URL(URI_ACCESS_TOKEN);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("Host", "login.eveonline.com");
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            con.setDoOutput(true);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.writeBytes(urlParameters);
                wr.flush();
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            Gson gson = new GsonBuilder().create();
            Result result = (Result)gson.fromJson(response.toString(), Result.class);
            long validUntil = System.currentTimeMillis() + result.getExpiresIn() * 1000L - 5000L;
            ACCOUNTS.remove(accountData.getKey());
            accountData.setAccessToken(result.getAccessToken());
            accountData.setValidUntil(validUntil);
            accountData.setRefreshToken(result.getRefreshToken());
            ACCOUNTS.put(accountData.getKey(), accountData);
        }
        catch (JsonSyntaxException ex) {
            throw new ApiException(ex);
        }
        catch (MalformedURLException ex) {
            throw new ApiException(ex);
        }
        catch (IOException ex) {
            throw new ApiException(ex);
        }
    }

    private String getScopesString(Set<String> scopes) {
        StringBuilder scopesString = new StringBuilder();
        if (scopes != null) {
            for (String scope : scopes) {
                if (scopesString.length() > 0) {
                    scopesString.append(' ');
                }
                scopesString.append(scope);
            }
        }
        return scopesString.toString();
    }

    private String getCodeChallenge() {
        try {
            StringBuilder sb = new StringBuilder(128);
            for (int i = 0; i < 128; ++i) {
                sb.append(AB.charAt(RND.nextInt(AB.length())));
            }
            this.codeVerifier = sb.toString();
            byte[] ascii = this.codeVerifier.getBytes(StandardCharsets.US_ASCII);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] sha = digest.digest(ascii);
            return Base64.getUrlEncoder().encodeToString(sha);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    private static String encode(String parameter) {
        try {
            return URLEncoder.encode(parameter, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    private static class Result {
        @SerializedName(value="access_token")
        private String accessToken;
        @SerializedName(value="expires_in")
        private Long expiresIn;
        @SerializedName(value="token_type")
        private String tokenType;
        @SerializedName(value="refresh_token")
        private String refreshToken;

        private Result() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public Long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }
    }

    private static class AccountData {
        private final String clientId;
        private String refreshToken;
        private String accessToken;
        private long validUntil = 0L;

        public AccountData(String clientId, String refreshToken) {
            this.clientId = clientId;
            this.refreshToken = refreshToken;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public long getValidUntil() {
            return this.validUntil;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setValidUntil(long validUntil) {
            this.validUntil = validUntil;
        }

        private synchronized void update() {
            if (this.refreshToken != null && (this.accessToken == null || this.getValidUntil() < System.currentTimeMillis())) {
                try {
                    OAuth.refreshToken(this);
                }
                catch (ApiException apiException) {
                    // empty catch block
                }
            }
        }

        public String getKey() {
            return this.clientId + this.refreshToken;
        }
    }
}

