/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="cost_indice object")
public class SystemCostIndice
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ACTIVITY = "activity";
    @SerializedName(value="activity")
    private String activity;
    private ActivityEnum activityEnum;
    public static final String SERIALIZED_NAME_COST_INDEX = "cost_index";
    @SerializedName(value="cost_index")
    private Float costIndex;

    public SystemCostIndice activity(ActivityEnum activityEnum) {
        this.activityEnum = activityEnum;
        return this;
    }

    public SystemCostIndice activityString(String activity) {
        this.activity = activity;
        return this;
    }

    @ApiModelProperty(required=true, value="activity string")
    public ActivityEnum getActivity() {
        if (this.activityEnum == null) {
            this.activityEnum = ActivityEnum.fromValue(this.activity);
        }
        return this.activityEnum;
    }

    public String getActivityString() {
        return this.activity;
    }

    public void setActivity(ActivityEnum activityEnum) {
        this.activityEnum = activityEnum;
    }

    public void setActivityString(String activity) {
        this.activity = activity;
    }

    public SystemCostIndice costIndex(Float costIndex) {
        this.costIndex = costIndex;
        return this;
    }

    @ApiModelProperty(required=true, value="cost_index number")
    public Float getCostIndex() {
        return this.costIndex;
    }

    public void setCostIndex(Float costIndex) {
        this.costIndex = costIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemCostIndice systemCostIndice = (SystemCostIndice)o;
        return Objects.equals(this.activity, systemCostIndice.activity) && Objects.equals(this.costIndex, systemCostIndice.costIndex);
    }

    public int hashCode() {
        return Objects.hash(this.activity, this.costIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemCostIndice {\n");
        sb.append("    activity: ").append(this.toIndentedString(this.activity)).append("\n");
        sb.append("    costIndex: ").append(this.toIndentedString(this.costIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActivityEnum {
        COPYING("copying"),
        DUPLICATING("duplicating"),
        INVENTION("invention"),
        MANUFACTURING("manufacturing"),
        NONE("none"),
        REACTION("reaction"),
        RESEARCHING_MATERIAL_EFFICIENCY("researching_material_efficiency"),
        RESEARCHING_TECHNOLOGY("researching_technology"),
        RESEARCHING_TIME_EFFICIENCY("researching_time_efficiency"),
        REVERSE_ENGINEERING("reverse_engineering");

        private String value;

        private ActivityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActivityEnum fromValue(String value) {
            for (ActivityEnum b : ActivityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActivityEnum> {
            public void write(JsonWriter jsonWriter, ActivityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActivityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActivityEnum.fromValue(value);
            }
        }
    }
}

