/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.CharacterFwStatsKills;
import net.troja.eve.esi.model.CharacterFwStatsVictoryPoints;

@ApiModel(description="200 ok object")
public class CharacterFwStatsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CURRENT_RANK = "current_rank";
    @SerializedName(value="current_rank")
    private Integer currentRank;
    public static final String SERIALIZED_NAME_ENLISTED_ON = "enlisted_on";
    @SerializedName(value="enlisted_on")
    private OffsetDateTime enlistedOn;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    private Integer factionId;
    public static final String SERIALIZED_NAME_HIGHEST_RANK = "highest_rank";
    @SerializedName(value="highest_rank")
    private Integer highestRank;
    public static final String SERIALIZED_NAME_KILLS = "kills";
    @SerializedName(value="kills")
    private CharacterFwStatsKills kills;
    public static final String SERIALIZED_NAME_VICTORY_POINTS = "victory_points";
    @SerializedName(value="victory_points")
    private CharacterFwStatsVictoryPoints victoryPoints;

    public CharacterFwStatsResponse currentRank(Integer currentRank) {
        this.currentRank = currentRank;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The given character's current faction rank")
    public Integer getCurrentRank() {
        return this.currentRank;
    }

    public void setCurrentRank(Integer currentRank) {
        this.currentRank = currentRank;
    }

    public CharacterFwStatsResponse enlistedOn(OffsetDateTime enlistedOn) {
        this.enlistedOn = enlistedOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The enlistment date of the given character into faction warfare. Will not be included if character is not enlisted in faction warfare")
    public OffsetDateTime getEnlistedOn() {
        return this.enlistedOn;
    }

    public void setEnlistedOn(OffsetDateTime enlistedOn) {
        this.enlistedOn = enlistedOn;
    }

    public CharacterFwStatsResponse factionId(Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The faction the given character is enlisted to fight for. Will not be included if character is not enlisted in faction warfare")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public CharacterFwStatsResponse highestRank(Integer highestRank) {
        this.highestRank = highestRank;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The given character's highest faction rank achieved")
    public Integer getHighestRank() {
        return this.highestRank;
    }

    public void setHighestRank(Integer highestRank) {
        this.highestRank = highestRank;
    }

    public CharacterFwStatsResponse kills(CharacterFwStatsKills kills) {
        this.kills = kills;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CharacterFwStatsKills getKills() {
        return this.kills;
    }

    public void setKills(CharacterFwStatsKills kills) {
        this.kills = kills;
    }

    public CharacterFwStatsResponse victoryPoints(CharacterFwStatsVictoryPoints victoryPoints) {
        this.victoryPoints = victoryPoints;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CharacterFwStatsVictoryPoints getVictoryPoints() {
        return this.victoryPoints;
    }

    public void setVictoryPoints(CharacterFwStatsVictoryPoints victoryPoints) {
        this.victoryPoints = victoryPoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterFwStatsResponse characterFwStatsResponse = (CharacterFwStatsResponse)o;
        return Objects.equals(this.currentRank, characterFwStatsResponse.currentRank) && Objects.equals(this.enlistedOn, characterFwStatsResponse.enlistedOn) && Objects.equals(this.factionId, characterFwStatsResponse.factionId) && Objects.equals(this.highestRank, characterFwStatsResponse.highestRank) && Objects.equals(this.kills, characterFwStatsResponse.kills) && Objects.equals(this.victoryPoints, characterFwStatsResponse.victoryPoints);
    }

    public int hashCode() {
        return Objects.hash(this.currentRank, this.enlistedOn, this.factionId, this.highestRank, this.kills, this.victoryPoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterFwStatsResponse {\n");
        sb.append("    currentRank: ").append(this.toIndentedString(this.currentRank)).append("\n");
        sb.append("    enlistedOn: ").append(this.toIndentedString(this.enlistedOn)).append("\n");
        sb.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        sb.append("    highestRank: ").append(this.toIndentedString(this.highestRank)).append("\n");
        sb.append("    kills: ").append(this.toIndentedString(this.kills)).append("\n");
        sb.append("    victoryPoints: ").append(this.toIndentedString(this.victoryPoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

