/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.EsiStatusResponse;
import net.troja.eve.esi.model.EsiVerifyResponse;
import okhttp3.Call;

public class MetaApi {
    private ApiClient localVarApiClient;

    public MetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getHeadersCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/headers/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHeadersValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getHeadersCall(_callback);
        return localVarCall;
    }

    public Map<String, String> getHeaders() throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = this.getHeadersWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, String>> getHeadersWithHttpInfo() throws ApiException {
        Call localVarCall = this.getHeadersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHeadersAsync(ApiCallback<Map<String, String>> _callback) throws ApiException {
        Call localVarCall = this.getHeadersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPingCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/ping";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain; charset=utf-8"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPingValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getPingCall(_callback);
        return localVarCall;
    }

    public String getPing() throws ApiException {
        ApiResponse<String> localVarResp = this.getPingWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<String> getPingWithHttpInfo() throws ApiException {
        Call localVarCall = this.getPingValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPingAsync(ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getPingValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStatusCall(String version, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/status.json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStatusValidateBeforeCall(String version, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getStatusCall(version, _callback);
        return localVarCall;
    }

    public List<EsiStatusResponse> getStatus(String version) throws ApiException {
        ApiResponse<List<EsiStatusResponse>> localVarResp = this.getStatusWithHttpInfo(version);
        return localVarResp.getData();
    }

    public ApiResponse<List<EsiStatusResponse>> getStatusWithHttpInfo(String version) throws ApiException {
        Call localVarCall = this.getStatusValidateBeforeCall(version, null);
        Type localVarReturnType = new TypeToken<List<EsiStatusResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStatusAsync(String version, ApiCallback<List<EsiStatusResponse>> _callback) throws ApiException {
        Call localVarCall = this.getStatusValidateBeforeCall(version, _callback);
        Type localVarReturnType = new TypeToken<List<EsiStatusResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getVerifyCall(String userAgent, String xUserAgent, String datasource, String token, String authorization, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/verify/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (userAgent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_agent", userAgent));
        }
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xUserAgent != null) {
            localVarHeaderParams.put("X-User-Agent", this.localVarApiClient.parameterToString(xUserAgent));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getVerifyValidateBeforeCall(String userAgent, String xUserAgent, String datasource, String token, String authorization, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getVerifyCall(userAgent, xUserAgent, datasource, token, authorization, _callback);
        return localVarCall;
    }

    public EsiVerifyResponse getVerify(String userAgent, String xUserAgent, String datasource, String token, String authorization) throws ApiException {
        ApiResponse<EsiVerifyResponse> localVarResp = this.getVerifyWithHttpInfo(userAgent, xUserAgent, datasource, token, authorization);
        return localVarResp.getData();
    }

    public ApiResponse<EsiVerifyResponse> getVerifyWithHttpInfo(String userAgent, String xUserAgent, String datasource, String token, String authorization) throws ApiException {
        Call localVarCall = this.getVerifyValidateBeforeCall(userAgent, xUserAgent, datasource, token, authorization, null);
        Type localVarReturnType = new TypeToken<EsiVerifyResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getVerifyAsync(String userAgent, String xUserAgent, String datasource, String token, String authorization, ApiCallback<EsiVerifyResponse> _callback) throws ApiException {
        Call localVarCall = this.getVerifyValidateBeforeCall(userAgent, xUserAgent, datasource, token, authorization, _callback);
        Type localVarReturnType = new TypeToken<EsiVerifyResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getVersionsCall(String userAgent, String xUserAgent, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/versions/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (userAgent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_agent", userAgent));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xUserAgent != null) {
            localVarHeaderParams.put("X-User-Agent", this.localVarApiClient.parameterToString(xUserAgent));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getVersionsValidateBeforeCall(String userAgent, String xUserAgent, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getVersionsCall(userAgent, xUserAgent, _callback);
        return localVarCall;
    }

    public List<String> getVersions(String userAgent, String xUserAgent) throws ApiException {
        ApiResponse<List<String>> localVarResp = this.getVersionsWithHttpInfo(userAgent, xUserAgent);
        return localVarResp.getData();
    }

    public ApiResponse<List<String>> getVersionsWithHttpInfo(String userAgent, String xUserAgent) throws ApiException {
        Call localVarCall = this.getVersionsValidateBeforeCall(userAgent, xUserAgent, null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getVersionsAsync(String userAgent, String xUserAgent, ApiCallback<List<String>> _callback) throws ApiException {
        Call localVarCall = this.getVersionsValidateBeforeCall(userAgent, xUserAgent, _callback);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

