/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterLoyaltyPointsResponse;
import net.troja.eve.esi.model.LoyaltyStoreOffersResponse;
import okhttp3.Call;

public class LoyaltyApi {
    private ApiClient localVarApiClient;

    public LoyaltyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LoyaltyApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getCharactersCharacterIdLoyaltyPointsCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/characters/{character_id}/loyalty/points/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdLoyaltyPointsValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdLoyaltyPoints(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdLoyaltyPointsCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CharacterLoyaltyPointsResponse> getCharactersCharacterIdLoyaltyPoints(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterLoyaltyPointsResponse>> localVarResp = this.getCharactersCharacterIdLoyaltyPointsWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterLoyaltyPointsResponse>> getCharactersCharacterIdLoyaltyPointsWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdLoyaltyPointsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterLoyaltyPointsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdLoyaltyPointsAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterLoyaltyPointsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdLoyaltyPointsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterLoyaltyPointsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLoyaltyStoresCorporationIdOffersCall(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/loyalty/stores/{corporation_id}/offers/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLoyaltyStoresCorporationIdOffersValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getLoyaltyStoresCorporationIdOffers(Async)");
        }
        Call localVarCall = this.getLoyaltyStoresCorporationIdOffersCall(corporationId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<LoyaltyStoreOffersResponse> getLoyaltyStoresCorporationIdOffers(Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<LoyaltyStoreOffersResponse>> localVarResp = this.getLoyaltyStoresCorporationIdOffersWithHttpInfo(corporationId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<LoyaltyStoreOffersResponse>> getLoyaltyStoresCorporationIdOffersWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getLoyaltyStoresCorporationIdOffersValidateBeforeCall(corporationId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<LoyaltyStoreOffersResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLoyaltyStoresCorporationIdOffersAsync(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback<List<LoyaltyStoreOffersResponse>> _callback) throws ApiException {
        Call localVarCall = this.getLoyaltyStoresCorporationIdOffersValidateBeforeCall(corporationId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<LoyaltyStoreOffersResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

