/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 1.7.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterOrdersHistoryResponse;
import net.troja.eve.esi.model.CharacterOrdersResponse;
import net.troja.eve.esi.model.CorporationOrdersHistoryResponse;
import net.troja.eve.esi.model.CorporationOrdersResponse;
import net.troja.eve.esi.model.MarketGroupResponse;
import net.troja.eve.esi.model.MarketHistoryResponse;
import net.troja.eve.esi.model.MarketOrdersResponse;
import net.troja.eve.esi.model.MarketPricesResponse;
import net.troja.eve.esi.model.MarketStructuresResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarketApi {
    private ApiClient localVarApiClient;

    public MarketApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MarketApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getCharactersCharacterIdOrders
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Open market orders placed by a character</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getCharactersCharacterIdOrdersCall(Integer characterId, String datasource, String ifNoneMatch,
            String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/orders/".replaceAll("\\{" + "character_id" + "\\}",
                localVarApiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCharactersCharacterIdOrdersValidateBeforeCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdOrders(Async)");
        }

        okhttp3.Call localVarCall = getCharactersCharacterIdOrdersCall(characterId, datasource, ifNoneMatch, token,
                _callback);
        return localVarCall;

    }

    /**
     * List open orders from a character List open market orders placed by a
     * character --- This route is cached for up to 1200 seconds SSO Scope:
     * esi-markets.read_character_orders.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterOrdersResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Open market orders placed by a character</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<CharacterOrdersResponse> getCharactersCharacterIdOrders(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterOrdersResponse>> localVarResp = getCharactersCharacterIdOrdersWithHttpInfo(
                characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * List open orders from a character List open market orders placed by a
     * character --- This route is cached for up to 1200 seconds SSO Scope:
     * esi-markets.read_character_orders.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterOrdersResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Open market orders placed by a character</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<CharacterOrdersResponse>> getCharactersCharacterIdOrdersWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCharactersCharacterIdOrdersValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterOrdersResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List open orders from a character (asynchronously) List open market
     * orders placed by a character --- This route is cached for up to 1200
     * seconds SSO Scope: esi-markets.read_character_orders.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Open market orders placed by a character</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getCharactersCharacterIdOrdersAsync(Integer characterId, String datasource, String ifNoneMatch,
            String token, final ApiCallback<List<CharacterOrdersResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCharactersCharacterIdOrdersValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterOrdersResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCharactersCharacterIdOrdersHistory
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Expired and cancelled market orders placed by
     *                        a character</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getCharactersCharacterIdOrdersHistoryCall(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/orders/history/".replaceAll(
                "\\{" + "character_id" + "\\}", localVarApiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCharactersCharacterIdOrdersHistoryValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdOrdersHistory(Async)");
        }

        okhttp3.Call localVarCall = getCharactersCharacterIdOrdersHistoryCall(characterId, datasource, ifNoneMatch,
                page, token, _callback);
        return localVarCall;

    }

    /**
     * List historical orders by a character List cancelled and expired market
     * orders placed by a character up to 90 days in the past. --- This route is
     * cached for up to 3600 seconds SSO Scope:
     * esi-markets.read_character_orders.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterOrdersHistoryResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Expired and cancelled market orders placed by
     *                        a character</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<CharacterOrdersHistoryResponse> getCharactersCharacterIdOrdersHistory(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CharacterOrdersHistoryResponse>> localVarResp = getCharactersCharacterIdOrdersHistoryWithHttpInfo(
                characterId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * List historical orders by a character List cancelled and expired market
     * orders placed by a character up to 90 days in the past. --- This route is
     * cached for up to 3600 seconds SSO Scope:
     * esi-markets.read_character_orders.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterOrdersHistoryResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Expired and cancelled market orders placed by
     *                        a character</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<CharacterOrdersHistoryResponse>> getCharactersCharacterIdOrdersHistoryWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        okhttp3.Call localVarCall = getCharactersCharacterIdOrdersHistoryValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterOrdersHistoryResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List historical orders by a character (asynchronously) List cancelled and
     * expired market orders placed by a character up to 90 days in the past.
     * --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-markets.read_character_orders.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Expired and cancelled market orders placed by
     *                        a character</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getCharactersCharacterIdOrdersHistoryAsync(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CharacterOrdersHistoryResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCharactersCharacterIdOrdersHistoryValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterOrdersHistoryResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdOrders
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of open market orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getCorporationsCorporationIdOrdersCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v3/corporations/{corporation_id}/orders/".replaceAll("\\{" + "corporation_id" + "\\}",
                localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdOrdersValidateBeforeCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdOrders(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdOrdersCall(corporationId, datasource, ifNoneMatch,
                page, token, _callback);
        return localVarCall;

    }

    /**
     * List open orders from a corporation List open market orders placed on
     * behalf of a corporation --- This route is cached for up to 1200 seconds
     * --- Requires one of the following EVE corporation role(s): Accountant,
     * Trader SSO Scope: esi-markets.read_corporation_orders.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationOrdersResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of open market orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<CorporationOrdersResponse> getCorporationsCorporationIdOrders(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationOrdersResponse>> localVarResp = getCorporationsCorporationIdOrdersWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * List open orders from a corporation List open market orders placed on
     * behalf of a corporation --- This route is cached for up to 1200 seconds
     * --- Requires one of the following EVE corporation role(s): Accountant,
     * Trader SSO Scope: esi-markets.read_corporation_orders.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationOrdersResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of open market orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<CorporationOrdersResponse>> getCorporationsCorporationIdOrdersWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdOrdersValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationOrdersResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List open orders from a corporation (asynchronously) List open market
     * orders placed on behalf of a corporation --- This route is cached for up
     * to 1200 seconds --- Requires one of the following EVE corporation
     * role(s): Accountant, Trader SSO Scope:
     * esi-markets.read_corporation_orders.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of open market orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getCorporationsCorporationIdOrdersAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback<List<CorporationOrdersResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdOrdersValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationOrdersResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdOrdersHistory
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Expired and cancelled market orders placed on
     *                        behalf of a corporation</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getCorporationsCorporationIdOrdersHistoryCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/corporations/{corporation_id}/orders/history/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdOrdersHistoryValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdOrdersHistory(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdOrdersHistoryCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        return localVarCall;

    }

    /**
     * List historical orders from a corporation List cancelled and expired
     * market orders placed on behalf of a corporation up to 90 days in the
     * past. --- This route is cached for up to 3600 seconds --- Requires one of
     * the following EVE corporation role(s): Accountant, Trader SSO Scope:
     * esi-markets.read_corporation_orders.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationOrdersHistoryResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Expired and cancelled market orders placed on
     *                        behalf of a corporation</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<CorporationOrdersHistoryResponse> getCorporationsCorporationIdOrdersHistory(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationOrdersHistoryResponse>> localVarResp = getCorporationsCorporationIdOrdersHistoryWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * List historical orders from a corporation List cancelled and expired
     * market orders placed on behalf of a corporation up to 90 days in the
     * past. --- This route is cached for up to 3600 seconds --- Requires one of
     * the following EVE corporation role(s): Accountant, Trader SSO Scope:
     * esi-markets.read_corporation_orders.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationOrdersHistoryResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Expired and cancelled market orders placed on
     *                        behalf of a corporation</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<CorporationOrdersHistoryResponse>> getCorporationsCorporationIdOrdersHistoryWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdOrdersHistoryValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationOrdersHistoryResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List historical orders from a corporation (asynchronously) List cancelled
     * and expired market orders placed on behalf of a corporation up to 90 days
     * in the past. --- This route is cached for up to 3600 seconds --- Requires
     * one of the following EVE corporation role(s): Accountant, Trader SSO
     * Scope: esi-markets.read_corporation_orders.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Expired and cancelled market orders placed on
     *                        behalf of a corporation</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getCorporationsCorporationIdOrdersHistoryAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationOrdersHistoryResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdOrdersHistoryValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationOrdersHistoryResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getMarketsGroups
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item group ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsGroupsCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/markets/groups/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarketsGroupsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getMarketsGroupsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get item groups Get a list of item groups --- This route expires daily at
     * 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item group ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getMarketsGroups(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getMarketsGroupsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get item groups Get a list of item groups --- This route expires daily at
     * 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item group ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getMarketsGroupsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        okhttp3.Call localVarCall = getMarketsGroupsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get item groups (asynchronously) Get a list of item groups --- This route
     * expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item group ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsGroupsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMarketsGroupsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getMarketsGroupsMarketGroupId
     * 
     * @param marketGroupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item group</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsGroupsMarketGroupIdCall(Integer marketGroupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/markets/groups/{market_group_id}/".replaceAll("\\{" + "market_group_id" + "\\}",
                localVarApiClient.escapeString(marketGroupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarketsGroupsMarketGroupIdValidateBeforeCall(Integer marketGroupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'marketGroupId' is set
        if (marketGroupId == null) {
            throw new ApiException(
                    "Missing the required parameter 'marketGroupId' when calling getMarketsGroupsMarketGroupId(Async)");
        }

        okhttp3.Call localVarCall = getMarketsGroupsMarketGroupIdCall(marketGroupId, acceptLanguage, datasource,
                ifNoneMatch, language, _callback);
        return localVarCall;

    }

    /**
     * Get item group information Get information on an item group --- This
     * route expires daily at 11:05
     * 
     * @param marketGroupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return MarketGroupResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item group</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public MarketGroupResponse getMarketsGroupsMarketGroupId(Integer marketGroupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<MarketGroupResponse> localVarResp = getMarketsGroupsMarketGroupIdWithHttpInfo(marketGroupId,
                acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get item group information Get information on an item group --- This
     * route expires daily at 11:05
     * 
     * @param marketGroupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;MarketGroupResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item group</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<MarketGroupResponse> getMarketsGroupsMarketGroupIdWithHttpInfo(Integer marketGroupId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getMarketsGroupsMarketGroupIdValidateBeforeCall(marketGroupId, acceptLanguage,
                datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<MarketGroupResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get item group information (asynchronously) Get information on an item
     * group --- This route expires daily at 11:05
     * 
     * @param marketGroupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item group</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsGroupsMarketGroupIdAsync(Integer marketGroupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback<MarketGroupResponse> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getMarketsGroupsMarketGroupIdValidateBeforeCall(marketGroupId, acceptLanguage,
                datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<MarketGroupResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getMarketsPrices
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of prices</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsPricesCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/markets/prices/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarketsPricesValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getMarketsPricesCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * List market prices Return a list of prices --- This route is cached for
     * up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;MarketPricesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of prices</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<MarketPricesResponse> getMarketsPrices(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<MarketPricesResponse>> localVarResp = getMarketsPricesWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * List market prices Return a list of prices --- This route is cached for
     * up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;MarketPricesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of prices</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<MarketPricesResponse>> getMarketsPricesWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        okhttp3.Call localVarCall = getMarketsPricesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<MarketPricesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List market prices (asynchronously) Return a list of prices --- This
     * route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of prices</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsPricesAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<MarketPricesResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMarketsPricesValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<MarketPricesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getMarketsRegionIdHistory
     * 
     * @param regionId
     *            Return statistics in this region (required)
     * @param typeId
     *            Return statistics for this type (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of historical market statistics</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsRegionIdHistoryCall(Integer regionId, Integer typeId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/markets/{region_id}/history/".replaceAll("\\{" + "region_id" + "\\}",
                localVarApiClient.escapeString(regionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (typeId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type_id", typeId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarketsRegionIdHistoryValidateBeforeCall(Integer regionId, Integer typeId,
            String datasource, String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'regionId' is set
        if (regionId == null) {
            throw new ApiException(
                    "Missing the required parameter 'regionId' when calling getMarketsRegionIdHistory(Async)");
        }

        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException(
                    "Missing the required parameter 'typeId' when calling getMarketsRegionIdHistory(Async)");
        }

        okhttp3.Call localVarCall = getMarketsRegionIdHistoryCall(regionId, typeId, datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * List historical market statistics in a region Return a list of historical
     * market statistics for the specified type in a region --- This route
     * expires daily at 11:05
     * 
     * @param regionId
     *            Return statistics in this region (required)
     * @param typeId
     *            Return statistics for this type (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;MarketHistoryResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of historical market statistics</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<MarketHistoryResponse> getMarketsRegionIdHistory(Integer regionId, Integer typeId, String datasource,
            String ifNoneMatch) throws ApiException {
        ApiResponse<List<MarketHistoryResponse>> localVarResp = getMarketsRegionIdHistoryWithHttpInfo(regionId, typeId,
                datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * List historical market statistics in a region Return a list of historical
     * market statistics for the specified type in a region --- This route
     * expires daily at 11:05
     * 
     * @param regionId
     *            Return statistics in this region (required)
     * @param typeId
     *            Return statistics for this type (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;MarketHistoryResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of historical market statistics</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<MarketHistoryResponse>> getMarketsRegionIdHistoryWithHttpInfo(Integer regionId,
            Integer typeId, String datasource, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getMarketsRegionIdHistoryValidateBeforeCall(regionId, typeId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<MarketHistoryResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List historical market statistics in a region (asynchronously) Return a
     * list of historical market statistics for the specified type in a region
     * --- This route expires daily at 11:05
     * 
     * @param regionId
     *            Return statistics in this region (required)
     * @param typeId
     *            Return statistics for this type (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of historical market statistics</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsRegionIdHistoryAsync(Integer regionId, Integer typeId, String datasource,
            String ifNoneMatch, final ApiCallback<List<MarketHistoryResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMarketsRegionIdHistoryValidateBeforeCall(regionId, typeId, datasource,
                ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<MarketHistoryResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getMarketsRegionIdOrders
     * 
     * @param orderType
     *            Filter buy/sell orders, return all orders by default. If you
     *            query without type_id, we always return both buy and sell
     *            orders (required)
     * @param regionId
     *            Return orders in this region (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param typeId
     *            Return orders only for this type (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsRegionIdOrdersCall(String orderType, Integer regionId, String datasource,
            String ifNoneMatch, Integer page, Integer typeId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/markets/{region_id}/orders/".replaceAll("\\{" + "region_id" + "\\}",
                localVarApiClient.escapeString(regionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (orderType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("order_type", orderType));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (typeId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type_id", typeId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarketsRegionIdOrdersValidateBeforeCall(String orderType, Integer regionId,
            String datasource, String ifNoneMatch, Integer page, Integer typeId, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'orderType' is set
        if (orderType == null) {
            throw new ApiException(
                    "Missing the required parameter 'orderType' when calling getMarketsRegionIdOrders(Async)");
        }

        // verify the required parameter 'regionId' is set
        if (regionId == null) {
            throw new ApiException(
                    "Missing the required parameter 'regionId' when calling getMarketsRegionIdOrders(Async)");
        }

        okhttp3.Call localVarCall = getMarketsRegionIdOrdersCall(orderType, regionId, datasource, ifNoneMatch, page,
                typeId, _callback);
        return localVarCall;

    }

    /**
     * List orders in a region Return a list of orders in a region --- This
     * route is cached for up to 300 seconds
     * 
     * @param orderType
     *            Filter buy/sell orders, return all orders by default. If you
     *            query without type_id, we always return both buy and sell
     *            orders (required)
     * @param regionId
     *            Return orders in this region (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param typeId
     *            Return orders only for this type (optional)
     * @return List&lt;MarketOrdersResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<MarketOrdersResponse> getMarketsRegionIdOrders(String orderType, Integer regionId, String datasource,
            String ifNoneMatch, Integer page, Integer typeId) throws ApiException {
        ApiResponse<List<MarketOrdersResponse>> localVarResp = getMarketsRegionIdOrdersWithHttpInfo(orderType,
                regionId, datasource, ifNoneMatch, page, typeId);
        return localVarResp.getData();
    }

    /**
     * List orders in a region Return a list of orders in a region --- This
     * route is cached for up to 300 seconds
     * 
     * @param orderType
     *            Filter buy/sell orders, return all orders by default. If you
     *            query without type_id, we always return both buy and sell
     *            orders (required)
     * @param regionId
     *            Return orders in this region (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param typeId
     *            Return orders only for this type (optional)
     * @return ApiResponse&lt;List&lt;MarketOrdersResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<MarketOrdersResponse>> getMarketsRegionIdOrdersWithHttpInfo(String orderType,
            Integer regionId, String datasource, String ifNoneMatch, Integer page, Integer typeId) throws ApiException {
        okhttp3.Call localVarCall = getMarketsRegionIdOrdersValidateBeforeCall(orderType, regionId, datasource,
                ifNoneMatch, page, typeId, null);
        Type localVarReturnType = new TypeToken<List<MarketOrdersResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List orders in a region (asynchronously) Return a list of orders in a
     * region --- This route is cached for up to 300 seconds
     * 
     * @param orderType
     *            Filter buy/sell orders, return all orders by default. If you
     *            query without type_id, we always return both buy and sell
     *            orders (required)
     * @param regionId
     *            Return orders in this region (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param typeId
     *            Return orders only for this type (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsRegionIdOrdersAsync(String orderType, Integer regionId, String datasource,
            String ifNoneMatch, Integer page, Integer typeId, final ApiCallback<List<MarketOrdersResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getMarketsRegionIdOrdersValidateBeforeCall(orderType, regionId, datasource,
                ifNoneMatch, page, typeId, _callback);
        Type localVarReturnType = new TypeToken<List<MarketOrdersResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getMarketsRegionIdTypes
     * 
     * @param regionId
     *            Return statistics in this region (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of type IDs</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsRegionIdTypesCall(Integer regionId, String datasource, String ifNoneMatch,
            Integer page, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/markets/{region_id}/types/".replaceAll("\\{" + "region_id" + "\\}",
                localVarApiClient.escapeString(regionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarketsRegionIdTypesValidateBeforeCall(Integer regionId, String datasource,
            String ifNoneMatch, Integer page, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'regionId' is set
        if (regionId == null) {
            throw new ApiException(
                    "Missing the required parameter 'regionId' when calling getMarketsRegionIdTypes(Async)");
        }

        okhttp3.Call localVarCall = getMarketsRegionIdTypesCall(regionId, datasource, ifNoneMatch, page, _callback);
        return localVarCall;

    }

    /**
     * List type IDs relevant to a market Return a list of type IDs that have
     * active orders in the region, for efficient market indexing. --- This
     * route is cached for up to 600 seconds
     * 
     * @param regionId
     *            Return statistics in this region (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of type IDs</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getMarketsRegionIdTypes(Integer regionId, String datasource, String ifNoneMatch, Integer page)
            throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getMarketsRegionIdTypesWithHttpInfo(regionId, datasource,
                ifNoneMatch, page);
        return localVarResp.getData();
    }

    /**
     * List type IDs relevant to a market Return a list of type IDs that have
     * active orders in the region, for efficient market indexing. --- This
     * route is cached for up to 600 seconds
     * 
     * @param regionId
     *            Return statistics in this region (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of type IDs</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getMarketsRegionIdTypesWithHttpInfo(Integer regionId, String datasource,
            String ifNoneMatch, Integer page) throws ApiException {
        okhttp3.Call localVarCall = getMarketsRegionIdTypesValidateBeforeCall(regionId, datasource, ifNoneMatch, page,
                null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List type IDs relevant to a market (asynchronously) Return a list of type
     * IDs that have active orders in the region, for efficient market indexing.
     * --- This route is cached for up to 600 seconds
     * 
     * @param regionId
     *            Return statistics in this region (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of type IDs</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsRegionIdTypesAsync(Integer regionId, String datasource, String ifNoneMatch,
            Integer page, final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMarketsRegionIdTypesValidateBeforeCall(regionId, datasource, ifNoneMatch, page,
                _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getMarketsStructuresStructureId
     * 
     * @param structureId
     *            Return orders in this structure (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsStructuresStructureIdCall(Long structureId, String datasource, String ifNoneMatch,
            Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/markets/structures/{structure_id}/".replaceAll("\\{" + "structure_id" + "\\}",
                localVarApiClient.escapeString(structureId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarketsStructuresStructureIdValidateBeforeCall(Long structureId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'structureId' is set
        if (structureId == null) {
            throw new ApiException(
                    "Missing the required parameter 'structureId' when calling getMarketsStructuresStructureId(Async)");
        }

        okhttp3.Call localVarCall = getMarketsStructuresStructureIdCall(structureId, datasource, ifNoneMatch, page,
                token, _callback);
        return localVarCall;

    }

    /**
     * List orders in a structure Return all orders in a structure --- This
     * route is cached for up to 300 seconds SSO Scope:
     * esi-markets.structure_markets.v1
     * 
     * @param structureId
     *            Return orders in this structure (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;MarketStructuresResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<MarketStructuresResponse> getMarketsStructuresStructureId(Long structureId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<MarketStructuresResponse>> localVarResp = getMarketsStructuresStructureIdWithHttpInfo(
                structureId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * List orders in a structure Return all orders in a structure --- This
     * route is cached for up to 300 seconds SSO Scope:
     * esi-markets.structure_markets.v1
     * 
     * @param structureId
     *            Return orders in this structure (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;MarketStructuresResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<MarketStructuresResponse>> getMarketsStructuresStructureIdWithHttpInfo(Long structureId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        okhttp3.Call localVarCall = getMarketsStructuresStructureIdValidateBeforeCall(structureId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<MarketStructuresResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List orders in a structure (asynchronously) Return all orders in a
     * structure --- This route is cached for up to 300 seconds SSO Scope:
     * esi-markets.structure_markets.v1
     * 
     * @param structureId
     *            Return orders in this structure (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of orders</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getMarketsStructuresStructureIdAsync(Long structureId, String datasource, String ifNoneMatch,
            Integer page, String token, final ApiCallback<List<MarketStructuresResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getMarketsStructuresStructureIdValidateBeforeCall(structureId, datasource,
                ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<MarketStructuresResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
