/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.Position;
import net.troja.eve.esi.model.SystemPlanet;

@ApiModel(description="200 ok object")
public class SystemResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONSTELLATION_ID = "constellation_id";
    @SerializedName(value="constellation_id")
    private Integer constellationId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PLANETS = "planets";
    @SerializedName(value="planets")
    private List<SystemPlanet> planets = null;
    public static final String SERIALIZED_NAME_POSITION = "position";
    @SerializedName(value="position")
    private Position position;
    public static final String SERIALIZED_NAME_SECURITY_CLASS = "security_class";
    @SerializedName(value="security_class")
    private String securityClass;
    public static final String SERIALIZED_NAME_SECURITY_STATUS = "security_status";
    @SerializedName(value="security_status")
    private Float securityStatus;
    public static final String SERIALIZED_NAME_STAR_ID = "star_id";
    @SerializedName(value="star_id")
    private Integer starId;
    public static final String SERIALIZED_NAME_STARGATES = "stargates";
    @SerializedName(value="stargates")
    private List<Integer> stargates = null;
    public static final String SERIALIZED_NAME_STATIONS = "stations";
    @SerializedName(value="stations")
    private List<Integer> stations = null;
    public static final String SERIALIZED_NAME_SYSTEM_ID = "system_id";
    @SerializedName(value="system_id")
    private Integer systemId;

    public SystemResponse constellationId(Integer constellationId) {
        this.constellationId = constellationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The constellation this solar system is in")
    public Integer getConstellationId() {
        return this.constellationId;
    }

    public void setConstellationId(Integer constellationId) {
        this.constellationId = constellationId;
    }

    public SystemResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name string")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SystemResponse planets(List<SystemPlanet> planets) {
        this.planets = planets;
        return this;
    }

    public SystemResponse addPlanetsItem(SystemPlanet planetsItem) {
        if (this.planets == null) {
            this.planets = new ArrayList<SystemPlanet>();
        }
        this.planets.add(planetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="planets array")
    public List<SystemPlanet> getPlanets() {
        return this.planets;
    }

    public void setPlanets(List<SystemPlanet> planets) {
        this.planets = planets;
    }

    public SystemResponse position(Position position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public SystemResponse securityClass(String securityClass) {
        this.securityClass = securityClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="security_class string")
    public String getSecurityClass() {
        return this.securityClass;
    }

    public void setSecurityClass(String securityClass) {
        this.securityClass = securityClass;
    }

    public SystemResponse securityStatus(Float securityStatus) {
        this.securityStatus = securityStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="security_status number")
    public Float getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(Float securityStatus) {
        this.securityStatus = securityStatus;
    }

    public SystemResponse starId(Integer starId) {
        this.starId = starId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="star_id integer")
    public Integer getStarId() {
        return this.starId;
    }

    public void setStarId(Integer starId) {
        this.starId = starId;
    }

    public SystemResponse stargates(List<Integer> stargates) {
        this.stargates = stargates;
        return this;
    }

    public SystemResponse addStargatesItem(Integer stargatesItem) {
        if (this.stargates == null) {
            this.stargates = new ArrayList<Integer>();
        }
        this.stargates.add(stargatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="stargates array")
    public List<Integer> getStargates() {
        return this.stargates;
    }

    public void setStargates(List<Integer> stargates) {
        this.stargates = stargates;
    }

    public SystemResponse stations(List<Integer> stations) {
        this.stations = stations;
        return this;
    }

    public SystemResponse addStationsItem(Integer stationsItem) {
        if (this.stations == null) {
            this.stations = new ArrayList<Integer>();
        }
        this.stations.add(stationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="stations array")
    public List<Integer> getStations() {
        return this.stations;
    }

    public void setStations(List<Integer> stations) {
        this.stations = stations;
    }

    public SystemResponse systemId(Integer systemId) {
        this.systemId = systemId;
        return this;
    }

    @ApiModelProperty(required=true, value="system_id integer")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer systemId) {
        this.systemId = systemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemResponse systemResponse = (SystemResponse)o;
        return Objects.equals(this.constellationId, systemResponse.constellationId) && Objects.equals(this.name, systemResponse.name) && Objects.equals(this.planets, systemResponse.planets) && Objects.equals(this.position, systemResponse.position) && Objects.equals(this.securityClass, systemResponse.securityClass) && Objects.equals(this.securityStatus, systemResponse.securityStatus) && Objects.equals(this.starId, systemResponse.starId) && Objects.equals(this.stargates, systemResponse.stargates) && Objects.equals(this.stations, systemResponse.stations) && Objects.equals(this.systemId, systemResponse.systemId);
    }

    public int hashCode() {
        return Objects.hash(this.constellationId, this.name, this.planets, this.position, this.securityClass, this.securityStatus, this.starId, this.stargates, this.stations, this.systemId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemResponse {\n");
        sb.append("    constellationId: ").append(this.toIndentedString(this.constellationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    planets: ").append(this.toIndentedString(this.planets)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    securityClass: ").append(this.toIndentedString(this.securityClass)).append("\n");
        sb.append("    securityStatus: ").append(this.toIndentedString(this.securityStatus)).append("\n");
        sb.append("    starId: ").append(this.toIndentedString(this.starId)).append("\n");
        sb.append("    stargates: ").append(this.toIndentedString(this.stargates)).append("\n");
        sb.append("    stations: ").append(this.toIndentedString(this.stations)).append("\n");
        sb.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

