/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.StructureService;

@ApiModel(description="200 ok object")
public class CorporationStructuresResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CORPORATION_ID = "corporation_id";
    @SerializedName(value="corporation_id")
    private Integer corporationId;
    public static final String SERIALIZED_NAME_FUEL_EXPIRES = "fuel_expires";
    @SerializedName(value="fuel_expires")
    private OffsetDateTime fuelExpires;
    public static final String SERIALIZED_NAME_NEXT_REINFORCE_APPLY = "next_reinforce_apply";
    @SerializedName(value="next_reinforce_apply")
    private OffsetDateTime nextReinforceApply;
    public static final String SERIALIZED_NAME_NEXT_REINFORCE_HOUR = "next_reinforce_hour";
    @SerializedName(value="next_reinforce_hour")
    private Integer nextReinforceHour;
    public static final String SERIALIZED_NAME_NEXT_REINFORCE_WEEKDAY = "next_reinforce_weekday";
    @SerializedName(value="next_reinforce_weekday")
    private Integer nextReinforceWeekday;
    public static final String SERIALIZED_NAME_PROFILE_ID = "profile_id";
    @SerializedName(value="profile_id")
    private Integer profileId;
    public static final String SERIALIZED_NAME_REINFORCE_HOUR = "reinforce_hour";
    @SerializedName(value="reinforce_hour")
    private Integer reinforceHour;
    public static final String SERIALIZED_NAME_REINFORCE_WEEKDAY = "reinforce_weekday";
    @SerializedName(value="reinforce_weekday")
    private Integer reinforceWeekday;
    public static final String SERIALIZED_NAME_SERVICES = "services";
    @SerializedName(value="services")
    private List<StructureService> services = null;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    private StateEnum stateEnum;
    public static final String SERIALIZED_NAME_STATE_TIMER_END = "state_timer_end";
    @SerializedName(value="state_timer_end")
    private OffsetDateTime stateTimerEnd;
    public static final String SERIALIZED_NAME_STATE_TIMER_START = "state_timer_start";
    @SerializedName(value="state_timer_start")
    private OffsetDateTime stateTimerStart;
    public static final String SERIALIZED_NAME_STRUCTURE_ID = "structure_id";
    @SerializedName(value="structure_id")
    private Long structureId;
    public static final String SERIALIZED_NAME_SYSTEM_ID = "system_id";
    @SerializedName(value="system_id")
    private Integer systemId;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_UNANCHORS_AT = "unanchors_at";
    @SerializedName(value="unanchors_at")
    private OffsetDateTime unanchorsAt;

    public CorporationStructuresResponse corporationId(Integer corporationId) {
        this.corporationId = corporationId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the corporation that owns the structure")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer corporationId) {
        this.corporationId = corporationId;
    }

    public CorporationStructuresResponse fuelExpires(OffsetDateTime fuelExpires) {
        this.fuelExpires = fuelExpires;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date on which the structure will run out of fuel")
    public OffsetDateTime getFuelExpires() {
        return this.fuelExpires;
    }

    public void setFuelExpires(OffsetDateTime fuelExpires) {
        this.fuelExpires = fuelExpires;
    }

    public CorporationStructuresResponse nextReinforceApply(OffsetDateTime nextReinforceApply) {
        this.nextReinforceApply = nextReinforceApply;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the structure's newly requested reinforcement times (e.g. next_reinforce_hour and next_reinforce_day) will take effect")
    public OffsetDateTime getNextReinforceApply() {
        return this.nextReinforceApply;
    }

    public void setNextReinforceApply(OffsetDateTime nextReinforceApply) {
        this.nextReinforceApply = nextReinforceApply;
    }

    public CorporationStructuresResponse nextReinforceHour(Integer nextReinforceHour) {
        this.nextReinforceHour = nextReinforceHour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The requested change to reinforce_hour that will take effect at the time shown by next_reinforce_apply")
    public Integer getNextReinforceHour() {
        return this.nextReinforceHour;
    }

    public void setNextReinforceHour(Integer nextReinforceHour) {
        this.nextReinforceHour = nextReinforceHour;
    }

    public CorporationStructuresResponse nextReinforceWeekday(Integer nextReinforceWeekday) {
        this.nextReinforceWeekday = nextReinforceWeekday;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The requested change to reinforce_weekday that will take effect at the time shown by next_reinforce_apply")
    public Integer getNextReinforceWeekday() {
        return this.nextReinforceWeekday;
    }

    public void setNextReinforceWeekday(Integer nextReinforceWeekday) {
        this.nextReinforceWeekday = nextReinforceWeekday;
    }

    public CorporationStructuresResponse profileId(Integer profileId) {
        this.profileId = profileId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the ACL profile for this citadel")
    public Integer getProfileId() {
        return this.profileId;
    }

    public void setProfileId(Integer profileId) {
        this.profileId = profileId;
    }

    public CorporationStructuresResponse reinforceHour(Integer reinforceHour) {
        this.reinforceHour = reinforceHour;
        return this;
    }

    @ApiModelProperty(required=true, value="The hour of day that determines the four hour window when the structure will randomly exit its reinforcement periods and become vulnerable to attack against its armor and/or hull. The structure will become vulnerable at a random time that is +/- 2 hours centered on the value of this property")
    public Integer getReinforceHour() {
        return this.reinforceHour;
    }

    public void setReinforceHour(Integer reinforceHour) {
        this.reinforceHour = reinforceHour;
    }

    public CorporationStructuresResponse reinforceWeekday(Integer reinforceWeekday) {
        this.reinforceWeekday = reinforceWeekday;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day of the week when the structure exits its final reinforcement period and becomes vulnerable to attack against its hull. Monday is 0 and Sunday is 6")
    public Integer getReinforceWeekday() {
        return this.reinforceWeekday;
    }

    public void setReinforceWeekday(Integer reinforceWeekday) {
        this.reinforceWeekday = reinforceWeekday;
    }

    public CorporationStructuresResponse services(List<StructureService> services) {
        this.services = services;
        return this;
    }

    public CorporationStructuresResponse addServicesItem(StructureService servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<StructureService>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains a list of service upgrades, and their state")
    public List<StructureService> getServices() {
        return this.services;
    }

    public void setServices(List<StructureService> services) {
        this.services = services;
    }

    public CorporationStructuresResponse state(StateEnum stateEnum) {
        this.stateEnum = stateEnum;
        return this;
    }

    public CorporationStructuresResponse stateString(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="state string")
    public StateEnum getState() {
        if (this.stateEnum == null) {
            this.stateEnum = StateEnum.fromValue(this.state);
        }
        return this.stateEnum;
    }

    public String getStateString() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.stateEnum = stateEnum;
    }

    public void setStateString(String state) {
        this.state = state;
    }

    public CorporationStructuresResponse stateTimerEnd(OffsetDateTime stateTimerEnd) {
        this.stateTimerEnd = stateTimerEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date at which the structure will move to it's next state")
    public OffsetDateTime getStateTimerEnd() {
        return this.stateTimerEnd;
    }

    public void setStateTimerEnd(OffsetDateTime stateTimerEnd) {
        this.stateTimerEnd = stateTimerEnd;
    }

    public CorporationStructuresResponse stateTimerStart(OffsetDateTime stateTimerStart) {
        this.stateTimerStart = stateTimerStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date at which the structure entered it's current state")
    public OffsetDateTime getStateTimerStart() {
        return this.stateTimerStart;
    }

    public void setStateTimerStart(OffsetDateTime stateTimerStart) {
        this.stateTimerStart = stateTimerStart;
    }

    public CorporationStructuresResponse structureId(Long structureId) {
        this.structureId = structureId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Item ID of the structure")
    public Long getStructureId() {
        return this.structureId;
    }

    public void setStructureId(Long structureId) {
        this.structureId = structureId;
    }

    public CorporationStructuresResponse systemId(Integer systemId) {
        this.systemId = systemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The solar system the structure is in")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer systemId) {
        this.systemId = systemId;
    }

    public CorporationStructuresResponse typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The type id of the structure")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public CorporationStructuresResponse unanchorsAt(OffsetDateTime unanchorsAt) {
        this.unanchorsAt = unanchorsAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date at which the structure will unanchor")
    public OffsetDateTime getUnanchorsAt() {
        return this.unanchorsAt;
    }

    public void setUnanchorsAt(OffsetDateTime unanchorsAt) {
        this.unanchorsAt = unanchorsAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorporationStructuresResponse corporationStructuresResponse = (CorporationStructuresResponse)o;
        return Objects.equals(this.corporationId, corporationStructuresResponse.corporationId) && Objects.equals(this.fuelExpires, corporationStructuresResponse.fuelExpires) && Objects.equals(this.nextReinforceApply, corporationStructuresResponse.nextReinforceApply) && Objects.equals(this.nextReinforceHour, corporationStructuresResponse.nextReinforceHour) && Objects.equals(this.nextReinforceWeekday, corporationStructuresResponse.nextReinforceWeekday) && Objects.equals(this.profileId, corporationStructuresResponse.profileId) && Objects.equals(this.reinforceHour, corporationStructuresResponse.reinforceHour) && Objects.equals(this.reinforceWeekday, corporationStructuresResponse.reinforceWeekday) && Objects.equals(this.services, corporationStructuresResponse.services) && Objects.equals(this.state, corporationStructuresResponse.state) && Objects.equals(this.stateTimerEnd, corporationStructuresResponse.stateTimerEnd) && Objects.equals(this.stateTimerStart, corporationStructuresResponse.stateTimerStart) && Objects.equals(this.structureId, corporationStructuresResponse.structureId) && Objects.equals(this.systemId, corporationStructuresResponse.systemId) && Objects.equals(this.typeId, corporationStructuresResponse.typeId) && Objects.equals(this.unanchorsAt, corporationStructuresResponse.unanchorsAt);
    }

    public int hashCode() {
        return Objects.hash(this.corporationId, this.fuelExpires, this.nextReinforceApply, this.nextReinforceHour, this.nextReinforceWeekday, this.profileId, this.reinforceHour, this.reinforceWeekday, this.services, this.state, this.stateTimerEnd, this.stateTimerStart, this.structureId, this.systemId, this.typeId, this.unanchorsAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationStructuresResponse {\n");
        sb.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        sb.append("    fuelExpires: ").append(this.toIndentedString(this.fuelExpires)).append("\n");
        sb.append("    nextReinforceApply: ").append(this.toIndentedString(this.nextReinforceApply)).append("\n");
        sb.append("    nextReinforceHour: ").append(this.toIndentedString(this.nextReinforceHour)).append("\n");
        sb.append("    nextReinforceWeekday: ").append(this.toIndentedString(this.nextReinforceWeekday)).append("\n");
        sb.append("    profileId: ").append(this.toIndentedString(this.profileId)).append("\n");
        sb.append("    reinforceHour: ").append(this.toIndentedString(this.reinforceHour)).append("\n");
        sb.append("    reinforceWeekday: ").append(this.toIndentedString(this.reinforceWeekday)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    stateTimerEnd: ").append(this.toIndentedString(this.stateTimerEnd)).append("\n");
        sb.append("    stateTimerStart: ").append(this.toIndentedString(this.stateTimerStart)).append("\n");
        sb.append("    structureId: ").append(this.toIndentedString(this.structureId)).append("\n");
        sb.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    unanchorsAt: ").append(this.toIndentedString(this.unanchorsAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ANCHOR_VULNERABLE("anchor_vulnerable"),
        ANCHORING("anchoring"),
        ARMOR_REINFORCE("armor_reinforce"),
        ARMOR_VULNERABLE("armor_vulnerable"),
        DEPLOY_VULNERABLE("deploy_vulnerable"),
        FITTING_INVULNERABLE("fitting_invulnerable"),
        HULL_REINFORCE("hull_reinforce"),
        HULL_VULNERABLE("hull_vulnerable"),
        ONLINE_DEPRECATED("online_deprecated"),
        ONLINING_VULNERABLE("onlining_vulnerable"),
        SHIELD_VULNERABLE("shield_vulnerable"),
        UNANCHORED("unanchored"),
        UNKNOWN("unknown");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

