/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.CorporationFwStatsKills;
import net.troja.eve.esi.model.CorporationFwStatsVictoryPoints;

@ApiModel(description="200 ok object")
public class CorporationFwStatsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ENLISTED_ON = "enlisted_on";
    @SerializedName(value="enlisted_on")
    private OffsetDateTime enlistedOn;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    private Integer factionId;
    public static final String SERIALIZED_NAME_KILLS = "kills";
    @SerializedName(value="kills")
    private CorporationFwStatsKills kills;
    public static final String SERIALIZED_NAME_PILOTS = "pilots";
    @SerializedName(value="pilots")
    private Integer pilots;
    public static final String SERIALIZED_NAME_VICTORY_POINTS = "victory_points";
    @SerializedName(value="victory_points")
    private CorporationFwStatsVictoryPoints victoryPoints;

    public CorporationFwStatsResponse enlistedOn(OffsetDateTime enlistedOn) {
        this.enlistedOn = enlistedOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The enlistment date of the given corporation into faction warfare. Will not be included if corporation is not enlisted in faction warfare")
    public OffsetDateTime getEnlistedOn() {
        return this.enlistedOn;
    }

    public void setEnlistedOn(OffsetDateTime enlistedOn) {
        this.enlistedOn = enlistedOn;
    }

    public CorporationFwStatsResponse factionId(Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The faction the given corporation is enlisted to fight for. Will not be included if corporation is not enlisted in faction warfare")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public CorporationFwStatsResponse kills(CorporationFwStatsKills kills) {
        this.kills = kills;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CorporationFwStatsKills getKills() {
        return this.kills;
    }

    public void setKills(CorporationFwStatsKills kills) {
        this.kills = kills;
    }

    public CorporationFwStatsResponse pilots(Integer pilots) {
        this.pilots = pilots;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How many pilots the enlisted corporation has. Will not be included if corporation is not enlisted in faction warfare")
    public Integer getPilots() {
        return this.pilots;
    }

    public void setPilots(Integer pilots) {
        this.pilots = pilots;
    }

    public CorporationFwStatsResponse victoryPoints(CorporationFwStatsVictoryPoints victoryPoints) {
        this.victoryPoints = victoryPoints;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CorporationFwStatsVictoryPoints getVictoryPoints() {
        return this.victoryPoints;
    }

    public void setVictoryPoints(CorporationFwStatsVictoryPoints victoryPoints) {
        this.victoryPoints = victoryPoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorporationFwStatsResponse corporationFwStatsResponse = (CorporationFwStatsResponse)o;
        return Objects.equals(this.enlistedOn, corporationFwStatsResponse.enlistedOn) && Objects.equals(this.factionId, corporationFwStatsResponse.factionId) && Objects.equals(this.kills, corporationFwStatsResponse.kills) && Objects.equals(this.pilots, corporationFwStatsResponse.pilots) && Objects.equals(this.victoryPoints, corporationFwStatsResponse.victoryPoints);
    }

    public int hashCode() {
        return Objects.hash(this.enlistedOn, this.factionId, this.kills, this.pilots, this.victoryPoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationFwStatsResponse {\n");
        sb.append("    enlistedOn: ").append(this.toIndentedString(this.enlistedOn)).append("\n");
        sb.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        sb.append("    kills: ").append(this.toIndentedString(this.kills)).append("\n");
        sb.append("    pilots: ").append(this.toIndentedString(this.pilots)).append("\n");
        sb.append("    victoryPoints: ").append(this.toIndentedString(this.victoryPoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

