/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="route object")
public class PlanetRoute
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTENT_TYPE_ID = "content_type_id";
    @SerializedName(value="content_type_id")
    private Integer contentTypeId;
    public static final String SERIALIZED_NAME_DESTINATION_PIN_ID = "destination_pin_id";
    @SerializedName(value="destination_pin_id")
    private Long destinationPinId;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Float quantity;
    public static final String SERIALIZED_NAME_ROUTE_ID = "route_id";
    @SerializedName(value="route_id")
    private Long routeId;
    public static final String SERIALIZED_NAME_SOURCE_PIN_ID = "source_pin_id";
    @SerializedName(value="source_pin_id")
    private Long sourcePinId;
    public static final String SERIALIZED_NAME_WAYPOINTS = "waypoints";
    @SerializedName(value="waypoints")
    private List<Long> waypoints = null;

    public PlanetRoute contentTypeId(Integer contentTypeId) {
        this.contentTypeId = contentTypeId;
        return this;
    }

    @ApiModelProperty(required=true, value="content_type_id integer")
    public Integer getContentTypeId() {
        return this.contentTypeId;
    }

    public void setContentTypeId(Integer contentTypeId) {
        this.contentTypeId = contentTypeId;
    }

    public PlanetRoute destinationPinId(Long destinationPinId) {
        this.destinationPinId = destinationPinId;
        return this;
    }

    @ApiModelProperty(required=true, value="destination_pin_id integer")
    public Long getDestinationPinId() {
        return this.destinationPinId;
    }

    public void setDestinationPinId(Long destinationPinId) {
        this.destinationPinId = destinationPinId;
    }

    public PlanetRoute quantity(Float quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="quantity number")
    public Float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Float quantity) {
        this.quantity = quantity;
    }

    public PlanetRoute routeId(Long routeId) {
        this.routeId = routeId;
        return this;
    }

    @ApiModelProperty(required=true, value="route_id integer")
    public Long getRouteId() {
        return this.routeId;
    }

    public void setRouteId(Long routeId) {
        this.routeId = routeId;
    }

    public PlanetRoute sourcePinId(Long sourcePinId) {
        this.sourcePinId = sourcePinId;
        return this;
    }

    @ApiModelProperty(required=true, value="source_pin_id integer")
    public Long getSourcePinId() {
        return this.sourcePinId;
    }

    public void setSourcePinId(Long sourcePinId) {
        this.sourcePinId = sourcePinId;
    }

    public PlanetRoute waypoints(List<Long> waypoints) {
        this.waypoints = waypoints;
        return this;
    }

    public PlanetRoute addWaypointsItem(Long waypointsItem) {
        if (this.waypoints == null) {
            this.waypoints = new ArrayList<Long>();
        }
        this.waypoints.add(waypointsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of pin ID waypoints")
    public List<Long> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<Long> waypoints) {
        this.waypoints = waypoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanetRoute planetRoute = (PlanetRoute)o;
        return Objects.equals(this.contentTypeId, planetRoute.contentTypeId) && Objects.equals(this.destinationPinId, planetRoute.destinationPinId) && Objects.equals(this.quantity, planetRoute.quantity) && Objects.equals(this.routeId, planetRoute.routeId) && Objects.equals(this.sourcePinId, planetRoute.sourcePinId) && Objects.equals(this.waypoints, planetRoute.waypoints);
    }

    public int hashCode() {
        return Objects.hash(this.contentTypeId, this.destinationPinId, this.quantity, this.routeId, this.sourcePinId, this.waypoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlanetRoute {\n");
        sb.append("    contentTypeId: ").append(this.toIndentedString(this.contentTypeId)).append("\n");
        sb.append("    destinationPinId: ").append(this.toIndentedString(this.destinationPinId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    routeId: ").append(this.toIndentedString(this.routeId)).append("\n");
        sb.append("    sourcePinId: ").append(this.toIndentedString(this.sourcePinId)).append("\n");
        sb.append("    waypoints: ").append(this.toIndentedString(this.waypoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

