/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Per route status")
public class EsiStatusResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ENDPOINT = "endpoint";
    @SerializedName(value="endpoint")
    private String endpoint;
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    private String method;
    public static final String SERIALIZED_NAME_ROUTE = "route";
    @SerializedName(value="route")
    private String route;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();

    public EsiStatusResponse endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @ApiModelProperty(required=true, value="ESI Endpoint cluster advertising this route")
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public EsiStatusResponse method(String method) {
        this.method = method;
        return this;
    }

    @ApiModelProperty(required=true, value="Swagger defined method")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public EsiStatusResponse route(String route) {
        this.route = route;
        return this;
    }

    @ApiModelProperty(required=true, value="Swagger defined route, not including version prefix")
    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public EsiStatusResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Vague route status. Green is good, yellow is degraded, meaning slow or potentially dropping requests. Red means most requests are not succeeding and/or are very slow (5s+) on average.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public EsiStatusResponse tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public EsiStatusResponse addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Swagger tags applicable to this route")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsiStatusResponse esiStatusResponse = (EsiStatusResponse)o;
        return Objects.equals(this.endpoint, esiStatusResponse.endpoint) && Objects.equals(this.method, esiStatusResponse.method) && Objects.equals(this.route, esiStatusResponse.route) && Objects.equals((Object)this.status, (Object)esiStatusResponse.status) && Objects.equals(this.tags, esiStatusResponse.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endpoint, this.method, this.route, this.status, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EsiStatusResponse {\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    route: ").append(this.toIndentedString(this.route)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        GREEN("green"),
        YELLOW("yellow"),
        RED("red");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

