/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="200 ok object")
public class CharacterResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALLIANCE_ID = "alliance_id";
    @SerializedName(value="alliance_id")
    private Integer allianceId;
    public static final String SERIALIZED_NAME_ANCESTRY_ID = "ancestry_id";
    @SerializedName(value="ancestry_id")
    private Integer ancestryId;
    public static final String SERIALIZED_NAME_BIRTHDAY = "birthday";
    @SerializedName(value="birthday")
    private OffsetDateTime birthday;
    public static final String SERIALIZED_NAME_BLOODLINE_ID = "bloodline_id";
    @SerializedName(value="bloodline_id")
    private Integer bloodlineId;
    public static final String SERIALIZED_NAME_CORPORATION_ID = "corporation_id";
    @SerializedName(value="corporation_id")
    private Integer corporationId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    private Integer factionId;
    public static final String SERIALIZED_NAME_GENDER = "gender";
    @SerializedName(value="gender")
    private GenderEnum gender;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RACE_ID = "race_id";
    @SerializedName(value="race_id")
    private Integer raceId;
    public static final String SERIALIZED_NAME_SECURITY_STATUS = "security_status";
    @SerializedName(value="security_status")
    private Float securityStatus;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;

    public CharacterResponse allianceId(Integer allianceId) {
        this.allianceId = allianceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The character's alliance ID")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer allianceId) {
        this.allianceId = allianceId;
    }

    public CharacterResponse ancestryId(Integer ancestryId) {
        this.ancestryId = ancestryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ancestry_id integer")
    public Integer getAncestryId() {
        return this.ancestryId;
    }

    public void setAncestryId(Integer ancestryId) {
        this.ancestryId = ancestryId;
    }

    public CharacterResponse birthday(OffsetDateTime birthday) {
        this.birthday = birthday;
        return this;
    }

    @ApiModelProperty(required=true, value="Creation date of the character")
    public OffsetDateTime getBirthday() {
        return this.birthday;
    }

    public void setBirthday(OffsetDateTime birthday) {
        this.birthday = birthday;
    }

    public CharacterResponse bloodlineId(Integer bloodlineId) {
        this.bloodlineId = bloodlineId;
        return this;
    }

    @ApiModelProperty(required=true, value="bloodline_id integer")
    public Integer getBloodlineId() {
        return this.bloodlineId;
    }

    public void setBloodlineId(Integer bloodlineId) {
        this.bloodlineId = bloodlineId;
    }

    public CharacterResponse corporationId(Integer corporationId) {
        this.corporationId = corporationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The character's corporation ID")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer corporationId) {
        this.corporationId = corporationId;
    }

    public CharacterResponse description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="description string")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CharacterResponse factionId(Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the faction the character is fighting for, if the character is enlisted in Factional Warfare")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public CharacterResponse gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(required=true, value="gender string")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public CharacterResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name string")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CharacterResponse raceId(Integer raceId) {
        this.raceId = raceId;
        return this;
    }

    @ApiModelProperty(required=true, value="race_id integer")
    public Integer getRaceId() {
        return this.raceId;
    }

    public void setRaceId(Integer raceId) {
        this.raceId = raceId;
    }

    public CharacterResponse securityStatus(Float securityStatus) {
        this.securityStatus = securityStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="security_status number")
    public Float getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(Float securityStatus) {
        this.securityStatus = securityStatus;
    }

    public CharacterResponse title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The individual title of the character")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterResponse characterResponse = (CharacterResponse)o;
        return Objects.equals(this.allianceId, characterResponse.allianceId) && Objects.equals(this.ancestryId, characterResponse.ancestryId) && Objects.equals(this.birthday, characterResponse.birthday) && Objects.equals(this.bloodlineId, characterResponse.bloodlineId) && Objects.equals(this.corporationId, characterResponse.corporationId) && Objects.equals(this.description, characterResponse.description) && Objects.equals(this.factionId, characterResponse.factionId) && Objects.equals((Object)this.gender, (Object)characterResponse.gender) && Objects.equals(this.name, characterResponse.name) && Objects.equals(this.raceId, characterResponse.raceId) && Objects.equals(this.securityStatus, characterResponse.securityStatus) && Objects.equals(this.title, characterResponse.title);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allianceId, this.ancestryId, this.birthday, this.bloodlineId, this.corporationId, this.description, this.factionId, this.gender, this.name, this.raceId, this.securityStatus, this.title});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterResponse {\n");
        sb.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        sb.append("    ancestryId: ").append(this.toIndentedString(this.ancestryId)).append("\n");
        sb.append("    birthday: ").append(this.toIndentedString(this.birthday)).append("\n");
        sb.append("    bloodlineId: ").append(this.toIndentedString(this.bloodlineId)).append("\n");
        sb.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    raceId: ").append(this.toIndentedString(this.raceId)).append("\n");
        sb.append("    securityStatus: ").append(this.toIndentedString(this.securityStatus)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum GenderEnum {
        FEMALE("female"),
        MALE("male");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static GenderEnum fromValue(String value) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<GenderEnum> {
            public void write(JsonWriter jsonWriter, GenderEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public GenderEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return GenderEnum.fromValue(value);
            }
        }
    }
}

