/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CorporationAlliancesHistoryResponse;
import net.troja.eve.esi.model.CorporationBlueprintsResponse;
import net.troja.eve.esi.model.CorporationContainersLogsResponse;
import net.troja.eve.esi.model.CorporationDivisionsResponse;
import net.troja.eve.esi.model.CorporationFacilitiesResponse;
import net.troja.eve.esi.model.CorporationIconsResponse;
import net.troja.eve.esi.model.CorporationMedalsIssuedResponse;
import net.troja.eve.esi.model.CorporationMedalsResponse;
import net.troja.eve.esi.model.CorporationMemberTrackingResponse;
import net.troja.eve.esi.model.CorporationMembersTitlesResponse;
import net.troja.eve.esi.model.CorporationResponse;
import net.troja.eve.esi.model.CorporationRolesHistoryResponse;
import net.troja.eve.esi.model.CorporationRolesResponse;
import net.troja.eve.esi.model.CorporationShareholdersResponse;
import net.troja.eve.esi.model.CorporationStandingsResponse;
import net.troja.eve.esi.model.CorporationStarbaseResponse;
import net.troja.eve.esi.model.CorporationStarbasesResponse;
import net.troja.eve.esi.model.CorporationStructuresResponse;
import net.troja.eve.esi.model.CorporationTitlesResponse;
import okhttp3.Call;

public class CorporationApi {
    private ApiClient localVarApiClient;

    public CorporationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CorporationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getCorporationsCorporationIdCall(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/corporations/{corporation_id}/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationId(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdCall(corporationId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public CorporationResponse getCorporationsCorporationId(Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<CorporationResponse> localVarResp = this.getCorporationsCorporationIdWithHttpInfo(corporationId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<CorporationResponse> getCorporationsCorporationIdWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdValidateBeforeCall(corporationId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<CorporationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdAsync(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback<CorporationResponse> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdValidateBeforeCall(corporationId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<CorporationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdAlliancehistoryCall(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/corporations/{corporation_id}/alliancehistory/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdAlliancehistoryValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdAlliancehistory(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdAlliancehistoryCall(corporationId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<CorporationAlliancesHistoryResponse> getCorporationsCorporationIdAlliancehistory(Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<CorporationAlliancesHistoryResponse>> localVarResp = this.getCorporationsCorporationIdAlliancehistoryWithHttpInfo(corporationId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationAlliancesHistoryResponse>> getCorporationsCorporationIdAlliancehistoryWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdAlliancehistoryValidateBeforeCall(corporationId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<CorporationAlliancesHistoryResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdAlliancehistoryAsync(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback<List<CorporationAlliancesHistoryResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdAlliancehistoryValidateBeforeCall(corporationId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationAlliancesHistoryResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdBlueprintsCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/corporations/{corporation_id}/blueprints/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdBlueprintsValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdBlueprints(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdBlueprintsCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationBlueprintsResponse> getCorporationsCorporationIdBlueprints(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationBlueprintsResponse>> localVarResp = this.getCorporationsCorporationIdBlueprintsWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationBlueprintsResponse>> getCorporationsCorporationIdBlueprintsWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdBlueprintsValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationBlueprintsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdBlueprintsAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationBlueprintsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdBlueprintsValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationBlueprintsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdContainersLogsCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/corporations/{corporation_id}/containers/logs/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdContainersLogsValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdContainersLogs(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdContainersLogsCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationContainersLogsResponse> getCorporationsCorporationIdContainersLogs(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationContainersLogsResponse>> localVarResp = this.getCorporationsCorporationIdContainersLogsWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationContainersLogsResponse>> getCorporationsCorporationIdContainersLogsWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdContainersLogsValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationContainersLogsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdContainersLogsAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationContainersLogsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdContainersLogsValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationContainersLogsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdDivisionsCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/divisions/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdDivisionsValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdDivisions(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdDivisionsCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public CorporationDivisionsResponse getCorporationsCorporationIdDivisions(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CorporationDivisionsResponse> localVarResp = this.getCorporationsCorporationIdDivisionsWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<CorporationDivisionsResponse> getCorporationsCorporationIdDivisionsWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdDivisionsValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CorporationDivisionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdDivisionsAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<CorporationDivisionsResponse> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdDivisionsValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<CorporationDivisionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdFacilitiesCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/facilities/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdFacilitiesValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdFacilities(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdFacilitiesCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CorporationFacilitiesResponse> getCorporationsCorporationIdFacilities(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationFacilitiesResponse>> localVarResp = this.getCorporationsCorporationIdFacilitiesWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationFacilitiesResponse>> getCorporationsCorporationIdFacilitiesWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdFacilitiesValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationFacilitiesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdFacilitiesAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CorporationFacilitiesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdFacilitiesValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationFacilitiesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdIconsCall(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/icons/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdIconsValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdIcons(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdIconsCall(corporationId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public CorporationIconsResponse getCorporationsCorporationIdIcons(Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<CorporationIconsResponse> localVarResp = this.getCorporationsCorporationIdIconsWithHttpInfo(corporationId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<CorporationIconsResponse> getCorporationsCorporationIdIconsWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdIconsValidateBeforeCall(corporationId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<CorporationIconsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdIconsAsync(Integer corporationId, String datasource, String ifNoneMatch, ApiCallback<CorporationIconsResponse> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdIconsValidateBeforeCall(corporationId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<CorporationIconsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdMedalsCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/medals/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdMedalsValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMedals(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdMedalsCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationMedalsResponse> getCorporationsCorporationIdMedals(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationMedalsResponse>> localVarResp = this.getCorporationsCorporationIdMedalsWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationMedalsResponse>> getCorporationsCorporationIdMedalsWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMedalsValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMedalsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdMedalsAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationMedalsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMedalsValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationMedalsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdMedalsIssuedCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/medals/issued/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdMedalsIssuedValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMedalsIssued(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdMedalsIssuedCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationMedalsIssuedResponse> getCorporationsCorporationIdMedalsIssued(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationMedalsIssuedResponse>> localVarResp = this.getCorporationsCorporationIdMedalsIssuedWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationMedalsIssuedResponse>> getCorporationsCorporationIdMedalsIssuedWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMedalsIssuedValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMedalsIssuedResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdMedalsIssuedAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationMedalsIssuedResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMedalsIssuedValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationMedalsIssuedResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdMembersCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v3/corporations/{corporation_id}/members/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdMembersValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMembers(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdMembersCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<Integer> getCorporationsCorporationIdMembers(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getCorporationsCorporationIdMembersWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getCorporationsCorporationIdMembersWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMembersValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdMembersAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMembersValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdMembersLimitCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/members/limit/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdMembersLimitValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMembersLimit(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdMembersLimitCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public Integer getCorporationsCorporationIdMembersLimit(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<Integer> localVarResp = this.getCorporationsCorporationIdMembersLimitWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<Integer> getCorporationsCorporationIdMembersLimitWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMembersLimitValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdMembersLimitAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<Integer> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMembersLimitValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdMembersTitlesCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/members/titles/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdMembersTitlesValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMembersTitles(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdMembersTitlesCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CorporationMembersTitlesResponse> getCorporationsCorporationIdMembersTitles(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationMembersTitlesResponse>> localVarResp = this.getCorporationsCorporationIdMembersTitlesWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationMembersTitlesResponse>> getCorporationsCorporationIdMembersTitlesWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMembersTitlesValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMembersTitlesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdMembersTitlesAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CorporationMembersTitlesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMembersTitlesValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationMembersTitlesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdMembertrackingCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/membertracking/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdMembertrackingValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMembertracking(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdMembertrackingCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CorporationMemberTrackingResponse> getCorporationsCorporationIdMembertracking(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationMemberTrackingResponse>> localVarResp = this.getCorporationsCorporationIdMembertrackingWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationMemberTrackingResponse>> getCorporationsCorporationIdMembertrackingWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMembertrackingValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMemberTrackingResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdMembertrackingAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CorporationMemberTrackingResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdMembertrackingValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationMemberTrackingResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdRolesCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/roles/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdRolesValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdRoles(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdRolesCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CorporationRolesResponse> getCorporationsCorporationIdRoles(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationRolesResponse>> localVarResp = this.getCorporationsCorporationIdRolesWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationRolesResponse>> getCorporationsCorporationIdRolesWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdRolesValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationRolesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdRolesAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CorporationRolesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdRolesValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationRolesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdRolesHistoryCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/roles/history/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdRolesHistoryValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdRolesHistory(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdRolesHistoryCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationRolesHistoryResponse> getCorporationsCorporationIdRolesHistory(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationRolesHistoryResponse>> localVarResp = this.getCorporationsCorporationIdRolesHistoryWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationRolesHistoryResponse>> getCorporationsCorporationIdRolesHistoryWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdRolesHistoryValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationRolesHistoryResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdRolesHistoryAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationRolesHistoryResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdRolesHistoryValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationRolesHistoryResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdShareholdersCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/shareholders/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdShareholdersValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdShareholders(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdShareholdersCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationShareholdersResponse> getCorporationsCorporationIdShareholders(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationShareholdersResponse>> localVarResp = this.getCorporationsCorporationIdShareholdersWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationShareholdersResponse>> getCorporationsCorporationIdShareholdersWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdShareholdersValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationShareholdersResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdShareholdersAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationShareholdersResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdShareholdersValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationShareholdersResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdStandingsCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/standings/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdStandingsValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdStandings(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdStandingsCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationStandingsResponse> getCorporationsCorporationIdStandings(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationStandingsResponse>> localVarResp = this.getCorporationsCorporationIdStandingsWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationStandingsResponse>> getCorporationsCorporationIdStandingsWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdStandingsValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationStandingsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdStandingsAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationStandingsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdStandingsValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationStandingsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdStarbasesCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/starbases/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdStarbasesValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdStarbases(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdStarbasesCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationStarbasesResponse> getCorporationsCorporationIdStarbases(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationStarbasesResponse>> localVarResp = this.getCorporationsCorporationIdStarbasesWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationStarbasesResponse>> getCorporationsCorporationIdStarbasesWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdStarbasesValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationStarbasesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdStarbasesAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationStarbasesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdStarbasesValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationStarbasesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdStarbasesStarbaseIdCall(Integer corporationId, Long starbaseId, Integer systemId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/starbases/{starbase_id}/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString())).replaceAll("\\{starbase_id\\}", this.localVarApiClient.escapeString(starbaseId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (systemId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("system_id", systemId));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdStarbasesStarbaseIdValidateBeforeCall(Integer corporationId, Long starbaseId, Integer systemId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdStarbasesStarbaseId(Async)");
        }
        if (starbaseId == null) {
            throw new ApiException("Missing the required parameter 'starbaseId' when calling getCorporationsCorporationIdStarbasesStarbaseId(Async)");
        }
        if (systemId == null) {
            throw new ApiException("Missing the required parameter 'systemId' when calling getCorporationsCorporationIdStarbasesStarbaseId(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdStarbasesStarbaseIdCall(corporationId, starbaseId, systemId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public CorporationStarbaseResponse getCorporationsCorporationIdStarbasesStarbaseId(Integer corporationId, Long starbaseId, Integer systemId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CorporationStarbaseResponse> localVarResp = this.getCorporationsCorporationIdStarbasesStarbaseIdWithHttpInfo(corporationId, starbaseId, systemId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<CorporationStarbaseResponse> getCorporationsCorporationIdStarbasesStarbaseIdWithHttpInfo(Integer corporationId, Long starbaseId, Integer systemId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdStarbasesStarbaseIdValidateBeforeCall(corporationId, starbaseId, systemId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CorporationStarbaseResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdStarbasesStarbaseIdAsync(Integer corporationId, Long starbaseId, Integer systemId, String datasource, String ifNoneMatch, String token, ApiCallback<CorporationStarbaseResponse> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdStarbasesStarbaseIdValidateBeforeCall(corporationId, starbaseId, systemId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<CorporationStarbaseResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdStructuresCall(Integer corporationId, String acceptLanguage, String datasource, String ifNoneMatch, String language, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v3/corporations/{corporation_id}/structures/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdStructuresValidateBeforeCall(Integer corporationId, String acceptLanguage, String datasource, String ifNoneMatch, String language, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdStructures(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdStructuresCall(corporationId, acceptLanguage, datasource, ifNoneMatch, language, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationStructuresResponse> getCorporationsCorporationIdStructures(Integer corporationId, String acceptLanguage, String datasource, String ifNoneMatch, String language, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationStructuresResponse>> localVarResp = this.getCorporationsCorporationIdStructuresWithHttpInfo(corporationId, acceptLanguage, datasource, ifNoneMatch, language, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationStructuresResponse>> getCorporationsCorporationIdStructuresWithHttpInfo(Integer corporationId, String acceptLanguage, String datasource, String ifNoneMatch, String language, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdStructuresValidateBeforeCall(corporationId, acceptLanguage, datasource, ifNoneMatch, language, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationStructuresResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdStructuresAsync(Integer corporationId, String acceptLanguage, String datasource, String ifNoneMatch, String language, Integer page, String token, ApiCallback<List<CorporationStructuresResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdStructuresValidateBeforeCall(corporationId, acceptLanguage, datasource, ifNoneMatch, language, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationStructuresResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdTitlesCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/titles/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdTitlesValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdTitles(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdTitlesCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CorporationTitlesResponse> getCorporationsCorporationIdTitles(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationTitlesResponse>> localVarResp = this.getCorporationsCorporationIdTitlesWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationTitlesResponse>> getCorporationsCorporationIdTitlesWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdTitlesValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationTitlesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdTitlesAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CorporationTitlesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdTitlesValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationTitlesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsNpccorpsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/npccorps/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsNpccorpsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getCorporationsNpccorpsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Integer> getCorporationsNpccorps(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getCorporationsNpccorpsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getCorporationsNpccorpsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getCorporationsNpccorpsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsNpccorpsAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsNpccorpsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

