/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="recipient object")
public class Recipient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    private Integer recipientId;
    public static final String SERIALIZED_NAME_RECIPIENT_TYPE = "recipient_type";
    @SerializedName(value="recipient_type")
    private RecipientTypeEnum recipientType;

    public Recipient recipientId(Integer recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @ApiModelProperty(required=true, value="recipient_id integer")
    public Integer getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(Integer recipientId) {
        this.recipientId = recipientId;
    }

    public Recipient recipientType(RecipientTypeEnum recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    @ApiModelProperty(required=true, value="recipient_type string")
    public RecipientTypeEnum getRecipientType() {
        return this.recipientType;
    }

    public void setRecipientType(RecipientTypeEnum recipientType) {
        this.recipientType = recipientType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipient recipient = (Recipient)o;
        return Objects.equals(this.recipientId, recipient.recipientId) && Objects.equals((Object)this.recipientType, (Object)recipient.recipientType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recipientId, this.recipientType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recipient {\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    recipientType: ").append(this.toIndentedString((Object)this.recipientType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecipientTypeEnum {
        ALLIANCE("alliance"),
        CHARACTER("character"),
        CORPORATION("corporation"),
        MAILING_LIST("mailing_list");

        private String value;

        private RecipientTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecipientTypeEnum fromValue(String value) {
            for (RecipientTypeEnum b : RecipientTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecipientTypeEnum> {
            public void write(JsonWriter jsonWriter, RecipientTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecipientTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecipientTypeEnum.fromValue(value);
            }
        }
    }
}

