/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class IncursionsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONSTELLATION_ID = "constellation_id";
    @SerializedName(value="constellation_id")
    private Integer constellationId;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    private Integer factionId;
    public static final String SERIALIZED_NAME_HAS_BOSS = "has_boss";
    @SerializedName(value="has_boss")
    private Boolean hasBoss;
    public static final String SERIALIZED_NAME_INFESTED_SOLAR_SYSTEMS = "infested_solar_systems";
    @SerializedName(value="infested_solar_systems")
    private List<Integer> infestedSolarSystems = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_INFLUENCE = "influence";
    @SerializedName(value="influence")
    private Float influence;
    public static final String SERIALIZED_NAME_STAGING_SOLAR_SYSTEM_ID = "staging_solar_system_id";
    @SerializedName(value="staging_solar_system_id")
    private Integer stagingSolarSystemId;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public IncursionsResponse constellationId(Integer constellationId) {
        this.constellationId = constellationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The constellation id in which this incursion takes place")
    public Integer getConstellationId() {
        return this.constellationId;
    }

    public void setConstellationId(Integer constellationId) {
        this.constellationId = constellationId;
    }

    public IncursionsResponse factionId(Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The attacking faction's id")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public IncursionsResponse hasBoss(Boolean hasBoss) {
        this.hasBoss = hasBoss;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the final encounter has boss or not")
    public Boolean getHasBoss() {
        return this.hasBoss;
    }

    public void setHasBoss(Boolean hasBoss) {
        this.hasBoss = hasBoss;
    }

    public IncursionsResponse infestedSolarSystems(List<Integer> infestedSolarSystems) {
        this.infestedSolarSystems = infestedSolarSystems;
        return this;
    }

    public IncursionsResponse addInfestedSolarSystemsItem(Integer infestedSolarSystemsItem) {
        this.infestedSolarSystems.add(infestedSolarSystemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of infested solar system ids that are a part of this incursion")
    public List<Integer> getInfestedSolarSystems() {
        return this.infestedSolarSystems;
    }

    public void setInfestedSolarSystems(List<Integer> infestedSolarSystems) {
        this.infestedSolarSystems = infestedSolarSystems;
    }

    public IncursionsResponse influence(Float influence) {
        this.influence = influence;
        return this;
    }

    @ApiModelProperty(required=true, value="Influence of this incursion as a float from 0 to 1")
    public Float getInfluence() {
        return this.influence;
    }

    public void setInfluence(Float influence) {
        this.influence = influence;
    }

    public IncursionsResponse stagingSolarSystemId(Integer stagingSolarSystemId) {
        this.stagingSolarSystemId = stagingSolarSystemId;
        return this;
    }

    @ApiModelProperty(required=true, value="Staging solar system for this incursion")
    public Integer getStagingSolarSystemId() {
        return this.stagingSolarSystemId;
    }

    public void setStagingSolarSystemId(Integer stagingSolarSystemId) {
        this.stagingSolarSystemId = stagingSolarSystemId;
    }

    public IncursionsResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="The state of this incursion")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public IncursionsResponse type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of this incursion")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncursionsResponse incursionsResponse = (IncursionsResponse)o;
        return Objects.equals(this.constellationId, incursionsResponse.constellationId) && Objects.equals(this.factionId, incursionsResponse.factionId) && Objects.equals(this.hasBoss, incursionsResponse.hasBoss) && Objects.equals(this.infestedSolarSystems, incursionsResponse.infestedSolarSystems) && Objects.equals(this.influence, incursionsResponse.influence) && Objects.equals(this.stagingSolarSystemId, incursionsResponse.stagingSolarSystemId) && Objects.equals((Object)this.state, (Object)incursionsResponse.state) && Objects.equals(this.type, incursionsResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.constellationId, this.factionId, this.hasBoss, this.infestedSolarSystems, this.influence, this.stagingSolarSystemId, this.state, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncursionsResponse {\n");
        sb.append("    constellationId: ").append(this.toIndentedString(this.constellationId)).append("\n");
        sb.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        sb.append("    hasBoss: ").append(this.toIndentedString(this.hasBoss)).append("\n");
        sb.append("    infestedSolarSystems: ").append(this.toIndentedString(this.infestedSolarSystems)).append("\n");
        sb.append("    influence: ").append(this.toIndentedString(this.influence)).append("\n");
        sb.append("    stagingSolarSystemId: ").append(this.toIndentedString(this.stagingSolarSystemId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        WITHDRAWING("withdrawing"),
        MOBILIZING("mobilizing"),
        ESTABLISHED("established");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

