/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="200 ok object")
public class CorporationCustomsOfficesResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALLIANCE_TAX_RATE = "alliance_tax_rate";
    @SerializedName(value="alliance_tax_rate")
    private Float allianceTaxRate;
    public static final String SERIALIZED_NAME_ALLOW_ACCESS_WITH_STANDINGS = "allow_access_with_standings";
    @SerializedName(value="allow_access_with_standings")
    private Boolean allowAccessWithStandings;
    public static final String SERIALIZED_NAME_ALLOW_ALLIANCE_ACCESS = "allow_alliance_access";
    @SerializedName(value="allow_alliance_access")
    private Boolean allowAllianceAccess;
    public static final String SERIALIZED_NAME_BAD_STANDING_TAX_RATE = "bad_standing_tax_rate";
    @SerializedName(value="bad_standing_tax_rate")
    private Float badStandingTaxRate;
    public static final String SERIALIZED_NAME_CORPORATION_TAX_RATE = "corporation_tax_rate";
    @SerializedName(value="corporation_tax_rate")
    private Float corporationTaxRate;
    public static final String SERIALIZED_NAME_EXCELLENT_STANDING_TAX_RATE = "excellent_standing_tax_rate";
    @SerializedName(value="excellent_standing_tax_rate")
    private Float excellentStandingTaxRate;
    public static final String SERIALIZED_NAME_GOOD_STANDING_TAX_RATE = "good_standing_tax_rate";
    @SerializedName(value="good_standing_tax_rate")
    private Float goodStandingTaxRate;
    public static final String SERIALIZED_NAME_NEUTRAL_STANDING_TAX_RATE = "neutral_standing_tax_rate";
    @SerializedName(value="neutral_standing_tax_rate")
    private Float neutralStandingTaxRate;
    public static final String SERIALIZED_NAME_OFFICE_ID = "office_id";
    @SerializedName(value="office_id")
    private Long officeId;
    public static final String SERIALIZED_NAME_REINFORCE_EXIT_END = "reinforce_exit_end";
    @SerializedName(value="reinforce_exit_end")
    private Integer reinforceExitEnd;
    public static final String SERIALIZED_NAME_REINFORCE_EXIT_START = "reinforce_exit_start";
    @SerializedName(value="reinforce_exit_start")
    private Integer reinforceExitStart;
    public static final String SERIALIZED_NAME_STANDING_LEVEL = "standing_level";
    @SerializedName(value="standing_level")
    private StandingLevelEnum standingLevel;
    public static final String SERIALIZED_NAME_SYSTEM_ID = "system_id";
    @SerializedName(value="system_id")
    private Integer systemId;
    public static final String SERIALIZED_NAME_TERRIBLE_STANDING_TAX_RATE = "terrible_standing_tax_rate";
    @SerializedName(value="terrible_standing_tax_rate")
    private Float terribleStandingTaxRate;

    public CorporationCustomsOfficesResponse allianceTaxRate(Float allianceTaxRate) {
        this.allianceTaxRate = allianceTaxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only present if alliance access is allowed")
    public Float getAllianceTaxRate() {
        return this.allianceTaxRate;
    }

    public void setAllianceTaxRate(Float allianceTaxRate) {
        this.allianceTaxRate = allianceTaxRate;
    }

    public CorporationCustomsOfficesResponse allowAccessWithStandings(Boolean allowAccessWithStandings) {
        this.allowAccessWithStandings = allowAccessWithStandings;
        return this;
    }

    @ApiModelProperty(required=true, value="standing_level and any standing related tax rate only present when this is true")
    public Boolean getAllowAccessWithStandings() {
        return this.allowAccessWithStandings;
    }

    public void setAllowAccessWithStandings(Boolean allowAccessWithStandings) {
        this.allowAccessWithStandings = allowAccessWithStandings;
    }

    public CorporationCustomsOfficesResponse allowAllianceAccess(Boolean allowAllianceAccess) {
        this.allowAllianceAccess = allowAllianceAccess;
        return this;
    }

    @ApiModelProperty(required=true, value="allow_alliance_access boolean")
    public Boolean getAllowAllianceAccess() {
        return this.allowAllianceAccess;
    }

    public void setAllowAllianceAccess(Boolean allowAllianceAccess) {
        this.allowAllianceAccess = allowAllianceAccess;
    }

    public CorporationCustomsOfficesResponse badStandingTaxRate(Float badStandingTaxRate) {
        this.badStandingTaxRate = badStandingTaxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="bad_standing_tax_rate number")
    public Float getBadStandingTaxRate() {
        return this.badStandingTaxRate;
    }

    public void setBadStandingTaxRate(Float badStandingTaxRate) {
        this.badStandingTaxRate = badStandingTaxRate;
    }

    public CorporationCustomsOfficesResponse corporationTaxRate(Float corporationTaxRate) {
        this.corporationTaxRate = corporationTaxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="corporation_tax_rate number")
    public Float getCorporationTaxRate() {
        return this.corporationTaxRate;
    }

    public void setCorporationTaxRate(Float corporationTaxRate) {
        this.corporationTaxRate = corporationTaxRate;
    }

    public CorporationCustomsOfficesResponse excellentStandingTaxRate(Float excellentStandingTaxRate) {
        this.excellentStandingTaxRate = excellentStandingTaxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tax rate for entities with excellent level of standing, only present if this level is allowed, same for all other standing related tax rates")
    public Float getExcellentStandingTaxRate() {
        return this.excellentStandingTaxRate;
    }

    public void setExcellentStandingTaxRate(Float excellentStandingTaxRate) {
        this.excellentStandingTaxRate = excellentStandingTaxRate;
    }

    public CorporationCustomsOfficesResponse goodStandingTaxRate(Float goodStandingTaxRate) {
        this.goodStandingTaxRate = goodStandingTaxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="good_standing_tax_rate number")
    public Float getGoodStandingTaxRate() {
        return this.goodStandingTaxRate;
    }

    public void setGoodStandingTaxRate(Float goodStandingTaxRate) {
        this.goodStandingTaxRate = goodStandingTaxRate;
    }

    public CorporationCustomsOfficesResponse neutralStandingTaxRate(Float neutralStandingTaxRate) {
        this.neutralStandingTaxRate = neutralStandingTaxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="neutral_standing_tax_rate number")
    public Float getNeutralStandingTaxRate() {
        return this.neutralStandingTaxRate;
    }

    public void setNeutralStandingTaxRate(Float neutralStandingTaxRate) {
        this.neutralStandingTaxRate = neutralStandingTaxRate;
    }

    public CorporationCustomsOfficesResponse officeId(Long officeId) {
        this.officeId = officeId;
        return this;
    }

    @ApiModelProperty(required=true, value="unique ID of this customs office")
    public Long getOfficeId() {
        return this.officeId;
    }

    public void setOfficeId(Long officeId) {
        this.officeId = officeId;
    }

    public CorporationCustomsOfficesResponse reinforceExitEnd(Integer reinforceExitEnd) {
        this.reinforceExitEnd = reinforceExitEnd;
        return this;
    }

    @ApiModelProperty(required=true, value="reinforce_exit_end integer")
    public Integer getReinforceExitEnd() {
        return this.reinforceExitEnd;
    }

    public void setReinforceExitEnd(Integer reinforceExitEnd) {
        this.reinforceExitEnd = reinforceExitEnd;
    }

    public CorporationCustomsOfficesResponse reinforceExitStart(Integer reinforceExitStart) {
        this.reinforceExitStart = reinforceExitStart;
        return this;
    }

    @ApiModelProperty(required=true, value="Together with reinforce_exit_end, marks a 2-hour period where this customs office could exit reinforcement mode during the day after initial attack")
    public Integer getReinforceExitStart() {
        return this.reinforceExitStart;
    }

    public void setReinforceExitStart(Integer reinforceExitStart) {
        this.reinforceExitStart = reinforceExitStart;
    }

    public CorporationCustomsOfficesResponse standingLevel(StandingLevelEnum standingLevel) {
        this.standingLevel = standingLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Access is allowed only for entities with this level of standing or better")
    public StandingLevelEnum getStandingLevel() {
        return this.standingLevel;
    }

    public void setStandingLevel(StandingLevelEnum standingLevel) {
        this.standingLevel = standingLevel;
    }

    public CorporationCustomsOfficesResponse systemId(Integer systemId) {
        this.systemId = systemId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the solar system this customs office is located in")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer systemId) {
        this.systemId = systemId;
    }

    public CorporationCustomsOfficesResponse terribleStandingTaxRate(Float terribleStandingTaxRate) {
        this.terribleStandingTaxRate = terribleStandingTaxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="terrible_standing_tax_rate number")
    public Float getTerribleStandingTaxRate() {
        return this.terribleStandingTaxRate;
    }

    public void setTerribleStandingTaxRate(Float terribleStandingTaxRate) {
        this.terribleStandingTaxRate = terribleStandingTaxRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorporationCustomsOfficesResponse corporationCustomsOfficesResponse = (CorporationCustomsOfficesResponse)o;
        return Objects.equals(this.allianceTaxRate, corporationCustomsOfficesResponse.allianceTaxRate) && Objects.equals(this.allowAccessWithStandings, corporationCustomsOfficesResponse.allowAccessWithStandings) && Objects.equals(this.allowAllianceAccess, corporationCustomsOfficesResponse.allowAllianceAccess) && Objects.equals(this.badStandingTaxRate, corporationCustomsOfficesResponse.badStandingTaxRate) && Objects.equals(this.corporationTaxRate, corporationCustomsOfficesResponse.corporationTaxRate) && Objects.equals(this.excellentStandingTaxRate, corporationCustomsOfficesResponse.excellentStandingTaxRate) && Objects.equals(this.goodStandingTaxRate, corporationCustomsOfficesResponse.goodStandingTaxRate) && Objects.equals(this.neutralStandingTaxRate, corporationCustomsOfficesResponse.neutralStandingTaxRate) && Objects.equals(this.officeId, corporationCustomsOfficesResponse.officeId) && Objects.equals(this.reinforceExitEnd, corporationCustomsOfficesResponse.reinforceExitEnd) && Objects.equals(this.reinforceExitStart, corporationCustomsOfficesResponse.reinforceExitStart) && Objects.equals((Object)this.standingLevel, (Object)corporationCustomsOfficesResponse.standingLevel) && Objects.equals(this.systemId, corporationCustomsOfficesResponse.systemId) && Objects.equals(this.terribleStandingTaxRate, corporationCustomsOfficesResponse.terribleStandingTaxRate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allianceTaxRate, this.allowAccessWithStandings, this.allowAllianceAccess, this.badStandingTaxRate, this.corporationTaxRate, this.excellentStandingTaxRate, this.goodStandingTaxRate, this.neutralStandingTaxRate, this.officeId, this.reinforceExitEnd, this.reinforceExitStart, this.standingLevel, this.systemId, this.terribleStandingTaxRate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationCustomsOfficesResponse {\n");
        sb.append("    allianceTaxRate: ").append(this.toIndentedString(this.allianceTaxRate)).append("\n");
        sb.append("    allowAccessWithStandings: ").append(this.toIndentedString(this.allowAccessWithStandings)).append("\n");
        sb.append("    allowAllianceAccess: ").append(this.toIndentedString(this.allowAllianceAccess)).append("\n");
        sb.append("    badStandingTaxRate: ").append(this.toIndentedString(this.badStandingTaxRate)).append("\n");
        sb.append("    corporationTaxRate: ").append(this.toIndentedString(this.corporationTaxRate)).append("\n");
        sb.append("    excellentStandingTaxRate: ").append(this.toIndentedString(this.excellentStandingTaxRate)).append("\n");
        sb.append("    goodStandingTaxRate: ").append(this.toIndentedString(this.goodStandingTaxRate)).append("\n");
        sb.append("    neutralStandingTaxRate: ").append(this.toIndentedString(this.neutralStandingTaxRate)).append("\n");
        sb.append("    officeId: ").append(this.toIndentedString(this.officeId)).append("\n");
        sb.append("    reinforceExitEnd: ").append(this.toIndentedString(this.reinforceExitEnd)).append("\n");
        sb.append("    reinforceExitStart: ").append(this.toIndentedString(this.reinforceExitStart)).append("\n");
        sb.append("    standingLevel: ").append(this.toIndentedString((Object)this.standingLevel)).append("\n");
        sb.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        sb.append("    terribleStandingTaxRate: ").append(this.toIndentedString(this.terribleStandingTaxRate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StandingLevelEnum {
        BAD("bad"),
        EXCELLENT("excellent"),
        GOOD("good"),
        NEUTRAL("neutral"),
        TERRIBLE("terrible");

        private String value;

        private StandingLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StandingLevelEnum fromValue(String value) {
            for (StandingLevelEnum b : StandingLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StandingLevelEnum> {
            public void write(JsonWriter jsonWriter, StandingLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StandingLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StandingLevelEnum.fromValue(value);
            }
        }
    }
}

