/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterPlanetResponse;
import net.troja.eve.esi.model.CharacterPlanetsResponse;
import net.troja.eve.esi.model.CorporationCustomsOfficesResponse;
import net.troja.eve.esi.model.PlanetFactorySchematicResponse;
import okhttp3.Call;

public class PlanetaryInteractionApi {
    private ApiClient localVarApiClient;

    public PlanetaryInteractionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PlanetaryInteractionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getCharactersCharacterIdPlanetsCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/characters/{character_id}/planets/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdPlanetsValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdPlanets(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdPlanetsCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CharacterPlanetsResponse> getCharactersCharacterIdPlanets(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterPlanetsResponse>> localVarResp = this.getCharactersCharacterIdPlanetsWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterPlanetsResponse>> getCharactersCharacterIdPlanetsWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPlanetsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterPlanetsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdPlanetsAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterPlanetsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPlanetsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterPlanetsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdPlanetsPlanetIdCall(Integer characterId, Integer planetId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v3/characters/{character_id}/planets/{planet_id}/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString())).replaceAll("\\{planet_id\\}", this.localVarApiClient.escapeString(planetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdPlanetsPlanetIdValidateBeforeCall(Integer characterId, Integer planetId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdPlanetsPlanetId(Async)");
        }
        if (planetId == null) {
            throw new ApiException("Missing the required parameter 'planetId' when calling getCharactersCharacterIdPlanetsPlanetId(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdPlanetsPlanetIdCall(characterId, planetId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public CharacterPlanetResponse getCharactersCharacterIdPlanetsPlanetId(Integer characterId, Integer planetId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CharacterPlanetResponse> localVarResp = this.getCharactersCharacterIdPlanetsPlanetIdWithHttpInfo(characterId, planetId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterPlanetResponse> getCharactersCharacterIdPlanetsPlanetIdWithHttpInfo(Integer characterId, Integer planetId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPlanetsPlanetIdValidateBeforeCall(characterId, planetId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CharacterPlanetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdPlanetsPlanetIdAsync(Integer characterId, Integer planetId, String datasource, String ifNoneMatch, String token, ApiCallback<CharacterPlanetResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPlanetsPlanetIdValidateBeforeCall(characterId, planetId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<CharacterPlanetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdCustomsOfficesCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/corporations/{corporation_id}/customs_offices/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdCustomsOfficesValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdCustomsOffices(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdCustomsOfficesCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationCustomsOfficesResponse> getCorporationsCorporationIdCustomsOffices(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationCustomsOfficesResponse>> localVarResp = this.getCorporationsCorporationIdCustomsOfficesWithHttpInfo(corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationCustomsOfficesResponse>> getCorporationsCorporationIdCustomsOfficesWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdCustomsOfficesValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationCustomsOfficesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdCustomsOfficesAsync(Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationCustomsOfficesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdCustomsOfficesValidateBeforeCall(corporationId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationCustomsOfficesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseSchematicsSchematicIdCall(Integer schematicId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/universe/schematics/{schematic_id}/".replaceAll("\\{schematic_id\\}", this.localVarApiClient.escapeString(schematicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseSchematicsSchematicIdValidateBeforeCall(Integer schematicId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (schematicId == null) {
            throw new ApiException("Missing the required parameter 'schematicId' when calling getUniverseSchematicsSchematicId(Async)");
        }
        Call localVarCall = this.getUniverseSchematicsSchematicIdCall(schematicId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public PlanetFactorySchematicResponse getUniverseSchematicsSchematicId(Integer schematicId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<PlanetFactorySchematicResponse> localVarResp = this.getUniverseSchematicsSchematicIdWithHttpInfo(schematicId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<PlanetFactorySchematicResponse> getUniverseSchematicsSchematicIdWithHttpInfo(Integer schematicId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseSchematicsSchematicIdValidateBeforeCall(schematicId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<PlanetFactorySchematicResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseSchematicsSchematicIdAsync(Integer schematicId, String datasource, String ifNoneMatch, ApiCallback<PlanetFactorySchematicResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseSchematicsSchematicIdValidateBeforeCall(schematicId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<PlanetFactorySchematicResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

