/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 1.3.8
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.BloodlinesResponse;
import net.troja.eve.esi.model.CategoryResponse;
import net.troja.eve.esi.model.ConstellationResponse;
import net.troja.eve.esi.model.FactionsResponse;
import net.troja.eve.esi.model.GraphicResponse;
import net.troja.eve.esi.model.GroupResponse;
import net.troja.eve.esi.model.MoonResponse;
import net.troja.eve.esi.model.PlanetResponse;
import net.troja.eve.esi.model.RacesResponse;
import net.troja.eve.esi.model.RegionResponse;
import net.troja.eve.esi.model.StarResponse;
import net.troja.eve.esi.model.StargateResponse;
import net.troja.eve.esi.model.StationResponse;
import net.troja.eve.esi.model.StructureResponse;
import net.troja.eve.esi.model.SystemJumpsResponse;
import net.troja.eve.esi.model.SystemKillsResponse;
import net.troja.eve.esi.model.SystemResponse;
import net.troja.eve.esi.model.TypeResponse;
import net.troja.eve.esi.model.UniverseAncestriesResponse;
import net.troja.eve.esi.model.UniverseAsteroidBeltsResponse;
import net.troja.eve.esi.model.UniverseIdsResponse;
import net.troja.eve.esi.model.UniverseNamesResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniverseApi {
    private ApiClient localVarApiClient;

    public UniverseApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UniverseApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getUniverseAncestries
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of ancestries</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseAncestriesCall(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/ancestries/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseAncestriesValidateBeforeCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseAncestriesCall(acceptLanguage, datasource, ifNoneMatch, language,
                _callback);
        return localVarCall;

    }

    /**
     * Get ancestries Get all character ancestries --- This route expires daily
     * at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return List&lt;UniverseAncestriesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of ancestries</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<UniverseAncestriesResponse> getUniverseAncestries(String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<List<UniverseAncestriesResponse>> localVarResp = getUniverseAncestriesWithHttpInfo(acceptLanguage,
                datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get ancestries Get all character ancestries --- This route expires daily
     * at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;List&lt;UniverseAncestriesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of ancestries</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<UniverseAncestriesResponse>> getUniverseAncestriesWithHttpInfo(String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseAncestriesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, null);
        Type localVarReturnType = new TypeToken<List<UniverseAncestriesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get ancestries (asynchronously) Get all character ancestries --- This
     * route expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of ancestries</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseAncestriesAsync(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback<List<UniverseAncestriesResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseAncestriesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, _callback);
        Type localVarReturnType = new TypeToken<List<UniverseAncestriesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseAsteroidBeltsAsteroidBeltId
     * 
     * @param asteroidBeltId
     *            asteroid_belt_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an asteroid belt</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseAsteroidBeltsAsteroidBeltIdCall(Integer asteroidBeltId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/asteroid_belts/{asteroid_belt_id}/".replaceAll("\\{" + "asteroid_belt_id"
                + "\\}", localVarApiClient.escapeString(asteroidBeltId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(Integer asteroidBeltId,
            String datasource, String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'asteroidBeltId' is set
        if (asteroidBeltId == null) {
            throw new ApiException(
                    "Missing the required parameter 'asteroidBeltId' when calling getUniverseAsteroidBeltsAsteroidBeltId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseAsteroidBeltsAsteroidBeltIdCall(asteroidBeltId, datasource, ifNoneMatch,
                _callback);
        return localVarCall;

    }

    /**
     * Get asteroid belt information Get information on an asteroid belt ---
     * This route expires daily at 11:05
     * 
     * @param asteroidBeltId
     *            asteroid_belt_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return UniverseAsteroidBeltsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an asteroid belt</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public UniverseAsteroidBeltsResponse getUniverseAsteroidBeltsAsteroidBeltId(Integer asteroidBeltId,
            String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<UniverseAsteroidBeltsResponse> localVarResp = getUniverseAsteroidBeltsAsteroidBeltIdWithHttpInfo(
                asteroidBeltId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get asteroid belt information Get information on an asteroid belt ---
     * This route expires daily at 11:05
     * 
     * @param asteroidBeltId
     *            asteroid_belt_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;UniverseAsteroidBeltsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an asteroid belt</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<UniverseAsteroidBeltsResponse> getUniverseAsteroidBeltsAsteroidBeltIdWithHttpInfo(
            Integer asteroidBeltId, String datasource, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(asteroidBeltId,
                datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<UniverseAsteroidBeltsResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get asteroid belt information (asynchronously) Get information on an
     * asteroid belt --- This route expires daily at 11:05
     * 
     * @param asteroidBeltId
     *            asteroid_belt_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an asteroid belt</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseAsteroidBeltsAsteroidBeltIdAsync(Integer asteroidBeltId, String datasource,
            String ifNoneMatch, final ApiCallback<UniverseAsteroidBeltsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(asteroidBeltId,
                datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<UniverseAsteroidBeltsResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseBloodlines
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of bloodlines</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseBloodlinesCall(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/bloodlines/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseBloodlinesValidateBeforeCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseBloodlinesCall(acceptLanguage, datasource, ifNoneMatch, language,
                _callback);
        return localVarCall;

    }

    /**
     * Get bloodlines Get a list of bloodlines --- This route expires daily at
     * 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return List&lt;BloodlinesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of bloodlines</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<BloodlinesResponse> getUniverseBloodlines(String acceptLanguage, String datasource, String ifNoneMatch,
            String language) throws ApiException {
        ApiResponse<List<BloodlinesResponse>> localVarResp = getUniverseBloodlinesWithHttpInfo(acceptLanguage,
                datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get bloodlines Get a list of bloodlines --- This route expires daily at
     * 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;List&lt;BloodlinesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of bloodlines</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<BloodlinesResponse>> getUniverseBloodlinesWithHttpInfo(String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseBloodlinesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, null);
        Type localVarReturnType = new TypeToken<List<BloodlinesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get bloodlines (asynchronously) Get a list of bloodlines --- This route
     * expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of bloodlines</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseBloodlinesAsync(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback<List<BloodlinesResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseBloodlinesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, _callback);
        Type localVarReturnType = new TypeToken<List<BloodlinesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseCategories
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item category ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseCategoriesCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/categories/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseCategoriesValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseCategoriesCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get item categories Get a list of item categories --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item category ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getUniverseCategories(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getUniverseCategoriesWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get item categories Get a list of item categories --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item category ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getUniverseCategoriesWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        okhttp3.Call localVarCall = getUniverseCategoriesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get item categories (asynchronously) Get a list of item categories ---
     * This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item category ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseCategoriesAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseCategoriesValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseCategoriesCategoryId
     * 
     * @param categoryId
     *            An Eve item category ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item category</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseCategoriesCategoryIdCall(Integer categoryId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/categories/{category_id}/".replaceAll("\\{" + "category_id" + "\\}",
                localVarApiClient.escapeString(categoryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseCategoriesCategoryIdValidateBeforeCall(Integer categoryId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'categoryId' is set
        if (categoryId == null) {
            throw new ApiException(
                    "Missing the required parameter 'categoryId' when calling getUniverseCategoriesCategoryId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseCategoriesCategoryIdCall(categoryId, acceptLanguage, datasource,
                ifNoneMatch, language, _callback);
        return localVarCall;

    }

    /**
     * Get item category information Get information of an item category ---
     * This route expires daily at 11:05
     * 
     * @param categoryId
     *            An Eve item category ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return CategoryResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item category</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public CategoryResponse getUniverseCategoriesCategoryId(Integer categoryId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<CategoryResponse> localVarResp = getUniverseCategoriesCategoryIdWithHttpInfo(categoryId,
                acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get item category information Get information of an item category ---
     * This route expires daily at 11:05
     * 
     * @param categoryId
     *            An Eve item category ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;CategoryResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item category</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<CategoryResponse> getUniverseCategoriesCategoryIdWithHttpInfo(Integer categoryId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseCategoriesCategoryIdValidateBeforeCall(categoryId, acceptLanguage,
                datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<CategoryResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get item category information (asynchronously) Get information of an item
     * category --- This route expires daily at 11:05
     * 
     * @param categoryId
     *            An Eve item category ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item category</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseCategoriesCategoryIdAsync(Integer categoryId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback<CategoryResponse> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getUniverseCategoriesCategoryIdValidateBeforeCall(categoryId, acceptLanguage,
                datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseConstellations
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of constellation ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseConstellationsCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/constellations/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseConstellationsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseConstellationsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get constellations Get a list of constellations --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of constellation ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getUniverseConstellations(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getUniverseConstellationsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get constellations Get a list of constellations --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of constellation ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getUniverseConstellationsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        okhttp3.Call localVarCall = getUniverseConstellationsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get constellations (asynchronously) Get a list of constellations --- This
     * route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of constellation ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseConstellationsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseConstellationsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseConstellationsConstellationId
     * 
     * @param constellationId
     *            constellation_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a constellation</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseConstellationsConstellationIdCall(Integer constellationId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/constellations/{constellation_id}/".replaceAll("\\{" + "constellation_id"
                + "\\}", localVarApiClient.escapeString(constellationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseConstellationsConstellationIdValidateBeforeCall(Integer constellationId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'constellationId' is set
        if (constellationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'constellationId' when calling getUniverseConstellationsConstellationId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseConstellationsConstellationIdCall(constellationId, acceptLanguage,
                datasource, ifNoneMatch, language, _callback);
        return localVarCall;

    }

    /**
     * Get constellation information Get information on a constellation --- This
     * route expires daily at 11:05
     * 
     * @param constellationId
     *            constellation_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ConstellationResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a constellation</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ConstellationResponse getUniverseConstellationsConstellationId(Integer constellationId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<ConstellationResponse> localVarResp = getUniverseConstellationsConstellationIdWithHttpInfo(
                constellationId, acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get constellation information Get information on a constellation --- This
     * route expires daily at 11:05
     * 
     * @param constellationId
     *            constellation_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;ConstellationResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a constellation</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<ConstellationResponse> getUniverseConstellationsConstellationIdWithHttpInfo(
            Integer constellationId, String acceptLanguage, String datasource, String ifNoneMatch, String language)
            throws ApiException {
        okhttp3.Call localVarCall = getUniverseConstellationsConstellationIdValidateBeforeCall(constellationId,
                acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<ConstellationResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get constellation information (asynchronously) Get information on a
     * constellation --- This route expires daily at 11:05
     * 
     * @param constellationId
     *            constellation_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a constellation</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseConstellationsConstellationIdAsync(Integer constellationId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback<ConstellationResponse> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getUniverseConstellationsConstellationIdValidateBeforeCall(constellationId,
                acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<ConstellationResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseFactions
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of factions</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseFactionsCall(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/universe/factions/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseFactionsValidateBeforeCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseFactionsCall(acceptLanguage, datasource, ifNoneMatch, language,
                _callback);
        return localVarCall;

    }

    /**
     * Get factions Get a list of factions --- This route expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return List&lt;FactionsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of factions</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<FactionsResponse> getUniverseFactions(String acceptLanguage, String datasource, String ifNoneMatch,
            String language) throws ApiException {
        ApiResponse<List<FactionsResponse>> localVarResp = getUniverseFactionsWithHttpInfo(acceptLanguage, datasource,
                ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get factions Get a list of factions --- This route expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;List&lt;FactionsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of factions</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<FactionsResponse>> getUniverseFactionsWithHttpInfo(String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseFactionsValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, null);
        Type localVarReturnType = new TypeToken<List<FactionsResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get factions (asynchronously) Get a list of factions --- This route
     * expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of factions</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseFactionsAsync(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback<List<FactionsResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseFactionsValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, _callback);
        Type localVarReturnType = new TypeToken<List<FactionsResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseGraphics
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of graphic ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseGraphicsCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/graphics/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseGraphicsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseGraphicsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get graphics Get a list of graphics --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of graphic ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getUniverseGraphics(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getUniverseGraphicsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get graphics Get a list of graphics --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of graphic ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getUniverseGraphicsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        okhttp3.Call localVarCall = getUniverseGraphicsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get graphics (asynchronously) Get a list of graphics --- This route
     * expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of graphic ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseGraphicsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseGraphicsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseGraphicsGraphicId
     * 
     * @param graphicId
     *            graphic_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a graphic</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseGraphicsGraphicIdCall(Integer graphicId, String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/graphics/{graphic_id}/".replaceAll("\\{" + "graphic_id" + "\\}",
                localVarApiClient.escapeString(graphicId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseGraphicsGraphicIdValidateBeforeCall(Integer graphicId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'graphicId' is set
        if (graphicId == null) {
            throw new ApiException(
                    "Missing the required parameter 'graphicId' when calling getUniverseGraphicsGraphicId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseGraphicsGraphicIdCall(graphicId, datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get graphic information Get information on a graphic --- This route
     * expires daily at 11:05
     * 
     * @param graphicId
     *            graphic_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return GraphicResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a graphic</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public GraphicResponse getUniverseGraphicsGraphicId(Integer graphicId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<GraphicResponse> localVarResp = getUniverseGraphicsGraphicIdWithHttpInfo(graphicId, datasource,
                ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get graphic information Get information on a graphic --- This route
     * expires daily at 11:05
     * 
     * @param graphicId
     *            graphic_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;GraphicResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a graphic</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<GraphicResponse> getUniverseGraphicsGraphicIdWithHttpInfo(Integer graphicId, String datasource,
            String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseGraphicsGraphicIdValidateBeforeCall(graphicId, datasource, ifNoneMatch,
                null);
        Type localVarReturnType = new TypeToken<GraphicResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get graphic information (asynchronously) Get information on a graphic ---
     * This route expires daily at 11:05
     * 
     * @param graphicId
     *            graphic_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a graphic</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseGraphicsGraphicIdAsync(Integer graphicId, String datasource, String ifNoneMatch,
            final ApiCallback<GraphicResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseGraphicsGraphicIdValidateBeforeCall(graphicId, datasource, ifNoneMatch,
                _callback);
        Type localVarReturnType = new TypeToken<GraphicResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseGroups
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item group ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseGroupsCall(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/groups/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseGroupsValidateBeforeCall(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseGroupsCall(datasource, ifNoneMatch, page, _callback);
        return localVarCall;

    }

    /**
     * Get item groups Get a list of item groups --- This route expires daily at
     * 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item group ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getUniverseGroups(String datasource, String ifNoneMatch, Integer page) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getUniverseGroupsWithHttpInfo(datasource, ifNoneMatch, page);
        return localVarResp.getData();
    }

    /**
     * Get item groups Get a list of item groups --- This route expires daily at
     * 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item group ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getUniverseGroupsWithHttpInfo(String datasource, String ifNoneMatch, Integer page)
            throws ApiException {
        okhttp3.Call localVarCall = getUniverseGroupsValidateBeforeCall(datasource, ifNoneMatch, page, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get item groups (asynchronously) Get a list of item groups --- This route
     * expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of item group ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseGroupsAsync(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseGroupsValidateBeforeCall(datasource, ifNoneMatch, page, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseGroupsGroupId
     * 
     * @param groupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item group</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseGroupsGroupIdCall(Integer groupId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/groups/{group_id}/".replaceAll("\\{" + "group_id" + "\\}",
                localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseGroupsGroupIdValidateBeforeCall(Integer groupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(
                    "Missing the required parameter 'groupId' when calling getUniverseGroupsGroupId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseGroupsGroupIdCall(groupId, acceptLanguage, datasource, ifNoneMatch,
                language, _callback);
        return localVarCall;

    }

    /**
     * Get item group information Get information on an item group --- This
     * route expires daily at 11:05
     * 
     * @param groupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return GroupResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item group</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public GroupResponse getUniverseGroupsGroupId(Integer groupId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<GroupResponse> localVarResp = getUniverseGroupsGroupIdWithHttpInfo(groupId, acceptLanguage,
                datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get item group information Get information on an item group --- This
     * route expires daily at 11:05
     * 
     * @param groupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;GroupResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item group</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<GroupResponse> getUniverseGroupsGroupIdWithHttpInfo(Integer groupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseGroupsGroupIdValidateBeforeCall(groupId, acceptLanguage, datasource,
                ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<GroupResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get item group information (asynchronously) Get information on an item
     * group --- This route expires daily at 11:05
     * 
     * @param groupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about an item group</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseGroupsGroupIdAsync(Integer groupId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback<GroupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseGroupsGroupIdValidateBeforeCall(groupId, acceptLanguage, datasource,
                ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<GroupResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseMoonsMoonId
     * 
     * @param moonId
     *            moon_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a moon</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseMoonsMoonIdCall(Integer moonId, String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/moons/{moon_id}/".replaceAll("\\{" + "moon_id" + "\\}",
                localVarApiClient.escapeString(moonId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseMoonsMoonIdValidateBeforeCall(Integer moonId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'moonId' is set
        if (moonId == null) {
            throw new ApiException("Missing the required parameter 'moonId' when calling getUniverseMoonsMoonId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseMoonsMoonIdCall(moonId, datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get moon information Get information on a moon --- This route expires
     * daily at 11:05
     * 
     * @param moonId
     *            moon_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return MoonResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a moon</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public MoonResponse getUniverseMoonsMoonId(Integer moonId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<MoonResponse> localVarResp = getUniverseMoonsMoonIdWithHttpInfo(moonId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get moon information Get information on a moon --- This route expires
     * daily at 11:05
     * 
     * @param moonId
     *            moon_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;MoonResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a moon</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<MoonResponse> getUniverseMoonsMoonIdWithHttpInfo(Integer moonId, String datasource,
            String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseMoonsMoonIdValidateBeforeCall(moonId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<MoonResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get moon information (asynchronously) Get information on a moon --- This
     * route expires daily at 11:05
     * 
     * @param moonId
     *            moon_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a moon</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseMoonsMoonIdAsync(Integer moonId, String datasource, String ifNoneMatch,
            final ApiCallback<MoonResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseMoonsMoonIdValidateBeforeCall(moonId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<MoonResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniversePlanetsPlanetId
     * 
     * @param planetId
     *            planet_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a planet</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniversePlanetsPlanetIdCall(Integer planetId, String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/planets/{planet_id}/".replaceAll("\\{" + "planet_id" + "\\}",
                localVarApiClient.escapeString(planetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniversePlanetsPlanetIdValidateBeforeCall(Integer planetId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'planetId' is set
        if (planetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'planetId' when calling getUniversePlanetsPlanetId(Async)");
        }

        okhttp3.Call localVarCall = getUniversePlanetsPlanetIdCall(planetId, datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get planet information Get information on a planet --- This route expires
     * daily at 11:05
     * 
     * @param planetId
     *            planet_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return PlanetResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a planet</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public PlanetResponse getUniversePlanetsPlanetId(Integer planetId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<PlanetResponse> localVarResp = getUniversePlanetsPlanetIdWithHttpInfo(planetId, datasource,
                ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get planet information Get information on a planet --- This route expires
     * daily at 11:05
     * 
     * @param planetId
     *            planet_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;PlanetResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a planet</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<PlanetResponse> getUniversePlanetsPlanetIdWithHttpInfo(Integer planetId, String datasource,
            String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniversePlanetsPlanetIdValidateBeforeCall(planetId, datasource, ifNoneMatch,
                null);
        Type localVarReturnType = new TypeToken<PlanetResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get planet information (asynchronously) Get information on a planet ---
     * This route expires daily at 11:05
     * 
     * @param planetId
     *            planet_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a planet</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniversePlanetsPlanetIdAsync(Integer planetId, String datasource, String ifNoneMatch,
            final ApiCallback<PlanetResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniversePlanetsPlanetIdValidateBeforeCall(planetId, datasource, ifNoneMatch,
                _callback);
        Type localVarReturnType = new TypeToken<PlanetResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseRaces
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of character races</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseRacesCall(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/races/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseRacesValidateBeforeCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseRacesCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;

    }

    /**
     * Get character races Get a list of character races --- This route expires
     * daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return List&lt;RacesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of character races</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<RacesResponse> getUniverseRaces(String acceptLanguage, String datasource, String ifNoneMatch,
            String language) throws ApiException {
        ApiResponse<List<RacesResponse>> localVarResp = getUniverseRacesWithHttpInfo(acceptLanguage, datasource,
                ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get character races Get a list of character races --- This route expires
     * daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;List&lt;RacesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of character races</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<RacesResponse>> getUniverseRacesWithHttpInfo(String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseRacesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, null);
        Type localVarReturnType = new TypeToken<List<RacesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get character races (asynchronously) Get a list of character races ---
     * This route expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of character races</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseRacesAsync(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback<List<RacesResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseRacesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, _callback);
        Type localVarReturnType = new TypeToken<List<RacesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseRegions
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of region ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseRegionsCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/regions/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseRegionsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseRegionsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get regions Get a list of regions --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of region ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getUniverseRegions(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getUniverseRegionsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get regions Get a list of regions --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of region ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getUniverseRegionsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        okhttp3.Call localVarCall = getUniverseRegionsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get regions (asynchronously) Get a list of regions --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of region ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseRegionsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseRegionsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseRegionsRegionId
     * 
     * @param regionId
     *            region_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a region</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseRegionsRegionIdCall(Integer regionId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/regions/{region_id}/".replaceAll("\\{" + "region_id" + "\\}",
                localVarApiClient.escapeString(regionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseRegionsRegionIdValidateBeforeCall(Integer regionId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'regionId' is set
        if (regionId == null) {
            throw new ApiException(
                    "Missing the required parameter 'regionId' when calling getUniverseRegionsRegionId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseRegionsRegionIdCall(regionId, acceptLanguage, datasource, ifNoneMatch,
                language, _callback);
        return localVarCall;

    }

    /**
     * Get region information Get information on a region --- This route expires
     * daily at 11:05
     * 
     * @param regionId
     *            region_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return RegionResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a region</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public RegionResponse getUniverseRegionsRegionId(Integer regionId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<RegionResponse> localVarResp = getUniverseRegionsRegionIdWithHttpInfo(regionId, acceptLanguage,
                datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get region information Get information on a region --- This route expires
     * daily at 11:05
     * 
     * @param regionId
     *            region_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;RegionResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a region</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<RegionResponse> getUniverseRegionsRegionIdWithHttpInfo(Integer regionId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseRegionsRegionIdValidateBeforeCall(regionId, acceptLanguage, datasource,
                ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<RegionResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get region information (asynchronously) Get information on a region ---
     * This route expires daily at 11:05
     * 
     * @param regionId
     *            region_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a region</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseRegionsRegionIdAsync(Integer regionId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback<RegionResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseRegionsRegionIdValidateBeforeCall(regionId, acceptLanguage, datasource,
                ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<RegionResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseStargatesStargateId
     * 
     * @param stargateId
     *            stargate_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a stargate</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStargatesStargateIdCall(Integer stargateId, String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/stargates/{stargate_id}/".replaceAll("\\{" + "stargate_id" + "\\}",
                localVarApiClient.escapeString(stargateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseStargatesStargateIdValidateBeforeCall(Integer stargateId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'stargateId' is set
        if (stargateId == null) {
            throw new ApiException(
                    "Missing the required parameter 'stargateId' when calling getUniverseStargatesStargateId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseStargatesStargateIdCall(stargateId, datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get stargate information Get information on a stargate --- This route
     * expires daily at 11:05
     * 
     * @param stargateId
     *            stargate_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return StargateResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a stargate</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public StargateResponse getUniverseStargatesStargateId(Integer stargateId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<StargateResponse> localVarResp = getUniverseStargatesStargateIdWithHttpInfo(stargateId, datasource,
                ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get stargate information Get information on a stargate --- This route
     * expires daily at 11:05
     * 
     * @param stargateId
     *            stargate_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;StargateResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a stargate</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<StargateResponse> getUniverseStargatesStargateIdWithHttpInfo(Integer stargateId,
            String datasource, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseStargatesStargateIdValidateBeforeCall(stargateId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<StargateResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get stargate information (asynchronously) Get information on a stargate
     * --- This route expires daily at 11:05
     * 
     * @param stargateId
     *            stargate_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a stargate</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStargatesStargateIdAsync(Integer stargateId, String datasource, String ifNoneMatch,
            final ApiCallback<StargateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseStargatesStargateIdValidateBeforeCall(stargateId, datasource,
                ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<StargateResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseStarsStarId
     * 
     * @param starId
     *            star_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a star</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStarsStarIdCall(Integer starId, String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/stars/{star_id}/".replaceAll("\\{" + "star_id" + "\\}",
                localVarApiClient.escapeString(starId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseStarsStarIdValidateBeforeCall(Integer starId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'starId' is set
        if (starId == null) {
            throw new ApiException("Missing the required parameter 'starId' when calling getUniverseStarsStarId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseStarsStarIdCall(starId, datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get star information Get information on a star --- This route expires
     * daily at 11:05
     * 
     * @param starId
     *            star_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return StarResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a star</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public StarResponse getUniverseStarsStarId(Integer starId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<StarResponse> localVarResp = getUniverseStarsStarIdWithHttpInfo(starId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get star information Get information on a star --- This route expires
     * daily at 11:05
     * 
     * @param starId
     *            star_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;StarResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a star</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<StarResponse> getUniverseStarsStarIdWithHttpInfo(Integer starId, String datasource,
            String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseStarsStarIdValidateBeforeCall(starId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<StarResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get star information (asynchronously) Get information on a star --- This
     * route expires daily at 11:05
     * 
     * @param starId
     *            star_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a star</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStarsStarIdAsync(Integer starId, String datasource, String ifNoneMatch,
            final ApiCallback<StarResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseStarsStarIdValidateBeforeCall(starId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<StarResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseStationsStationId
     * 
     * @param stationId
     *            station_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a station</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStationsStationIdCall(Integer stationId, String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/universe/stations/{station_id}/".replaceAll("\\{" + "station_id" + "\\}",
                localVarApiClient.escapeString(stationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseStationsStationIdValidateBeforeCall(Integer stationId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'stationId' is set
        if (stationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'stationId' when calling getUniverseStationsStationId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseStationsStationIdCall(stationId, datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get station information Get information on a station --- This route
     * expires daily at 11:05
     * 
     * @param stationId
     *            station_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return StationResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a station</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public StationResponse getUniverseStationsStationId(Integer stationId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<StationResponse> localVarResp = getUniverseStationsStationIdWithHttpInfo(stationId, datasource,
                ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get station information Get information on a station --- This route
     * expires daily at 11:05
     * 
     * @param stationId
     *            station_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;StationResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a station</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<StationResponse> getUniverseStationsStationIdWithHttpInfo(Integer stationId, String datasource,
            String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseStationsStationIdValidateBeforeCall(stationId, datasource, ifNoneMatch,
                null);
        Type localVarReturnType = new TypeToken<StationResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get station information (asynchronously) Get information on a station ---
     * This route expires daily at 11:05
     * 
     * @param stationId
     *            station_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a station</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStationsStationIdAsync(Integer stationId, String datasource, String ifNoneMatch,
            final ApiCallback<StationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseStationsStationIdValidateBeforeCall(stationId, datasource, ifNoneMatch,
                _callback);
        Type localVarReturnType = new TypeToken<StationResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseStructures
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param filter
     *            Only list public structures that have this service online
     *            (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of public structure IDs</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStructuresCall(String datasource, String filter, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/structures/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (filter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter", filter));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseStructuresValidateBeforeCall(String datasource, String filter, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseStructuresCall(datasource, filter, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * List all public structures List all public structures --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param filter
     *            Only list public structures that have this service online
     *            (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Long&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of public structure IDs</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Long> getUniverseStructures(String datasource, String filter, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Long>> localVarResp = getUniverseStructuresWithHttpInfo(datasource, filter, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * List all public structures List all public structures --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param filter
     *            Only list public structures that have this service online
     *            (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Long&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of public structure IDs</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Long>> getUniverseStructuresWithHttpInfo(String datasource, String filter,
            String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseStructuresValidateBeforeCall(datasource, filter, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Long>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all public structures (asynchronously) List all public structures
     * --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param filter
     *            Only list public structures that have this service online
     *            (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of public structure IDs</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStructuresAsync(String datasource, String filter, String ifNoneMatch,
            final ApiCallback<List<Long>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseStructuresValidateBeforeCall(datasource, filter, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Long>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseStructuresStructureId
     * 
     * @param structureId
     *            An Eve structure ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Data about a structure</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStructuresStructureIdCall(Long structureId, String datasource, String ifNoneMatch,
            String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/universe/structures/{structure_id}/".replaceAll("\\{" + "structure_id" + "\\}",
                localVarApiClient.escapeString(structureId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseStructuresStructureIdValidateBeforeCall(Long structureId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'structureId' is set
        if (structureId == null) {
            throw new ApiException(
                    "Missing the required parameter 'structureId' when calling getUniverseStructuresStructureId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseStructuresStructureIdCall(structureId, datasource, ifNoneMatch, token,
                _callback);
        return localVarCall;

    }

    /**
     * Get structure information Returns information on requested structure if
     * you are on the ACL. Otherwise, returns \&quot;Forbidden\&quot; for all
     * inputs. --- This route is cached for up to 3600 seconds
     * 
     * @param structureId
     *            An Eve structure ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return StructureResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Data about a structure</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public StructureResponse getUniverseStructuresStructureId(Long structureId, String datasource, String ifNoneMatch,
            String token) throws ApiException {
        ApiResponse<StructureResponse> localVarResp = getUniverseStructuresStructureIdWithHttpInfo(structureId,
                datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get structure information Returns information on requested structure if
     * you are on the ACL. Otherwise, returns \&quot;Forbidden\&quot; for all
     * inputs. --- This route is cached for up to 3600 seconds
     * 
     * @param structureId
     *            An Eve structure ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;StructureResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Data about a structure</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<StructureResponse> getUniverseStructuresStructureIdWithHttpInfo(Long structureId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getUniverseStructuresStructureIdValidateBeforeCall(structureId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<StructureResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get structure information (asynchronously) Returns information on
     * requested structure if you are on the ACL. Otherwise, returns
     * \&quot;Forbidden\&quot; for all inputs. --- This route is cached for up
     * to 3600 seconds
     * 
     * @param structureId
     *            An Eve structure ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Data about a structure</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseStructuresStructureIdAsync(Long structureId, String datasource, String ifNoneMatch,
            String token, final ApiCallback<StructureResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseStructuresStructureIdValidateBeforeCall(structureId, datasource,
                ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<StructureResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseSystemJumps
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of systems and number of jumps</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseSystemJumpsCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/system_jumps/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseSystemJumpsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseSystemJumpsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get system jumps Get the number of jumps in solar systems within the last
     * hour ending at the timestamp of the Last-Modified header, excluding
     * wormhole space. Only systems with jumps will be listed --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;SystemJumpsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of systems and number of jumps</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<SystemJumpsResponse> getUniverseSystemJumps(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<SystemJumpsResponse>> localVarResp = getUniverseSystemJumpsWithHttpInfo(datasource,
                ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get system jumps Get the number of jumps in solar systems within the last
     * hour ending at the timestamp of the Last-Modified header, excluding
     * wormhole space. Only systems with jumps will be listed --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;SystemJumpsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of systems and number of jumps</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<SystemJumpsResponse>> getUniverseSystemJumpsWithHttpInfo(String datasource,
            String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseSystemJumpsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<SystemJumpsResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get system jumps (asynchronously) Get the number of jumps in solar
     * systems within the last hour ending at the timestamp of the Last-Modified
     * header, excluding wormhole space. Only systems with jumps will be listed
     * --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of systems and number of jumps</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseSystemJumpsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<SystemJumpsResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseSystemJumpsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<SystemJumpsResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseSystemKills
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of systems and number of ship, pod and
     *                        NPC kills</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseSystemKillsCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/universe/system_kills/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseSystemKillsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseSystemKillsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get system kills Get the number of ship, pod and NPC kills per solar
     * system within the last hour ending at the timestamp of the Last-Modified
     * header, excluding wormhole space. Only systems with kills will be listed
     * --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;SystemKillsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of systems and number of ship, pod and
     *                        NPC kills</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<SystemKillsResponse> getUniverseSystemKills(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<SystemKillsResponse>> localVarResp = getUniverseSystemKillsWithHttpInfo(datasource,
                ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get system kills Get the number of ship, pod and NPC kills per solar
     * system within the last hour ending at the timestamp of the Last-Modified
     * header, excluding wormhole space. Only systems with kills will be listed
     * --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;SystemKillsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of systems and number of ship, pod and
     *                        NPC kills</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<SystemKillsResponse>> getUniverseSystemKillsWithHttpInfo(String datasource,
            String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getUniverseSystemKillsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<SystemKillsResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get system kills (asynchronously) Get the number of ship, pod and NPC
     * kills per solar system within the last hour ending at the timestamp of
     * the Last-Modified header, excluding wormhole space. Only systems with
     * kills will be listed --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of systems and number of ship, pod and
     *                        NPC kills</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseSystemKillsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<SystemKillsResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseSystemKillsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<SystemKillsResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseSystems
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of solar system ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseSystemsCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/systems/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseSystemsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseSystemsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get solar systems Get a list of solar systems --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of solar system ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getUniverseSystems(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getUniverseSystemsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get solar systems Get a list of solar systems --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of solar system ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getUniverseSystemsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        okhttp3.Call localVarCall = getUniverseSystemsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get solar systems (asynchronously) Get a list of solar systems --- This
     * route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of solar system ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseSystemsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseSystemsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseSystemsSystemId
     * 
     * @param systemId
     *            system_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a solar system</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseSystemsSystemIdCall(Integer systemId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v4/universe/systems/{system_id}/".replaceAll("\\{" + "system_id" + "\\}",
                localVarApiClient.escapeString(systemId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseSystemsSystemIdValidateBeforeCall(Integer systemId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'systemId' is set
        if (systemId == null) {
            throw new ApiException(
                    "Missing the required parameter 'systemId' when calling getUniverseSystemsSystemId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseSystemsSystemIdCall(systemId, acceptLanguage, datasource, ifNoneMatch,
                language, _callback);
        return localVarCall;

    }

    /**
     * Get solar system information Get information on a solar system. --- This
     * route expires daily at 11:05
     * 
     * @param systemId
     *            system_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return SystemResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a solar system</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public SystemResponse getUniverseSystemsSystemId(Integer systemId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<SystemResponse> localVarResp = getUniverseSystemsSystemIdWithHttpInfo(systemId, acceptLanguage,
                datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get solar system information Get information on a solar system. --- This
     * route expires daily at 11:05
     * 
     * @param systemId
     *            system_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;SystemResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a solar system</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<SystemResponse> getUniverseSystemsSystemIdWithHttpInfo(Integer systemId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseSystemsSystemIdValidateBeforeCall(systemId, acceptLanguage, datasource,
                ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<SystemResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get solar system information (asynchronously) Get information on a solar
     * system. --- This route expires daily at 11:05
     * 
     * @param systemId
     *            system_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a solar system</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseSystemsSystemIdAsync(Integer systemId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback<SystemResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseSystemsSystemIdValidateBeforeCall(systemId, acceptLanguage, datasource,
                ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<SystemResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseTypes
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of type ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseTypesCall(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/universe/types/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseTypesValidateBeforeCall(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseTypesCall(datasource, ifNoneMatch, page, _callback);
        return localVarCall;

    }

    /**
     * Get types Get a list of type ids --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of type ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<Integer> getUniverseTypes(String datasource, String ifNoneMatch, Integer page) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getUniverseTypesWithHttpInfo(datasource, ifNoneMatch, page);
        return localVarResp.getData();
    }

    /**
     * Get types Get a list of type ids --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of type ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<Integer>> getUniverseTypesWithHttpInfo(String datasource, String ifNoneMatch, Integer page)
            throws ApiException {
        okhttp3.Call localVarCall = getUniverseTypesValidateBeforeCall(datasource, ifNoneMatch, page, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get types (asynchronously) Get a list of type ids --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>A list of type ids</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        X-Pages - Maximum page number <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseTypesAsync(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseTypesValidateBeforeCall(datasource, ifNoneMatch, page, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniverseTypesTypeId
     * 
     * @param typeId
     *            An Eve item type ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a type</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseTypesTypeIdCall(Integer typeId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v3/universe/types/{type_id}/".replaceAll("\\{" + "type_id" + "\\}",
                localVarApiClient.escapeString(typeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniverseTypesTypeIdValidateBeforeCall(Integer typeId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling getUniverseTypesTypeId(Async)");
        }

        okhttp3.Call localVarCall = getUniverseTypesTypeIdCall(typeId, acceptLanguage, datasource, ifNoneMatch,
                language, _callback);
        return localVarCall;

    }

    /**
     * Get type information Get information on a type --- This route expires
     * daily at 11:05
     * 
     * @param typeId
     *            An Eve item type ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return TypeResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a type</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public TypeResponse getUniverseTypesTypeId(Integer typeId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<TypeResponse> localVarResp = getUniverseTypesTypeIdWithHttpInfo(typeId, acceptLanguage, datasource,
                ifNoneMatch, language);
        return localVarResp.getData();
    }

    /**
     * Get type information Get information on a type --- This route expires
     * daily at 11:05
     * 
     * @param typeId
     *            An Eve item type ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;TypeResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a type</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<TypeResponse> getUniverseTypesTypeIdWithHttpInfo(Integer typeId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        okhttp3.Call localVarCall = getUniverseTypesTypeIdValidateBeforeCall(typeId, acceptLanguage, datasource,
                ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<TypeResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get type information (asynchronously) Get information on a type --- This
     * route expires daily at 11:05
     * 
     * @param typeId
     *            An Eve item type ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>Information about a type</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>304</td>
     *                        <td>Not modified</td>
     *                        <td>Cache-Control - The caching mechanism used <br>
     *                        ETag - RFC7232 compliant entity tag <br>
     *                        Expires - RFC7231 formatted datetime string <br>
     *                        Last-Modified - RFC7231 formatted datetime string
     *                        <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call getUniverseTypesTypeIdAsync(Integer typeId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback<TypeResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUniverseTypesTypeIdValidateBeforeCall(typeId, acceptLanguage, datasource,
                ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<TypeResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for postUniverseIds
     * 
     * @param names
     *            The names to resolve (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of id/name associations for a set of
     *                        names divided by category. Any name passed in that
     *                        did not have a match will be ommitted</td>
     *                        <td>Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call postUniverseIdsCall(List<String> names, String acceptLanguage, String datasource,
            String language, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = names;

        // create path and map variables
        String localVarPath = "/v1/universe/ids/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postUniverseIdsValidateBeforeCall(List<String> names, String acceptLanguage,
            String datasource, String language, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'names' is set
        if (names == null) {
            throw new ApiException("Missing the required parameter 'names' when calling postUniverseIds(Async)");
        }

        okhttp3.Call localVarCall = postUniverseIdsCall(names, acceptLanguage, datasource, language, _callback);
        return localVarCall;

    }

    /**
     * Bulk names to IDs Resolve a set of names to IDs in the following
     * categories: agents, alliances, characters, constellations, corporations
     * factions, inventory_types, regions, stations, and systems. Only exact
     * matches will be returned. All names searched for are cached for 12 hours
     * ---
     * 
     * @param names
     *            The names to resolve (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return UniverseIdsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of id/name associations for a set of
     *                        names divided by category. Any name passed in that
     *                        did not have a match will be ommitted</td>
     *                        <td>Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public UniverseIdsResponse postUniverseIds(List<String> names, String acceptLanguage, String datasource,
            String language) throws ApiException {
        ApiResponse<UniverseIdsResponse> localVarResp = postUniverseIdsWithHttpInfo(names, acceptLanguage, datasource,
                language);
        return localVarResp.getData();
    }

    /**
     * Bulk names to IDs Resolve a set of names to IDs in the following
     * categories: agents, alliances, characters, constellations, corporations
     * factions, inventory_types, regions, stations, and systems. Only exact
     * matches will be returned. All names searched for are cached for 12 hours
     * ---
     * 
     * @param names
     *            The names to resolve (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;UniverseIdsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of id/name associations for a set of
     *                        names divided by category. Any name passed in that
     *                        did not have a match will be ommitted</td>
     *                        <td>Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<UniverseIdsResponse> postUniverseIdsWithHttpInfo(List<String> names, String acceptLanguage,
            String datasource, String language) throws ApiException {
        okhttp3.Call localVarCall = postUniverseIdsValidateBeforeCall(names, acceptLanguage, datasource, language, null);
        Type localVarReturnType = new TypeToken<UniverseIdsResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Bulk names to IDs (asynchronously) Resolve a set of names to IDs in the
     * following categories: agents, alliances, characters, constellations,
     * corporations factions, inventory_types, regions, stations, and systems.
     * Only exact matches will be returned. All names searched for are cached
     * for 12 hours ---
     * 
     * @param names
     *            The names to resolve (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of id/name associations for a set of
     *                        names divided by category. Any name passed in that
     *                        did not have a match will be ommitted</td>
     *                        <td>Content-Language - The language used in the
     *                        response <br>
     *                        </td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call postUniverseIdsAsync(List<String> names, String acceptLanguage, String datasource,
            String language, final ApiCallback<UniverseIdsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = postUniverseIdsValidateBeforeCall(names, acceptLanguage, datasource, language,
                _callback);
        Type localVarReturnType = new TypeToken<UniverseIdsResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for postUniverseNames
     * 
     * @param ids
     *            The ids to resolve (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of id/name associations for a set of IDs.
     *                        All IDs must resolve to a name, or nothing will be
     *                        returned</td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call postUniverseNamesCall(List<Integer> ids, String datasource, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = ids;

        // create path and map variables
        String localVarPath = "/v3/universe/names/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postUniverseNamesValidateBeforeCall(List<Integer> ids, String datasource,
            final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling postUniverseNames(Async)");
        }

        okhttp3.Call localVarCall = postUniverseNamesCall(ids, datasource, _callback);
        return localVarCall;

    }

    /**
     * Get names and categories for a set of IDs Resolve a set of IDs to names
     * and categories. Supported ID&#39;s for resolving are: Characters,
     * Corporations, Alliances, Stations, Solar Systems, Constellations,
     * Regions, Types, Factions ---
     * 
     * @param ids
     *            The ids to resolve (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @return List&lt;UniverseNamesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of id/name associations for a set of IDs.
     *                        All IDs must resolve to a name, or nothing will be
     *                        returned</td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public List<UniverseNamesResponse> postUniverseNames(List<Integer> ids, String datasource) throws ApiException {
        ApiResponse<List<UniverseNamesResponse>> localVarResp = postUniverseNamesWithHttpInfo(ids, datasource);
        return localVarResp.getData();
    }

    /**
     * Get names and categories for a set of IDs Resolve a set of IDs to names
     * and categories. Supported ID&#39;s for resolving are: Characters,
     * Corporations, Alliances, Stations, Solar Systems, Constellations,
     * Regions, Types, Factions ---
     * 
     * @param ids
     *            The ids to resolve (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @return ApiResponse&lt;List&lt;UniverseNamesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of id/name associations for a set of IDs.
     *                        All IDs must resolve to a name, or nothing will be
     *                        returned</td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public ApiResponse<List<UniverseNamesResponse>> postUniverseNamesWithHttpInfo(List<Integer> ids, String datasource)
            throws ApiException {
        okhttp3.Call localVarCall = postUniverseNamesValidateBeforeCall(ids, datasource, null);
        Type localVarReturnType = new TypeToken<List<UniverseNamesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get names and categories for a set of IDs (asynchronously) Resolve a set
     * of IDs to names and categories. Supported ID&#39;s for resolving are:
     * Characters, Corporations, Alliances, Stations, Solar Systems,
     * Constellations, Regions, Types, Factions ---
     * 
     * @param ids
     *            The ids to resolve (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     * @http.response.details <table summary="Response Details" border="1">
     *                        <tr>
     *                        <td>Status Code</td>
     *                        <td>Description</td>
     *                        <td>Response Headers</td>
     *                        </tr>
     *                        <tr>
     *                        <td>200</td>
     *                        <td>List of id/name associations for a set of IDs.
     *                        All IDs must resolve to a name, or nothing will be
     *                        returned</td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>400</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>401</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>403</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>404</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>420</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>422</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>500</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>502</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>503</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>504</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        <tr>
     *                        <td>520</td>
     *                        <td></td>
     *                        <td>-</td>
     *                        </tr>
     *                        </table>
     */
    public okhttp3.Call postUniverseNamesAsync(List<Integer> ids, String datasource,
            final ApiCallback<List<UniverseNamesResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = postUniverseNamesValidateBeforeCall(ids, datasource, _callback);
        Type localVarReturnType = new TypeToken<List<UniverseNamesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
