/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.Recipient;

@ApiModel(description="200 ok object")
public class MailResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_READ = "read";
    @SerializedName(value="read")
    private Boolean read;
    public static final String SERIALIZED_NAME_RECIPIENTS = "recipients";
    @SerializedName(value="recipients")
    private List<Recipient> recipients = new ArrayList<Recipient>();
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private Integer from;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private List<Integer> labels = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private OffsetDateTime timestamp;

    public MailResponse read(Boolean read) {
        this.read = read;
        return this;
    }

    @ApiModelProperty(value="Whether the mail is flagged as read")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public MailResponse recipients(List<Recipient> recipients) {
        this.recipients = recipients;
        return this;
    }

    public MailResponse addRecipientsItem(Recipient recipientsItem) {
        if (this.recipients == null) {
            this.recipients = new ArrayList<Recipient>();
        }
        this.recipients.add(recipientsItem);
        return this;
    }

    @ApiModelProperty(value="Recipients of the mail")
    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<Recipient> recipients) {
        this.recipients = recipients;
    }

    public MailResponse subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(value="Mail subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MailResponse from(Integer from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(value="From whom the mail was sent")
    public Integer getFrom() {
        return this.from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public MailResponse body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(value="Mail's body")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public MailResponse labels(List<Integer> labels) {
        this.labels = labels;
        return this;
    }

    public MailResponse addLabelsItem(Integer labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<Integer>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @ApiModelProperty(value="Labels attached to the mail")
    public List<Integer> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Integer> labels) {
        this.labels = labels;
    }

    public MailResponse timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="When the mail was sent")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailResponse mailResponse = (MailResponse)o;
        return Objects.equals(this.read, mailResponse.read) && Objects.equals(this.recipients, mailResponse.recipients) && Objects.equals(this.subject, mailResponse.subject) && Objects.equals(this.from, mailResponse.from) && Objects.equals(this.body, mailResponse.body) && Objects.equals(this.labels, mailResponse.labels) && Objects.equals(this.timestamp, mailResponse.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.read, this.recipients, this.subject, this.from, this.body, this.labels, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MailResponse {\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

