/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersLastWeekVictoryPoints;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersYesterdayVictoryPoints;

@ApiModel(description="Top 100 rankings of pilots by victory points from yesterday, last week and in total")
public class FactionWarfareLeaderboardCharacterVictoryPoints
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_YESTERDAY = "yesterday";
    @SerializedName(value="yesterday")
    private List<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints> yesterday = new ArrayList<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints>();
    public static final String SERIALIZED_NAME_ACTIVE_TOTAL = "active_total";
    @SerializedName(value="active_total")
    private List<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints> activeTotal = new ArrayList<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints>();
    public static final String SERIALIZED_NAME_LAST_WEEK = "last_week";
    @SerializedName(value="last_week")
    private List<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints> lastWeek = new ArrayList<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints>();

    public FactionWarfareLeaderboardCharacterVictoryPoints yesterday(List<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints> yesterday) {
        this.yesterday = yesterday;
        return this;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints addYesterdayItem(FactionWarfareLeaderboardCharactersYesterdayVictoryPoints yesterdayItem) {
        this.yesterday.add(yesterdayItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 100 ranking of pilots by victory points in the past day")
    public List<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints> yesterday) {
        this.yesterday = yesterday;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints activeTotal(List<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints> activeTotal) {
        this.activeTotal = activeTotal;
        return this;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints addActiveTotalItem(FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints activeTotalItem) {
        this.activeTotal.add(activeTotalItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 100 ranking of pilots active in faction warfare by total victory points. A pilot is considered \"active\" if they have participated in faction warfare in the past 14 days")
    public List<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints> activeTotal) {
        this.activeTotal = activeTotal;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints lastWeek(List<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints> lastWeek) {
        this.lastWeek = lastWeek;
        return this;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints addLastWeekItem(FactionWarfareLeaderboardCharactersLastWeekVictoryPoints lastWeekItem) {
        this.lastWeek.add(lastWeekItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 100 ranking of pilots by victory points in the past week")
    public List<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints> lastWeek) {
        this.lastWeek = lastWeek;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardCharacterVictoryPoints factionWarfareLeaderboardCharacterVictoryPoints = (FactionWarfareLeaderboardCharacterVictoryPoints)o;
        return Objects.equals(this.yesterday, factionWarfareLeaderboardCharacterVictoryPoints.yesterday) && Objects.equals(this.activeTotal, factionWarfareLeaderboardCharacterVictoryPoints.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardCharacterVictoryPoints.lastWeek);
    }

    public int hashCode() {
        return Objects.hash(this.yesterday, this.activeTotal, this.lastWeek);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FactionWarfareLeaderboardCharacterVictoryPoints {\n");
        sb.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        sb.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        sb.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

