/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterOrdersResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_REGION_ID = "region_id";
    @SerializedName(value="region_id")
    private Integer regionId;
    public static final String SERIALIZED_NAME_RANGE = "range";
    @SerializedName(value="range")
    private RangeEnum range;
    public static final String SERIALIZED_NAME_VOLUME_TOTAL = "volume_total";
    @SerializedName(value="volume_total")
    private Integer volumeTotal;
    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(value="location_id")
    private Long locationId;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private Integer duration;
    public static final String SERIALIZED_NAME_MIN_VOLUME = "min_volume";
    @SerializedName(value="min_volume")
    private Integer minVolume;
    public static final String SERIALIZED_NAME_IS_BUY_ORDER = "is_buy_order";
    @SerializedName(value="is_buy_order")
    private Boolean isBuyOrder;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private Double price;
    public static final String SERIALIZED_NAME_ESCROW = "escrow";
    @SerializedName(value="escrow")
    private Double escrow;
    public static final String SERIALIZED_NAME_IS_CORPORATION = "is_corporation";
    @SerializedName(value="is_corporation")
    private Boolean isCorporation;
    public static final String SERIALIZED_NAME_ISSUED = "issued";
    @SerializedName(value="issued")
    private OffsetDateTime issued;
    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(value="order_id")
    private Long orderId;
    public static final String SERIALIZED_NAME_VOLUME_REMAIN = "volume_remain";
    @SerializedName(value="volume_remain")
    private Integer volumeRemain;

    public CharacterOrdersResponse typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The type ID of the item transacted in this order")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public CharacterOrdersResponse regionId(Integer regionId) {
        this.regionId = regionId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the region where order was placed")
    public Integer getRegionId() {
        return this.regionId;
    }

    public void setRegionId(Integer regionId) {
        this.regionId = regionId;
    }

    public CharacterOrdersResponse range(RangeEnum range) {
        this.range = range;
        return this;
    }

    @ApiModelProperty(required=true, value="Valid order range, numbers are ranges in jumps")
    public RangeEnum getRange() {
        return this.range;
    }

    public void setRange(RangeEnum range) {
        this.range = range;
    }

    public CharacterOrdersResponse volumeTotal(Integer volumeTotal) {
        this.volumeTotal = volumeTotal;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity of items required or offered at time order was placed")
    public Integer getVolumeTotal() {
        return this.volumeTotal;
    }

    public void setVolumeTotal(Integer volumeTotal) {
        this.volumeTotal = volumeTotal;
    }

    public CharacterOrdersResponse locationId(Long locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the location where order was placed")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    public CharacterOrdersResponse duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of days for which order is valid (starting from the issued date). An order expires at time issued + duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public CharacterOrdersResponse minVolume(Integer minVolume) {
        this.minVolume = minVolume;
        return this;
    }

    @ApiModelProperty(value="For buy orders, the minimum quantity that will be accepted in a matching sell order")
    public Integer getMinVolume() {
        return this.minVolume;
    }

    public void setMinVolume(Integer minVolume) {
        this.minVolume = minVolume;
    }

    public CharacterOrdersResponse isBuyOrder(Boolean isBuyOrder) {
        this.isBuyOrder = isBuyOrder;
        return this;
    }

    @ApiModelProperty(value="True if the order is a bid (buy) order")
    public Boolean getIsBuyOrder() {
        return this.isBuyOrder;
    }

    public void setIsBuyOrder(Boolean isBuyOrder) {
        this.isBuyOrder = isBuyOrder;
    }

    public CharacterOrdersResponse price(Double price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(required=true, value="Cost per unit for this order")
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public CharacterOrdersResponse escrow(Double escrow) {
        this.escrow = escrow;
        return this;
    }

    @ApiModelProperty(value="For buy orders, the amount of ISK in escrow")
    public Double getEscrow() {
        return this.escrow;
    }

    public void setEscrow(Double escrow) {
        this.escrow = escrow;
    }

    public CharacterOrdersResponse isCorporation(Boolean isCorporation) {
        this.isCorporation = isCorporation;
        return this;
    }

    @ApiModelProperty(required=true, value="Signifies whether the buy/sell order was placed on behalf of a corporation.")
    public Boolean getIsCorporation() {
        return this.isCorporation;
    }

    public void setIsCorporation(Boolean isCorporation) {
        this.isCorporation = isCorporation;
    }

    public CharacterOrdersResponse issued(OffsetDateTime issued) {
        this.issued = issued;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time when this order was issued")
    public OffsetDateTime getIssued() {
        return this.issued;
    }

    public void setIssued(OffsetDateTime issued) {
        this.issued = issued;
    }

    public CharacterOrdersResponse orderId(Long orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique order ID")
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public CharacterOrdersResponse volumeRemain(Integer volumeRemain) {
        this.volumeRemain = volumeRemain;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity of items still required or offered")
    public Integer getVolumeRemain() {
        return this.volumeRemain;
    }

    public void setVolumeRemain(Integer volumeRemain) {
        this.volumeRemain = volumeRemain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterOrdersResponse characterOrdersResponse = (CharacterOrdersResponse)o;
        return Objects.equals(this.typeId, characterOrdersResponse.typeId) && Objects.equals(this.regionId, characterOrdersResponse.regionId) && Objects.equals((Object)this.range, (Object)characterOrdersResponse.range) && Objects.equals(this.volumeTotal, characterOrdersResponse.volumeTotal) && Objects.equals(this.locationId, characterOrdersResponse.locationId) && Objects.equals(this.duration, characterOrdersResponse.duration) && Objects.equals(this.minVolume, characterOrdersResponse.minVolume) && Objects.equals(this.isBuyOrder, characterOrdersResponse.isBuyOrder) && Objects.equals(this.price, characterOrdersResponse.price) && Objects.equals(this.escrow, characterOrdersResponse.escrow) && Objects.equals(this.isCorporation, characterOrdersResponse.isCorporation) && Objects.equals(this.issued, characterOrdersResponse.issued) && Objects.equals(this.orderId, characterOrdersResponse.orderId) && Objects.equals(this.volumeRemain, characterOrdersResponse.volumeRemain);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeId, this.regionId, this.range, this.volumeTotal, this.locationId, this.duration, this.minVolume, this.isBuyOrder, this.price, this.escrow, this.isCorporation, this.issued, this.orderId, this.volumeRemain});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterOrdersResponse {\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    regionId: ").append(this.toIndentedString(this.regionId)).append("\n");
        sb.append("    range: ").append(this.toIndentedString((Object)this.range)).append("\n");
        sb.append("    volumeTotal: ").append(this.toIndentedString(this.volumeTotal)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    minVolume: ").append(this.toIndentedString(this.minVolume)).append("\n");
        sb.append("    isBuyOrder: ").append(this.toIndentedString(this.isBuyOrder)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    escrow: ").append(this.toIndentedString(this.escrow)).append("\n");
        sb.append("    isCorporation: ").append(this.toIndentedString(this.isCorporation)).append("\n");
        sb.append("    issued: ").append(this.toIndentedString(this.issued)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    volumeRemain: ").append(this.toIndentedString(this.volumeRemain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RangeEnum {
        _1("1"),
        _10("10"),
        _2("2"),
        _20("20"),
        _3("3"),
        _30("30"),
        _4("4"),
        _40("40"),
        _5("5"),
        REGION("region"),
        SOLARSYSTEM("solarsystem"),
        STATION("station");

        private String value;

        private RangeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RangeEnum fromValue(String value) {
            for (RangeEnum b : RangeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RangeEnum> {
            public void write(JsonWriter jsonWriter, RangeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RangeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RangeEnum.fromValue(value);
            }
        }
    }
}

