/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterWalletJournalResponse;
import net.troja.eve.esi.model.CharacterWalletTransactionsResponse;
import net.troja.eve.esi.model.CorporationWalletJournalResponse;
import net.troja.eve.esi.model.CorporationWalletTransactionsResponse;
import net.troja.eve.esi.model.CorporationWalletsResponse;
import okhttp3.Call;

public class WalletApi {
    private ApiClient localVarApiClient;

    public WalletApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WalletApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getCharactersCharacterIdWalletCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/characters/{character_id}/wallet/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdWalletValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdWallet(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdWalletCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public Double getCharactersCharacterIdWallet(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<Double> localVarResp = this.getCharactersCharacterIdWalletWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<Double> getCharactersCharacterIdWalletWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdWalletValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<Double>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdWalletAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<Double> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdWalletValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<Double>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdWalletJournalCall(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v6/characters/{character_id}/wallet/journal/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdWalletJournalValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdWalletJournal(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdWalletJournalCall(characterId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CharacterWalletJournalResponse> getCharactersCharacterIdWalletJournal(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CharacterWalletJournalResponse>> localVarResp = this.getCharactersCharacterIdWalletJournalWithHttpInfo(characterId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterWalletJournalResponse>> getCharactersCharacterIdWalletJournalWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdWalletJournalValidateBeforeCall(characterId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterWalletJournalResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdWalletJournalAsync(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CharacterWalletJournalResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdWalletJournalValidateBeforeCall(characterId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterWalletJournalResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdWalletTransactionsCall(Integer characterId, String datasource, Long fromId, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/characters/{character_id}/wallet/transactions/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (fromId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_id", fromId));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdWalletTransactionsValidateBeforeCall(Integer characterId, String datasource, Long fromId, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdWalletTransactions(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdWalletTransactionsCall(characterId, datasource, fromId, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CharacterWalletTransactionsResponse> getCharactersCharacterIdWalletTransactions(Integer characterId, String datasource, Long fromId, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterWalletTransactionsResponse>> localVarResp = this.getCharactersCharacterIdWalletTransactionsWithHttpInfo(characterId, datasource, fromId, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterWalletTransactionsResponse>> getCharactersCharacterIdWalletTransactionsWithHttpInfo(Integer characterId, String datasource, Long fromId, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdWalletTransactionsValidateBeforeCall(characterId, datasource, fromId, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterWalletTransactionsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdWalletTransactionsAsync(Integer characterId, String datasource, Long fromId, String ifNoneMatch, String token, ApiCallback<List<CharacterWalletTransactionsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdWalletTransactionsValidateBeforeCall(characterId, datasource, fromId, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterWalletTransactionsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdWalletsCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/corporations/{corporation_id}/wallets/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdWalletsValidateBeforeCall(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdWallets(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdWalletsCall(corporationId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CorporationWalletsResponse> getCorporationsCorporationIdWallets(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationWalletsResponse>> localVarResp = this.getCorporationsCorporationIdWalletsWithHttpInfo(corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationWalletsResponse>> getCorporationsCorporationIdWalletsWithHttpInfo(Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdWalletsValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationWalletsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdWalletsAsync(Integer corporationId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CorporationWalletsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdWalletsValidateBeforeCall(corporationId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationWalletsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdWalletsDivisionJournalCall(Integer corporationId, Integer division, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v4/corporations/{corporation_id}/wallets/{division}/journal/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString())).replaceAll("\\{division\\}", this.localVarApiClient.escapeString(division.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdWalletsDivisionJournalValidateBeforeCall(Integer corporationId, Integer division, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdWalletsDivisionJournal(Async)");
        }
        if (division == null) {
            throw new ApiException("Missing the required parameter 'division' when calling getCorporationsCorporationIdWalletsDivisionJournal(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdWalletsDivisionJournalCall(corporationId, division, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CorporationWalletJournalResponse> getCorporationsCorporationIdWalletsDivisionJournal(Integer corporationId, Integer division, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationWalletJournalResponse>> localVarResp = this.getCorporationsCorporationIdWalletsDivisionJournalWithHttpInfo(corporationId, division, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationWalletJournalResponse>> getCorporationsCorporationIdWalletsDivisionJournalWithHttpInfo(Integer corporationId, Integer division, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdWalletsDivisionJournalValidateBeforeCall(corporationId, division, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationWalletJournalResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdWalletsDivisionJournalAsync(Integer corporationId, Integer division, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CorporationWalletJournalResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdWalletsDivisionJournalValidateBeforeCall(corporationId, division, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationWalletJournalResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCorporationsCorporationIdWalletsDivisionTransactionsCall(Integer corporationId, Integer division, String datasource, Long fromId, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/corporations/{corporation_id}/wallets/{division}/transactions/".replaceAll("\\{corporation_id\\}", this.localVarApiClient.escapeString(corporationId.toString())).replaceAll("\\{division\\}", this.localVarApiClient.escapeString(division.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (fromId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_id", fromId));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCorporationsCorporationIdWalletsDivisionTransactionsValidateBeforeCall(Integer corporationId, Integer division, String datasource, Long fromId, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (corporationId == null) {
            throw new ApiException("Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdWalletsDivisionTransactions(Async)");
        }
        if (division == null) {
            throw new ApiException("Missing the required parameter 'division' when calling getCorporationsCorporationIdWalletsDivisionTransactions(Async)");
        }
        Call localVarCall = this.getCorporationsCorporationIdWalletsDivisionTransactionsCall(corporationId, division, datasource, fromId, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CorporationWalletTransactionsResponse> getCorporationsCorporationIdWalletsDivisionTransactions(Integer corporationId, Integer division, String datasource, Long fromId, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationWalletTransactionsResponse>> localVarResp = this.getCorporationsCorporationIdWalletsDivisionTransactionsWithHttpInfo(corporationId, division, datasource, fromId, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CorporationWalletTransactionsResponse>> getCorporationsCorporationIdWalletsDivisionTransactionsWithHttpInfo(Integer corporationId, Integer division, String datasource, Long fromId, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdWalletsDivisionTransactionsValidateBeforeCall(corporationId, division, datasource, fromId, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationWalletTransactionsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCorporationsCorporationIdWalletsDivisionTransactionsAsync(Integer corporationId, Integer division, String datasource, Long fromId, String ifNoneMatch, String token, ApiCallback<List<CorporationWalletTransactionsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCorporationsCorporationIdWalletsDivisionTransactionsValidateBeforeCall(corporationId, division, datasource, fromId, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationWalletTransactionsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

