/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.BloodlinesResponse;
import net.troja.eve.esi.model.CategoryResponse;
import net.troja.eve.esi.model.ConstellationResponse;
import net.troja.eve.esi.model.FactionsResponse;
import net.troja.eve.esi.model.GraphicResponse;
import net.troja.eve.esi.model.GroupResponse;
import net.troja.eve.esi.model.MoonResponse;
import net.troja.eve.esi.model.PlanetResponse;
import net.troja.eve.esi.model.RacesResponse;
import net.troja.eve.esi.model.RegionResponse;
import net.troja.eve.esi.model.StarResponse;
import net.troja.eve.esi.model.StargateResponse;
import net.troja.eve.esi.model.StationResponse;
import net.troja.eve.esi.model.StructureResponse;
import net.troja.eve.esi.model.SystemJumpsResponse;
import net.troja.eve.esi.model.SystemKillsResponse;
import net.troja.eve.esi.model.SystemResponse;
import net.troja.eve.esi.model.TypeResponse;
import net.troja.eve.esi.model.UniverseAncestriesResponse;
import net.troja.eve.esi.model.UniverseAsteroidBeltsResponse;
import net.troja.eve.esi.model.UniverseIdsResponse;
import net.troja.eve.esi.model.UniverseNamesResponse;
import okhttp3.Call;

public class UniverseApi {
    private ApiClient localVarApiClient;

    public UniverseApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UniverseApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getUniverseAncestriesCall(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/ancestries/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseAncestriesValidateBeforeCall(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseAncestriesCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public List<UniverseAncestriesResponse> getUniverseAncestries(String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<List<UniverseAncestriesResponse>> localVarResp = this.getUniverseAncestriesWithHttpInfo(acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<List<UniverseAncestriesResponse>> getUniverseAncestriesWithHttpInfo(String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseAncestriesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<List<UniverseAncestriesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseAncestriesAsync(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<List<UniverseAncestriesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseAncestriesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<List<UniverseAncestriesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseAsteroidBeltsAsteroidBeltIdCall(Integer asteroidBeltId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/asteroid_belts/{asteroid_belt_id}/".replaceAll("\\{asteroid_belt_id\\}", this.localVarApiClient.escapeString(asteroidBeltId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(Integer asteroidBeltId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (asteroidBeltId == null) {
            throw new ApiException("Missing the required parameter 'asteroidBeltId' when calling getUniverseAsteroidBeltsAsteroidBeltId(Async)");
        }
        Call localVarCall = this.getUniverseAsteroidBeltsAsteroidBeltIdCall(asteroidBeltId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public UniverseAsteroidBeltsResponse getUniverseAsteroidBeltsAsteroidBeltId(Integer asteroidBeltId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<UniverseAsteroidBeltsResponse> localVarResp = this.getUniverseAsteroidBeltsAsteroidBeltIdWithHttpInfo(asteroidBeltId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<UniverseAsteroidBeltsResponse> getUniverseAsteroidBeltsAsteroidBeltIdWithHttpInfo(Integer asteroidBeltId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(asteroidBeltId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<UniverseAsteroidBeltsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseAsteroidBeltsAsteroidBeltIdAsync(Integer asteroidBeltId, String datasource, String ifNoneMatch, ApiCallback<UniverseAsteroidBeltsResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(asteroidBeltId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<UniverseAsteroidBeltsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseBloodlinesCall(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/bloodlines/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseBloodlinesValidateBeforeCall(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseBloodlinesCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public List<BloodlinesResponse> getUniverseBloodlines(String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<List<BloodlinesResponse>> localVarResp = this.getUniverseBloodlinesWithHttpInfo(acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<List<BloodlinesResponse>> getUniverseBloodlinesWithHttpInfo(String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseBloodlinesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<List<BloodlinesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseBloodlinesAsync(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<List<BloodlinesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseBloodlinesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<List<BloodlinesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseCategoriesCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/categories/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseCategoriesValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseCategoriesCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Integer> getUniverseCategories(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getUniverseCategoriesWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getUniverseCategoriesWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseCategoriesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseCategoriesAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseCategoriesValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseCategoriesCategoryIdCall(Integer categoryId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/categories/{category_id}/".replaceAll("\\{category_id\\}", this.localVarApiClient.escapeString(categoryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseCategoriesCategoryIdValidateBeforeCall(Integer categoryId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        if (categoryId == null) {
            throw new ApiException("Missing the required parameter 'categoryId' when calling getUniverseCategoriesCategoryId(Async)");
        }
        Call localVarCall = this.getUniverseCategoriesCategoryIdCall(categoryId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public CategoryResponse getUniverseCategoriesCategoryId(Integer categoryId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<CategoryResponse> localVarResp = this.getUniverseCategoriesCategoryIdWithHttpInfo(categoryId, acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<CategoryResponse> getUniverseCategoriesCategoryIdWithHttpInfo(Integer categoryId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseCategoriesCategoryIdValidateBeforeCall(categoryId, acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<CategoryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseCategoriesCategoryIdAsync(Integer categoryId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<CategoryResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseCategoriesCategoryIdValidateBeforeCall(categoryId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseConstellationsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/constellations/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseConstellationsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseConstellationsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Integer> getUniverseConstellations(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getUniverseConstellationsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getUniverseConstellationsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseConstellationsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseConstellationsAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseConstellationsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseConstellationsConstellationIdCall(Integer constellationId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/constellations/{constellation_id}/".replaceAll("\\{constellation_id\\}", this.localVarApiClient.escapeString(constellationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseConstellationsConstellationIdValidateBeforeCall(Integer constellationId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        if (constellationId == null) {
            throw new ApiException("Missing the required parameter 'constellationId' when calling getUniverseConstellationsConstellationId(Async)");
        }
        Call localVarCall = this.getUniverseConstellationsConstellationIdCall(constellationId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public ConstellationResponse getUniverseConstellationsConstellationId(Integer constellationId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<ConstellationResponse> localVarResp = this.getUniverseConstellationsConstellationIdWithHttpInfo(constellationId, acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<ConstellationResponse> getUniverseConstellationsConstellationIdWithHttpInfo(Integer constellationId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseConstellationsConstellationIdValidateBeforeCall(constellationId, acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<ConstellationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseConstellationsConstellationIdAsync(Integer constellationId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<ConstellationResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseConstellationsConstellationIdValidateBeforeCall(constellationId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<ConstellationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseFactionsCall(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v2/universe/factions/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseFactionsValidateBeforeCall(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseFactionsCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public List<FactionsResponse> getUniverseFactions(String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<List<FactionsResponse>> localVarResp = this.getUniverseFactionsWithHttpInfo(acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<List<FactionsResponse>> getUniverseFactionsWithHttpInfo(String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseFactionsValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<List<FactionsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseFactionsAsync(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<List<FactionsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseFactionsValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<List<FactionsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseGraphicsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/graphics/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseGraphicsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseGraphicsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Integer> getUniverseGraphics(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getUniverseGraphicsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getUniverseGraphicsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseGraphicsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseGraphicsAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseGraphicsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseGraphicsGraphicIdCall(Integer graphicId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/graphics/{graphic_id}/".replaceAll("\\{graphic_id\\}", this.localVarApiClient.escapeString(graphicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseGraphicsGraphicIdValidateBeforeCall(Integer graphicId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (graphicId == null) {
            throw new ApiException("Missing the required parameter 'graphicId' when calling getUniverseGraphicsGraphicId(Async)");
        }
        Call localVarCall = this.getUniverseGraphicsGraphicIdCall(graphicId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public GraphicResponse getUniverseGraphicsGraphicId(Integer graphicId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<GraphicResponse> localVarResp = this.getUniverseGraphicsGraphicIdWithHttpInfo(graphicId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<GraphicResponse> getUniverseGraphicsGraphicIdWithHttpInfo(Integer graphicId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseGraphicsGraphicIdValidateBeforeCall(graphicId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<GraphicResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseGraphicsGraphicIdAsync(Integer graphicId, String datasource, String ifNoneMatch, ApiCallback<GraphicResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseGraphicsGraphicIdValidateBeforeCall(graphicId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<GraphicResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseGroupsCall(String datasource, String ifNoneMatch, Integer page, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/groups/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseGroupsValidateBeforeCall(String datasource, String ifNoneMatch, Integer page, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseGroupsCall(datasource, ifNoneMatch, page, _callback);
        return localVarCall;
    }

    public List<Integer> getUniverseGroups(String datasource, String ifNoneMatch, Integer page) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getUniverseGroupsWithHttpInfo(datasource, ifNoneMatch, page);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getUniverseGroupsWithHttpInfo(String datasource, String ifNoneMatch, Integer page) throws ApiException {
        Call localVarCall = this.getUniverseGroupsValidateBeforeCall(datasource, ifNoneMatch, page, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseGroupsAsync(String datasource, String ifNoneMatch, Integer page, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseGroupsValidateBeforeCall(datasource, ifNoneMatch, page, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseGroupsGroupIdCall(Integer groupId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/groups/{group_id}/".replaceAll("\\{group_id\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseGroupsGroupIdValidateBeforeCall(Integer groupId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getUniverseGroupsGroupId(Async)");
        }
        Call localVarCall = this.getUniverseGroupsGroupIdCall(groupId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public GroupResponse getUniverseGroupsGroupId(Integer groupId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<GroupResponse> localVarResp = this.getUniverseGroupsGroupIdWithHttpInfo(groupId, acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<GroupResponse> getUniverseGroupsGroupIdWithHttpInfo(Integer groupId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseGroupsGroupIdValidateBeforeCall(groupId, acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<GroupResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseGroupsGroupIdAsync(Integer groupId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<GroupResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseGroupsGroupIdValidateBeforeCall(groupId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<GroupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseMoonsMoonIdCall(Integer moonId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/moons/{moon_id}/".replaceAll("\\{moon_id\\}", this.localVarApiClient.escapeString(moonId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseMoonsMoonIdValidateBeforeCall(Integer moonId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (moonId == null) {
            throw new ApiException("Missing the required parameter 'moonId' when calling getUniverseMoonsMoonId(Async)");
        }
        Call localVarCall = this.getUniverseMoonsMoonIdCall(moonId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public MoonResponse getUniverseMoonsMoonId(Integer moonId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<MoonResponse> localVarResp = this.getUniverseMoonsMoonIdWithHttpInfo(moonId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<MoonResponse> getUniverseMoonsMoonIdWithHttpInfo(Integer moonId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseMoonsMoonIdValidateBeforeCall(moonId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<MoonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseMoonsMoonIdAsync(Integer moonId, String datasource, String ifNoneMatch, ApiCallback<MoonResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseMoonsMoonIdValidateBeforeCall(moonId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<MoonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniversePlanetsPlanetIdCall(Integer planetId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/planets/{planet_id}/".replaceAll("\\{planet_id\\}", this.localVarApiClient.escapeString(planetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniversePlanetsPlanetIdValidateBeforeCall(Integer planetId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (planetId == null) {
            throw new ApiException("Missing the required parameter 'planetId' when calling getUniversePlanetsPlanetId(Async)");
        }
        Call localVarCall = this.getUniversePlanetsPlanetIdCall(planetId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public PlanetResponse getUniversePlanetsPlanetId(Integer planetId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<PlanetResponse> localVarResp = this.getUniversePlanetsPlanetIdWithHttpInfo(planetId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<PlanetResponse> getUniversePlanetsPlanetIdWithHttpInfo(Integer planetId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniversePlanetsPlanetIdValidateBeforeCall(planetId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<PlanetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniversePlanetsPlanetIdAsync(Integer planetId, String datasource, String ifNoneMatch, ApiCallback<PlanetResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniversePlanetsPlanetIdValidateBeforeCall(planetId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<PlanetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseRacesCall(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/races/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseRacesValidateBeforeCall(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseRacesCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public List<RacesResponse> getUniverseRaces(String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<List<RacesResponse>> localVarResp = this.getUniverseRacesWithHttpInfo(acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<List<RacesResponse>> getUniverseRacesWithHttpInfo(String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseRacesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<List<RacesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseRacesAsync(String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<List<RacesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseRacesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<List<RacesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseRegionsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/regions/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseRegionsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseRegionsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Integer> getUniverseRegions(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getUniverseRegionsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getUniverseRegionsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseRegionsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseRegionsAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseRegionsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseRegionsRegionIdCall(Integer regionId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/regions/{region_id}/".replaceAll("\\{region_id\\}", this.localVarApiClient.escapeString(regionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseRegionsRegionIdValidateBeforeCall(Integer regionId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        if (regionId == null) {
            throw new ApiException("Missing the required parameter 'regionId' when calling getUniverseRegionsRegionId(Async)");
        }
        Call localVarCall = this.getUniverseRegionsRegionIdCall(regionId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public RegionResponse getUniverseRegionsRegionId(Integer regionId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<RegionResponse> localVarResp = this.getUniverseRegionsRegionIdWithHttpInfo(regionId, acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<RegionResponse> getUniverseRegionsRegionIdWithHttpInfo(Integer regionId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseRegionsRegionIdValidateBeforeCall(regionId, acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<RegionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseRegionsRegionIdAsync(Integer regionId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<RegionResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseRegionsRegionIdValidateBeforeCall(regionId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<RegionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseStargatesStargateIdCall(Integer stargateId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/stargates/{stargate_id}/".replaceAll("\\{stargate_id\\}", this.localVarApiClient.escapeString(stargateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseStargatesStargateIdValidateBeforeCall(Integer stargateId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (stargateId == null) {
            throw new ApiException("Missing the required parameter 'stargateId' when calling getUniverseStargatesStargateId(Async)");
        }
        Call localVarCall = this.getUniverseStargatesStargateIdCall(stargateId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public StargateResponse getUniverseStargatesStargateId(Integer stargateId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<StargateResponse> localVarResp = this.getUniverseStargatesStargateIdWithHttpInfo(stargateId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<StargateResponse> getUniverseStargatesStargateIdWithHttpInfo(Integer stargateId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseStargatesStargateIdValidateBeforeCall(stargateId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<StargateResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseStargatesStargateIdAsync(Integer stargateId, String datasource, String ifNoneMatch, ApiCallback<StargateResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseStargatesStargateIdValidateBeforeCall(stargateId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<StargateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseStarsStarIdCall(Integer starId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/stars/{star_id}/".replaceAll("\\{star_id\\}", this.localVarApiClient.escapeString(starId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseStarsStarIdValidateBeforeCall(Integer starId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (starId == null) {
            throw new ApiException("Missing the required parameter 'starId' when calling getUniverseStarsStarId(Async)");
        }
        Call localVarCall = this.getUniverseStarsStarIdCall(starId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public StarResponse getUniverseStarsStarId(Integer starId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<StarResponse> localVarResp = this.getUniverseStarsStarIdWithHttpInfo(starId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<StarResponse> getUniverseStarsStarIdWithHttpInfo(Integer starId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseStarsStarIdValidateBeforeCall(starId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<StarResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseStarsStarIdAsync(Integer starId, String datasource, String ifNoneMatch, ApiCallback<StarResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseStarsStarIdValidateBeforeCall(starId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<StarResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseStationsStationIdCall(Integer stationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v2/universe/stations/{station_id}/".replaceAll("\\{station_id\\}", this.localVarApiClient.escapeString(stationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseStationsStationIdValidateBeforeCall(Integer stationId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (stationId == null) {
            throw new ApiException("Missing the required parameter 'stationId' when calling getUniverseStationsStationId(Async)");
        }
        Call localVarCall = this.getUniverseStationsStationIdCall(stationId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public StationResponse getUniverseStationsStationId(Integer stationId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<StationResponse> localVarResp = this.getUniverseStationsStationIdWithHttpInfo(stationId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<StationResponse> getUniverseStationsStationIdWithHttpInfo(Integer stationId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseStationsStationIdValidateBeforeCall(stationId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<StationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseStationsStationIdAsync(Integer stationId, String datasource, String ifNoneMatch, ApiCallback<StationResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseStationsStationIdValidateBeforeCall(stationId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<StationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseStructuresCall(String datasource, String filter, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/structures/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseStructuresValidateBeforeCall(String datasource, String filter, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseStructuresCall(datasource, filter, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Long> getUniverseStructures(String datasource, String filter, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Long>> localVarResp = this.getUniverseStructuresWithHttpInfo(datasource, filter, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Long>> getUniverseStructuresWithHttpInfo(String datasource, String filter, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseStructuresValidateBeforeCall(datasource, filter, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Long>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseStructuresAsync(String datasource, String filter, String ifNoneMatch, ApiCallback<List<Long>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseStructuresValidateBeforeCall(datasource, filter, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Long>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseStructuresStructureIdCall(Long structureId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v2/universe/structures/{structure_id}/".replaceAll("\\{structure_id\\}", this.localVarApiClient.escapeString(structureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseStructuresStructureIdValidateBeforeCall(Long structureId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (structureId == null) {
            throw new ApiException("Missing the required parameter 'structureId' when calling getUniverseStructuresStructureId(Async)");
        }
        Call localVarCall = this.getUniverseStructuresStructureIdCall(structureId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public StructureResponse getUniverseStructuresStructureId(Long structureId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<StructureResponse> localVarResp = this.getUniverseStructuresStructureIdWithHttpInfo(structureId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<StructureResponse> getUniverseStructuresStructureIdWithHttpInfo(Long structureId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getUniverseStructuresStructureIdValidateBeforeCall(structureId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<StructureResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseStructuresStructureIdAsync(Long structureId, String datasource, String ifNoneMatch, String token, ApiCallback<StructureResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseStructuresStructureIdValidateBeforeCall(structureId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<StructureResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseSystemJumpsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/system_jumps/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseSystemJumpsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseSystemJumpsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<SystemJumpsResponse> getUniverseSystemJumps(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<SystemJumpsResponse>> localVarResp = this.getUniverseSystemJumpsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<SystemJumpsResponse>> getUniverseSystemJumpsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseSystemJumpsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<SystemJumpsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseSystemJumpsAsync(String datasource, String ifNoneMatch, ApiCallback<List<SystemJumpsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseSystemJumpsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<SystemJumpsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseSystemKillsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v2/universe/system_kills/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseSystemKillsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseSystemKillsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<SystemKillsResponse> getUniverseSystemKills(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<SystemKillsResponse>> localVarResp = this.getUniverseSystemKillsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<SystemKillsResponse>> getUniverseSystemKillsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseSystemKillsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<SystemKillsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseSystemKillsAsync(String datasource, String ifNoneMatch, ApiCallback<List<SystemKillsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseSystemKillsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<SystemKillsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseSystemsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/systems/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseSystemsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseSystemsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Integer> getUniverseSystems(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getUniverseSystemsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getUniverseSystemsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getUniverseSystemsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseSystemsAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseSystemsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseSystemsSystemIdCall(Integer systemId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v4/universe/systems/{system_id}/".replaceAll("\\{system_id\\}", this.localVarApiClient.escapeString(systemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseSystemsSystemIdValidateBeforeCall(Integer systemId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        if (systemId == null) {
            throw new ApiException("Missing the required parameter 'systemId' when calling getUniverseSystemsSystemId(Async)");
        }
        Call localVarCall = this.getUniverseSystemsSystemIdCall(systemId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public SystemResponse getUniverseSystemsSystemId(Integer systemId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<SystemResponse> localVarResp = this.getUniverseSystemsSystemIdWithHttpInfo(systemId, acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<SystemResponse> getUniverseSystemsSystemIdWithHttpInfo(Integer systemId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseSystemsSystemIdValidateBeforeCall(systemId, acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<SystemResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseSystemsSystemIdAsync(Integer systemId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<SystemResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseSystemsSystemIdValidateBeforeCall(systemId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<SystemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseTypesCall(String datasource, String ifNoneMatch, Integer page, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v1/universe/types/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseTypesValidateBeforeCall(String datasource, String ifNoneMatch, Integer page, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUniverseTypesCall(datasource, ifNoneMatch, page, _callback);
        return localVarCall;
    }

    public List<Integer> getUniverseTypes(String datasource, String ifNoneMatch, Integer page) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getUniverseTypesWithHttpInfo(datasource, ifNoneMatch, page);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getUniverseTypesWithHttpInfo(String datasource, String ifNoneMatch, Integer page) throws ApiException {
        Call localVarCall = this.getUniverseTypesValidateBeforeCall(datasource, ifNoneMatch, page, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseTypesAsync(String datasource, String ifNoneMatch, Integer page, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getUniverseTypesValidateBeforeCall(datasource, ifNoneMatch, page, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniverseTypesTypeIdCall(Integer typeId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/v3/universe/types/{type_id}/".replaceAll("\\{type_id\\}", this.localVarApiClient.escapeString(typeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniverseTypesTypeIdValidateBeforeCall(Integer typeId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback _callback) throws ApiException {
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling getUniverseTypesTypeId(Async)");
        }
        Call localVarCall = this.getUniverseTypesTypeIdCall(typeId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        return localVarCall;
    }

    public TypeResponse getUniverseTypesTypeId(Integer typeId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<TypeResponse> localVarResp = this.getUniverseTypesTypeIdWithHttpInfo(typeId, acceptLanguage, datasource, ifNoneMatch, language);
        return localVarResp.getData();
    }

    public ApiResponse<TypeResponse> getUniverseTypesTypeIdWithHttpInfo(Integer typeId, String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        Call localVarCall = this.getUniverseTypesTypeIdValidateBeforeCall(typeId, acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<TypeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniverseTypesTypeIdAsync(Integer typeId, String acceptLanguage, String datasource, String ifNoneMatch, String language, ApiCallback<TypeResponse> _callback) throws ApiException {
        Call localVarCall = this.getUniverseTypesTypeIdValidateBeforeCall(typeId, acceptLanguage, datasource, ifNoneMatch, language, _callback);
        Type localVarReturnType = new TypeToken<TypeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postUniverseIdsCall(List<String> names, String acceptLanguage, String datasource, String language, ApiCallback _callback) throws ApiException {
        List<String> localVarPostBody = names;
        String localVarPath = "/v1/universe/ids/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postUniverseIdsValidateBeforeCall(List<String> names, String acceptLanguage, String datasource, String language, ApiCallback _callback) throws ApiException {
        if (names == null) {
            throw new ApiException("Missing the required parameter 'names' when calling postUniverseIds(Async)");
        }
        Call localVarCall = this.postUniverseIdsCall(names, acceptLanguage, datasource, language, _callback);
        return localVarCall;
    }

    public UniverseIdsResponse postUniverseIds(List<String> names, String acceptLanguage, String datasource, String language) throws ApiException {
        ApiResponse<UniverseIdsResponse> localVarResp = this.postUniverseIdsWithHttpInfo(names, acceptLanguage, datasource, language);
        return localVarResp.getData();
    }

    public ApiResponse<UniverseIdsResponse> postUniverseIdsWithHttpInfo(List<String> names, String acceptLanguage, String datasource, String language) throws ApiException {
        Call localVarCall = this.postUniverseIdsValidateBeforeCall(names, acceptLanguage, datasource, language, null);
        Type localVarReturnType = new TypeToken<UniverseIdsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postUniverseIdsAsync(List<String> names, String acceptLanguage, String datasource, String language, ApiCallback<UniverseIdsResponse> _callback) throws ApiException {
        Call localVarCall = this.postUniverseIdsValidateBeforeCall(names, acceptLanguage, datasource, language, _callback);
        Type localVarReturnType = new TypeToken<UniverseIdsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postUniverseNamesCall(List<Integer> ids, String datasource, ApiCallback _callback) throws ApiException {
        List<Integer> localVarPostBody = ids;
        String localVarPath = "/v3/universe/names/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postUniverseNamesValidateBeforeCall(List<Integer> ids, String datasource, ApiCallback _callback) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling postUniverseNames(Async)");
        }
        Call localVarCall = this.postUniverseNamesCall(ids, datasource, _callback);
        return localVarCall;
    }

    public List<UniverseNamesResponse> postUniverseNames(List<Integer> ids, String datasource) throws ApiException {
        ApiResponse<List<UniverseNamesResponse>> localVarResp = this.postUniverseNamesWithHttpInfo(ids, datasource);
        return localVarResp.getData();
    }

    public ApiResponse<List<UniverseNamesResponse>> postUniverseNamesWithHttpInfo(List<Integer> ids, String datasource) throws ApiException {
        Call localVarCall = this.postUniverseNamesValidateBeforeCall(ids, datasource, null);
        Type localVarReturnType = new TypeToken<List<UniverseNamesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postUniverseNamesAsync(List<Integer> ids, String datasource, ApiCallback<List<UniverseNamesResponse>> _callback) throws ApiException {
        Call localVarCall = this.postUniverseNamesValidateBeforeCall(ids, datasource, _callback);
        Type localVarReturnType = new TypeToken<List<UniverseNamesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

