/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import java.util.ArrayList;
import java.util.HashMap;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiClientBuilder;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.api.MetaApi;
import net.troja.eve.esi.auth.OAuth;
import net.troja.eve.esi.model.CharacterInfo;
import okhttp3.Call;

public class SsoApi {
    private static final String URI_REVOKE = "https://login.eveonline.com";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String DATASOURCE = "tranquility";
    protected static final String DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private final ApiClient revokeApiClient = new ApiClientBuilder().build();
    private ApiClient apiClient;
    private MetaApi metaApi;

    public SsoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SsoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.metaApi = new MetaApi(apiClient);
        this.revokeApiClient.setBasePath(URI_REVOKE);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.metaApi.setApiClient(apiClient);
    }

    public CharacterInfo getCharacterInfo() throws ApiException {
        return new CharacterInfo(this.metaApi.getVerify(null, null, DATASOURCE, null, null));
    }

    public void revokeRefreshToken(String refreshToken) throws ApiException {
        this.postRevokeToken(refreshToken, REFRESH_TOKEN);
    }

    public void revokeAccessToken(String accessToken) throws ApiException {
        this.postRevokeToken(accessToken, ACCESS_TOKEN);
    }

    private Call postRevokeTokenCall(String token, String tokenTypeHint, ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();
        OAuth auth = (OAuth)this.apiClient.getAuthentication("evesso");
        String localVarPath = "/v2/oauth/revoke";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        localVarHeaderParams.put("Host", "login.eveonline.com");
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarFormParams.put("token_type_hint", tokenTypeHint);
        localVarFormParams.put("client_id", auth.getClientId());
        localVarFormParams.put("token", token);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.revokeApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.revokeApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.revokeApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    private Call postRevokeTokenValidateBeforeCall(String token, String tokenTypeHint, ApiCallback callback) throws ApiException {
        return this.postRevokeTokenCall(token, tokenTypeHint, callback);
    }

    private void postRevokeToken(String token, String tokenTypeHint) throws ApiException {
        this.postRevokeTokenWithHttpInfo(token, tokenTypeHint);
    }

    private ApiResponse<Void> postRevokeTokenWithHttpInfo(String token, String tokenTypeHint) throws ApiException {
        Call call = this.postRevokeTokenValidateBeforeCall(token, tokenTypeHint, null);
        return this.revokeApiClient.execute(call);
    }
}

