/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 0.8.9
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import net.troja.eve.esi.model.Aggressor;
import net.troja.eve.esi.model.Defender;
import net.troja.eve.esi.model.WarAlly;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class WarResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final String SERIALIZED_NAME_DECLARED = "declared";
    @SerializedName(SERIALIZED_NAME_DECLARED)
    private OffsetDateTime declared;

    public static final String SERIALIZED_NAME_AGGRESSOR = "aggressor";
    @SerializedName(SERIALIZED_NAME_AGGRESSOR)
    private Aggressor aggressor = null;

    public static final String SERIALIZED_NAME_OPEN_FOR_ALLIES = "open_for_allies";
    @SerializedName(SERIALIZED_NAME_OPEN_FOR_ALLIES)
    private Boolean openForAllies;

    public static final String SERIALIZED_NAME_RETRACTED = "retracted";
    @SerializedName(SERIALIZED_NAME_RETRACTED)
    private OffsetDateTime retracted;

    public static final String SERIALIZED_NAME_MUTUAL = "mutual";
    @SerializedName(SERIALIZED_NAME_MUTUAL)
    private Boolean mutual;

    public static final String SERIALIZED_NAME_FINISHED = "finished";
    @SerializedName(SERIALIZED_NAME_FINISHED)
    private OffsetDateTime finished;

    public static final String SERIALIZED_NAME_STARTED = "started";
    @SerializedName(SERIALIZED_NAME_STARTED)
    private OffsetDateTime started;

    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(SERIALIZED_NAME_ID)
    private Integer id;

    public static final String SERIALIZED_NAME_ALLIES = "allies";
    @SerializedName(SERIALIZED_NAME_ALLIES)
    private List<WarAlly> allies = new ArrayList<>();

    public static final String SERIALIZED_NAME_DEFENDER = "defender";
    @SerializedName(SERIALIZED_NAME_DEFENDER)
    private Defender defender = null;

    public WarResponse declared(OffsetDateTime declared) {
        this.declared = declared;
        return this;
    }

    /**
     * Time that the war was declared
     * 
     * @return declared
     **/
    @ApiModelProperty(required = true, value = "Time that the war was declared")
    public OffsetDateTime getDeclared() {
        return declared;
    }

    public void setDeclared(OffsetDateTime declared) {
        this.declared = declared;
    }

    public WarResponse aggressor(Aggressor aggressor) {
        this.aggressor = aggressor;
        return this;
    }

    /**
     * Get aggressor
     * 
     * @return aggressor
     **/
    @ApiModelProperty(required = true, value = "")
    public Aggressor getAggressor() {
        return aggressor;
    }

    public void setAggressor(Aggressor aggressor) {
        this.aggressor = aggressor;
    }

    public WarResponse openForAllies(Boolean openForAllies) {
        this.openForAllies = openForAllies;
        return this;
    }

    /**
     * Is the war currently open for allies or not
     * 
     * @return openForAllies
     **/
    @ApiModelProperty(required = true, value = "Is the war currently open for allies or not")
    public Boolean getOpenForAllies() {
        return openForAllies;
    }

    public void setOpenForAllies(Boolean openForAllies) {
        this.openForAllies = openForAllies;
    }

    public WarResponse retracted(OffsetDateTime retracted) {
        this.retracted = retracted;
        return this;
    }

    /**
     * Time the war was retracted but both sides could still shoot each other
     * 
     * @return retracted
     **/
    @ApiModelProperty(value = "Time the war was retracted but both sides could still shoot each other")
    public OffsetDateTime getRetracted() {
        return retracted;
    }

    public void setRetracted(OffsetDateTime retracted) {
        this.retracted = retracted;
    }

    public WarResponse mutual(Boolean mutual) {
        this.mutual = mutual;
        return this;
    }

    /**
     * Was the war declared mutual by both parties
     * 
     * @return mutual
     **/
    @ApiModelProperty(required = true, value = "Was the war declared mutual by both parties")
    public Boolean getMutual() {
        return mutual;
    }

    public void setMutual(Boolean mutual) {
        this.mutual = mutual;
    }

    public WarResponse finished(OffsetDateTime finished) {
        this.finished = finished;
        return this;
    }

    /**
     * Time the war ended and shooting was no longer allowed
     * 
     * @return finished
     **/
    @ApiModelProperty(value = "Time the war ended and shooting was no longer allowed")
    public OffsetDateTime getFinished() {
        return finished;
    }

    public void setFinished(OffsetDateTime finished) {
        this.finished = finished;
    }

    public WarResponse started(OffsetDateTime started) {
        this.started = started;
        return this;
    }

    /**
     * Time when the war started and both sides could shoot each other
     * 
     * @return started
     **/
    @ApiModelProperty(value = "Time when the war started and both sides could shoot each other")
    public OffsetDateTime getStarted() {
        return started;
    }

    public void setStarted(OffsetDateTime started) {
        this.started = started;
    }

    public WarResponse id(Integer id) {
        this.id = id;
        return this;
    }

    /**
     * ID of the specified war
     * 
     * @return id
     **/
    @ApiModelProperty(required = true, value = "ID of the specified war")
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public WarResponse allies(List<WarAlly> allies) {
        this.allies = allies;
        return this;
    }

    public WarResponse addAlliesItem(WarAlly alliesItem) {
        if (this.allies == null) {
            this.allies = new ArrayList<>();
        }
        this.allies.add(alliesItem);
        return this;
    }

    /**
     * allied corporations or alliances, each object contains either
     * corporation_id or alliance_id
     * 
     * @return allies
     **/
    @ApiModelProperty(value = "allied corporations or alliances, each object contains either corporation_id or alliance_id")
    public List<WarAlly> getAllies() {
        return allies;
    }

    public void setAllies(List<WarAlly> allies) {
        this.allies = allies;
    }

    public WarResponse defender(Defender defender) {
        this.defender = defender;
        return this;
    }

    /**
     * Get defender
     * 
     * @return defender
     **/
    @ApiModelProperty(required = true, value = "")
    public Defender getDefender() {
        return defender;
    }

    public void setDefender(Defender defender) {
        this.defender = defender;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WarResponse warResponse = (WarResponse) o;
        return Objects.equals(this.declared, warResponse.declared)
                && Objects.equals(this.aggressor, warResponse.aggressor)
                && Objects.equals(this.openForAllies, warResponse.openForAllies)
                && Objects.equals(this.retracted, warResponse.retracted)
                && Objects.equals(this.mutual, warResponse.mutual)
                && Objects.equals(this.finished, warResponse.finished)
                && Objects.equals(this.started, warResponse.started) && Objects.equals(this.id, warResponse.id)
                && Objects.equals(this.allies, warResponse.allies)
                && Objects.equals(this.defender, warResponse.defender);
    }

    @Override
    public int hashCode() {
        return Objects.hash(declared, aggressor, openForAllies, retracted, mutual, finished, started, id, allies,
                defender);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WarResponse {\n");
        sb.append("    declared: ").append(toIndentedString(declared)).append("\n");
        sb.append("    aggressor: ").append(toIndentedString(aggressor)).append("\n");
        sb.append("    openForAllies: ").append(toIndentedString(openForAllies)).append("\n");
        sb.append("    retracted: ").append(toIndentedString(retracted)).append("\n");
        sb.append("    mutual: ").append(toIndentedString(mutual)).append("\n");
        sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
        sb.append("    started: ").append(toIndentedString(started)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    allies: ").append(toIndentedString(allies)).append("\n");
        sb.append("    defender: ").append(toIndentedString(defender)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
