/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.SovereigntyCampaignParticipant;

@ApiModel(description="200 ok object")
public class SovereigntyCampaignsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "event_type";
    @SerializedName(value="event_type")
    private EventTypeEnum eventType;
    public static final String SERIALIZED_NAME_DEFENDER_ID = "defender_id";
    @SerializedName(value="defender_id")
    private Integer defenderId;
    public static final String SERIALIZED_NAME_ATTACKERS_SCORE = "attackers_score";
    @SerializedName(value="attackers_score")
    private Float attackersScore;
    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(value="solar_system_id")
    private Integer solarSystemId;
    public static final String SERIALIZED_NAME_STRUCTURE_ID = "structure_id";
    @SerializedName(value="structure_id")
    private Long structureId;
    public static final String SERIALIZED_NAME_DEFENDER_SCORE = "defender_score";
    @SerializedName(value="defender_score")
    private Float defenderScore;
    public static final String SERIALIZED_NAME_CAMPAIGN_ID = "campaign_id";
    @SerializedName(value="campaign_id")
    private Integer campaignId;
    public static final String SERIALIZED_NAME_CONSTELLATION_ID = "constellation_id";
    @SerializedName(value="constellation_id")
    private Integer constellationId;
    public static final String SERIALIZED_NAME_PARTICIPANTS = "participants";
    @SerializedName(value="participants")
    private List<SovereigntyCampaignParticipant> participants = new ArrayList<SovereigntyCampaignParticipant>();

    public SovereigntyCampaignsResponse startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Time the event is scheduled to start. ")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public SovereigntyCampaignsResponse eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of event this campaign is for. tcu_defense, ihub_defense and station_defense are referred to as \"Defense Events\", station_freeport as \"Freeport Events\". ")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public SovereigntyCampaignsResponse defenderId(Integer defenderId) {
        this.defenderId = defenderId;
        return this;
    }

    @ApiModelProperty(value="Defending alliance, only present in Defense Events ")
    public Integer getDefenderId() {
        return this.defenderId;
    }

    public void setDefenderId(Integer defenderId) {
        this.defenderId = defenderId;
    }

    public SovereigntyCampaignsResponse attackersScore(Float attackersScore) {
        this.attackersScore = attackersScore;
        return this;
    }

    @ApiModelProperty(value="Score for all attacking parties, only present in Defense Events. ")
    public Float getAttackersScore() {
        return this.attackersScore;
    }

    public void setAttackersScore(Float attackersScore) {
        this.attackersScore = attackersScore;
    }

    public SovereigntyCampaignsResponse solarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The solar system the structure is located in. ")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public SovereigntyCampaignsResponse structureId(Long structureId) {
        this.structureId = structureId;
        return this;
    }

    @ApiModelProperty(required=true, value="The structure item ID that is related to this campaign. ")
    public Long getStructureId() {
        return this.structureId;
    }

    public void setStructureId(Long structureId) {
        this.structureId = structureId;
    }

    public SovereigntyCampaignsResponse defenderScore(Float defenderScore) {
        this.defenderScore = defenderScore;
        return this;
    }

    @ApiModelProperty(value="Score for the defending alliance, only present in Defense Events. ")
    public Float getDefenderScore() {
        return this.defenderScore;
    }

    public void setDefenderScore(Float defenderScore) {
        this.defenderScore = defenderScore;
    }

    public SovereigntyCampaignsResponse campaignId(Integer campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique ID for this campaign.")
    public Integer getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Integer campaignId) {
        this.campaignId = campaignId;
    }

    public SovereigntyCampaignsResponse constellationId(Integer constellationId) {
        this.constellationId = constellationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The constellation in which the campaign will take place. ")
    public Integer getConstellationId() {
        return this.constellationId;
    }

    public void setConstellationId(Integer constellationId) {
        this.constellationId = constellationId;
    }

    public SovereigntyCampaignsResponse participants(List<SovereigntyCampaignParticipant> participants) {
        this.participants = participants;
        return this;
    }

    public SovereigntyCampaignsResponse addParticipantsItem(SovereigntyCampaignParticipant participantsItem) {
        if (this.participants == null) {
            this.participants = new ArrayList<SovereigntyCampaignParticipant>();
        }
        this.participants.add(participantsItem);
        return this;
    }

    @ApiModelProperty(value="Alliance participating and their respective scores, only present in Freeport Events. ")
    public List<SovereigntyCampaignParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<SovereigntyCampaignParticipant> participants) {
        this.participants = participants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SovereigntyCampaignsResponse sovereigntyCampaignsResponse = (SovereigntyCampaignsResponse)o;
        return Objects.equals(this.startTime, sovereigntyCampaignsResponse.startTime) && Objects.equals((Object)this.eventType, (Object)sovereigntyCampaignsResponse.eventType) && Objects.equals(this.defenderId, sovereigntyCampaignsResponse.defenderId) && Objects.equals(this.attackersScore, sovereigntyCampaignsResponse.attackersScore) && Objects.equals(this.solarSystemId, sovereigntyCampaignsResponse.solarSystemId) && Objects.equals(this.structureId, sovereigntyCampaignsResponse.structureId) && Objects.equals(this.defenderScore, sovereigntyCampaignsResponse.defenderScore) && Objects.equals(this.campaignId, sovereigntyCampaignsResponse.campaignId) && Objects.equals(this.constellationId, sovereigntyCampaignsResponse.constellationId) && Objects.equals(this.participants, sovereigntyCampaignsResponse.participants);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startTime, this.eventType, this.defenderId, this.attackersScore, this.solarSystemId, this.structureId, this.defenderScore, this.campaignId, this.constellationId, this.participants});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SovereigntyCampaignsResponse {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    defenderId: ").append(this.toIndentedString(this.defenderId)).append("\n");
        sb.append("    attackersScore: ").append(this.toIndentedString(this.attackersScore)).append("\n");
        sb.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        sb.append("    structureId: ").append(this.toIndentedString(this.structureId)).append("\n");
        sb.append("    defenderScore: ").append(this.toIndentedString(this.defenderScore)).append("\n");
        sb.append("    campaignId: ").append(this.toIndentedString(this.campaignId)).append("\n");
        sb.append("    constellationId: ").append(this.toIndentedString(this.constellationId)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventTypeEnum {
        TCU_DEFENSE("tcu_defense"),
        IHUB_DEFENSE("ihub_defense"),
        STATION_DEFENSE("station_defense"),
        STATION_FREEPORT("station_freeport");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EventTypeEnum> {
            public void write(JsonWriter jsonWriter, EventTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventTypeEnum.fromValue(value);
            }
        }
    }
}

