/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardActiveTotalVictoryPoints;
import net.troja.eve.esi.model.FactionWarfareLeaderboardLastWeekVictoryPoints;
import net.troja.eve.esi.model.FactionWarfareLeaderboardYesterdayVictoryPoints;

@ApiModel(description="Top 4 rankings of factions by victory points from yesterday, last week and in total")
public class FactionWarfareLeaderboardVictoryPoints
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_YESTERDAY = "yesterday";
    @SerializedName(value="yesterday")
    private List<FactionWarfareLeaderboardYesterdayVictoryPoints> yesterday = new ArrayList<FactionWarfareLeaderboardYesterdayVictoryPoints>();
    public static final String SERIALIZED_NAME_ACTIVE_TOTAL = "active_total";
    @SerializedName(value="active_total")
    private List<FactionWarfareLeaderboardActiveTotalVictoryPoints> activeTotal = new ArrayList<FactionWarfareLeaderboardActiveTotalVictoryPoints>();
    public static final String SERIALIZED_NAME_LAST_WEEK = "last_week";
    @SerializedName(value="last_week")
    private List<FactionWarfareLeaderboardLastWeekVictoryPoints> lastWeek = new ArrayList<FactionWarfareLeaderboardLastWeekVictoryPoints>();

    public FactionWarfareLeaderboardVictoryPoints yesterday(List<FactionWarfareLeaderboardYesterdayVictoryPoints> yesterday) {
        this.yesterday = yesterday;
        return this;
    }

    public FactionWarfareLeaderboardVictoryPoints addYesterdayItem(FactionWarfareLeaderboardYesterdayVictoryPoints yesterdayItem) {
        this.yesterday.add(yesterdayItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 4 ranking of factions by victory points in the past day")
    public List<FactionWarfareLeaderboardYesterdayVictoryPoints> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardYesterdayVictoryPoints> yesterday) {
        this.yesterday = yesterday;
    }

    public FactionWarfareLeaderboardVictoryPoints activeTotal(List<FactionWarfareLeaderboardActiveTotalVictoryPoints> activeTotal) {
        this.activeTotal = activeTotal;
        return this;
    }

    public FactionWarfareLeaderboardVictoryPoints addActiveTotalItem(FactionWarfareLeaderboardActiveTotalVictoryPoints activeTotalItem) {
        this.activeTotal.add(activeTotalItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 4 ranking of factions active in faction warfare by total victory points. A faction is considered \"active\" if they have participated in faction warfare in the past 14 days")
    public List<FactionWarfareLeaderboardActiveTotalVictoryPoints> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardActiveTotalVictoryPoints> activeTotal) {
        this.activeTotal = activeTotal;
    }

    public FactionWarfareLeaderboardVictoryPoints lastWeek(List<FactionWarfareLeaderboardLastWeekVictoryPoints> lastWeek) {
        this.lastWeek = lastWeek;
        return this;
    }

    public FactionWarfareLeaderboardVictoryPoints addLastWeekItem(FactionWarfareLeaderboardLastWeekVictoryPoints lastWeekItem) {
        this.lastWeek.add(lastWeekItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 4 ranking of factions by victory points in the past week")
    public List<FactionWarfareLeaderboardLastWeekVictoryPoints> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardLastWeekVictoryPoints> lastWeek) {
        this.lastWeek = lastWeek;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardVictoryPoints factionWarfareLeaderboardVictoryPoints = (FactionWarfareLeaderboardVictoryPoints)o;
        return Objects.equals(this.yesterday, factionWarfareLeaderboardVictoryPoints.yesterday) && Objects.equals(this.activeTotal, factionWarfareLeaderboardVictoryPoints.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardVictoryPoints.lastWeek);
    }

    public int hashCode() {
        return Objects.hash(this.yesterday, this.activeTotal, this.lastWeek);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FactionWarfareLeaderboardVictoryPoints {\n");
        sb.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        sb.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        sb.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

