/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationActiveTotalVictoryPoints;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationLastWeekVictoryPoints;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationYesterdayVictoryPoints;

@ApiModel(description="Top 10 rankings of corporations by victory points from yesterday, last week and in total")
public class FactionWarfareLeaderboardCorporationsVictoryPoints
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_YESTERDAY = "yesterday";
    @SerializedName(value="yesterday")
    private List<FactionWarfareLeaderboardCorporationYesterdayVictoryPoints> yesterday = new ArrayList<FactionWarfareLeaderboardCorporationYesterdayVictoryPoints>();
    public static final String SERIALIZED_NAME_ACTIVE_TOTAL = "active_total";
    @SerializedName(value="active_total")
    private List<FactionWarfareLeaderboardCorporationActiveTotalVictoryPoints> activeTotal = new ArrayList<FactionWarfareLeaderboardCorporationActiveTotalVictoryPoints>();
    public static final String SERIALIZED_NAME_LAST_WEEK = "last_week";
    @SerializedName(value="last_week")
    private List<FactionWarfareLeaderboardCorporationLastWeekVictoryPoints> lastWeek = new ArrayList<FactionWarfareLeaderboardCorporationLastWeekVictoryPoints>();

    public FactionWarfareLeaderboardCorporationsVictoryPoints yesterday(List<FactionWarfareLeaderboardCorporationYesterdayVictoryPoints> yesterday) {
        this.yesterday = yesterday;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsVictoryPoints addYesterdayItem(FactionWarfareLeaderboardCorporationYesterdayVictoryPoints yesterdayItem) {
        this.yesterday.add(yesterdayItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 10 ranking of corporations by victory points in the past day")
    public List<FactionWarfareLeaderboardCorporationYesterdayVictoryPoints> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardCorporationYesterdayVictoryPoints> yesterday) {
        this.yesterday = yesterday;
    }

    public FactionWarfareLeaderboardCorporationsVictoryPoints activeTotal(List<FactionWarfareLeaderboardCorporationActiveTotalVictoryPoints> activeTotal) {
        this.activeTotal = activeTotal;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsVictoryPoints addActiveTotalItem(FactionWarfareLeaderboardCorporationActiveTotalVictoryPoints activeTotalItem) {
        this.activeTotal.add(activeTotalItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 10 ranking of corporations active in faction warfare by total victory points. A corporation is considered \"active\" if they have participated in faction warfare in the past 14 days")
    public List<FactionWarfareLeaderboardCorporationActiveTotalVictoryPoints> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardCorporationActiveTotalVictoryPoints> activeTotal) {
        this.activeTotal = activeTotal;
    }

    public FactionWarfareLeaderboardCorporationsVictoryPoints lastWeek(List<FactionWarfareLeaderboardCorporationLastWeekVictoryPoints> lastWeek) {
        this.lastWeek = lastWeek;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsVictoryPoints addLastWeekItem(FactionWarfareLeaderboardCorporationLastWeekVictoryPoints lastWeekItem) {
        this.lastWeek.add(lastWeekItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 10 ranking of corporations by victory points in the past week")
    public List<FactionWarfareLeaderboardCorporationLastWeekVictoryPoints> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardCorporationLastWeekVictoryPoints> lastWeek) {
        this.lastWeek = lastWeek;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardCorporationsVictoryPoints factionWarfareLeaderboardCorporationsVictoryPoints = (FactionWarfareLeaderboardCorporationsVictoryPoints)o;
        return Objects.equals(this.yesterday, factionWarfareLeaderboardCorporationsVictoryPoints.yesterday) && Objects.equals(this.activeTotal, factionWarfareLeaderboardCorporationsVictoryPoints.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardCorporationsVictoryPoints.lastWeek);
    }

    public int hashCode() {
        return Objects.hash(this.yesterday, this.activeTotal, this.lastWeek);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FactionWarfareLeaderboardCorporationsVictoryPoints {\n");
        sb.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        sb.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        sb.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

