/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersActiveTotalKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersLastWeekKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersYesterdayKills;

@ApiModel(description="Top 100 rankings of pilots by number of kills from yesterday, last week and in total")
public class FactionWarfareLeaderboardCharacterKills
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_YESTERDAY = "yesterday";
    @SerializedName(value="yesterday")
    private List<FactionWarfareLeaderboardCharactersYesterdayKills> yesterday = new ArrayList<FactionWarfareLeaderboardCharactersYesterdayKills>();
    public static final String SERIALIZED_NAME_ACTIVE_TOTAL = "active_total";
    @SerializedName(value="active_total")
    private List<FactionWarfareLeaderboardCharactersActiveTotalKills> activeTotal = new ArrayList<FactionWarfareLeaderboardCharactersActiveTotalKills>();
    public static final String SERIALIZED_NAME_LAST_WEEK = "last_week";
    @SerializedName(value="last_week")
    private List<FactionWarfareLeaderboardCharactersLastWeekKills> lastWeek = new ArrayList<FactionWarfareLeaderboardCharactersLastWeekKills>();

    public FactionWarfareLeaderboardCharacterKills yesterday(List<FactionWarfareLeaderboardCharactersYesterdayKills> yesterday) {
        this.yesterday = yesterday;
        return this;
    }

    public FactionWarfareLeaderboardCharacterKills addYesterdayItem(FactionWarfareLeaderboardCharactersYesterdayKills yesterdayItem) {
        this.yesterday.add(yesterdayItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 100 ranking of pilots by kills in the past day")
    public List<FactionWarfareLeaderboardCharactersYesterdayKills> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardCharactersYesterdayKills> yesterday) {
        this.yesterday = yesterday;
    }

    public FactionWarfareLeaderboardCharacterKills activeTotal(List<FactionWarfareLeaderboardCharactersActiveTotalKills> activeTotal) {
        this.activeTotal = activeTotal;
        return this;
    }

    public FactionWarfareLeaderboardCharacterKills addActiveTotalItem(FactionWarfareLeaderboardCharactersActiveTotalKills activeTotalItem) {
        this.activeTotal.add(activeTotalItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 100 ranking of pilots active in faction warfare by total kills. A pilot is considered \"active\" if they have participated in faction warfare in the past 14 days")
    public List<FactionWarfareLeaderboardCharactersActiveTotalKills> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardCharactersActiveTotalKills> activeTotal) {
        this.activeTotal = activeTotal;
    }

    public FactionWarfareLeaderboardCharacterKills lastWeek(List<FactionWarfareLeaderboardCharactersLastWeekKills> lastWeek) {
        this.lastWeek = lastWeek;
        return this;
    }

    public FactionWarfareLeaderboardCharacterKills addLastWeekItem(FactionWarfareLeaderboardCharactersLastWeekKills lastWeekItem) {
        this.lastWeek.add(lastWeekItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 100 ranking of pilots by kills in the past week")
    public List<FactionWarfareLeaderboardCharactersLastWeekKills> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardCharactersLastWeekKills> lastWeek) {
        this.lastWeek = lastWeek;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardCharacterKills factionWarfareLeaderboardCharacterKills = (FactionWarfareLeaderboardCharacterKills)o;
        return Objects.equals(this.yesterday, factionWarfareLeaderboardCharacterKills.yesterday) && Objects.equals(this.activeTotal, factionWarfareLeaderboardCharacterKills.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardCharacterKills.lastWeek);
    }

    public int hashCode() {
        return Objects.hash(this.yesterday, this.activeTotal, this.lastWeek);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FactionWarfareLeaderboardCharacterKills {\n");
        sb.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        sb.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        sb.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

