/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterFleetResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private RoleEnum role;
    public static final String SERIALIZED_NAME_SQUAD_ID = "squad_id";
    @SerializedName(value="squad_id")
    private Long squadId;
    public static final String SERIALIZED_NAME_FLEET_ID = "fleet_id";
    @SerializedName(value="fleet_id")
    private Long fleetId;
    public static final String SERIALIZED_NAME_FLEET_BOSS_ID = "fleet_boss_id";
    @SerializedName(value="fleet_boss_id")
    private Long fleetBossId;
    public static final String SERIALIZED_NAME_WING_ID = "wing_id";
    @SerializedName(value="wing_id")
    private Long wingId;

    public CharacterFleetResponse role(RoleEnum role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(required=true, value="Member\u2019s role in fleet")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public CharacterFleetResponse squadId(Long squadId) {
        this.squadId = squadId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the squad the member is in. If not applicable, will be set to -1")
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(Long squadId) {
        this.squadId = squadId;
    }

    public CharacterFleetResponse fleetId(Long fleetId) {
        this.fleetId = fleetId;
        return this;
    }

    @ApiModelProperty(required=true, value="The character's current fleet ID")
    public Long getFleetId() {
        return this.fleetId;
    }

    public void setFleetId(Long fleetId) {
        this.fleetId = fleetId;
    }

    public CharacterFleetResponse fleetBossId(Long fleetBossId) {
        this.fleetBossId = fleetBossId;
        return this;
    }

    @ApiModelProperty(required=true, value="Character ID of the current fleet boss")
    public Long getFleetBossId() {
        return this.fleetBossId;
    }

    public void setFleetBossId(Long fleetBossId) {
        this.fleetBossId = fleetBossId;
    }

    public CharacterFleetResponse wingId(Long wingId) {
        this.wingId = wingId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the wing the member is in. If not applicable, will be set to -1")
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(Long wingId) {
        this.wingId = wingId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterFleetResponse characterFleetResponse = (CharacterFleetResponse)o;
        return Objects.equals((Object)this.role, (Object)characterFleetResponse.role) && Objects.equals(this.squadId, characterFleetResponse.squadId) && Objects.equals(this.fleetId, characterFleetResponse.fleetId) && Objects.equals(this.fleetBossId, characterFleetResponse.fleetBossId) && Objects.equals(this.wingId, characterFleetResponse.wingId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.squadId, this.fleetId, this.fleetBossId, this.wingId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterFleetResponse {\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        sb.append("    fleetId: ").append(this.toIndentedString(this.fleetId)).append("\n");
        sb.append("    fleetBossId: ").append(this.toIndentedString(this.fleetBossId)).append("\n");
        sb.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member"),
        WING_COMMANDER("wing_commander");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }
}

