/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class AllianceResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_TICKER = "ticker";
    @SerializedName(value="ticker")
    private String ticker;
    public static final String SERIALIZED_NAME_CREATOR_CORPORATION_ID = "creator_corporation_id";
    @SerializedName(value="creator_corporation_id")
    private Integer creatorCorporationId;
    public static final String SERIALIZED_NAME_CREATOR_ID = "creator_id";
    @SerializedName(value="creator_id")
    private Integer creatorId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    private Integer factionId;
    public static final String SERIALIZED_NAME_DATE_FOUNDED = "date_founded";
    @SerializedName(value="date_founded")
    private OffsetDateTime dateFounded;
    public static final String SERIALIZED_NAME_EXECUTOR_CORPORATION_ID = "executor_corporation_id";
    @SerializedName(value="executor_corporation_id")
    private Integer executorCorporationId;

    public AllianceResponse ticker(String ticker) {
        this.ticker = ticker;
        return this;
    }

    @ApiModelProperty(required=true, value="the short name of the alliance")
    public String getTicker() {
        return this.ticker;
    }

    public void setTicker(String ticker) {
        this.ticker = ticker;
    }

    public AllianceResponse creatorCorporationId(Integer creatorCorporationId) {
        this.creatorCorporationId = creatorCorporationId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the corporation that created the alliance")
    public Integer getCreatorCorporationId() {
        return this.creatorCorporationId;
    }

    public void setCreatorCorporationId(Integer creatorCorporationId) {
        this.creatorCorporationId = creatorCorporationId;
    }

    public AllianceResponse creatorId(Integer creatorId) {
        this.creatorId = creatorId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the character that created the alliance")
    public Integer getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Integer creatorId) {
        this.creatorId = creatorId;
    }

    public AllianceResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="the full name of the alliance")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AllianceResponse factionId(Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    @ApiModelProperty(value="Faction ID this alliance is fighting for, if this alliance is enlisted in factional warfare")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public AllianceResponse dateFounded(OffsetDateTime dateFounded) {
        this.dateFounded = dateFounded;
        return this;
    }

    @ApiModelProperty(required=true, value="date_founded string")
    public OffsetDateTime getDateFounded() {
        return this.dateFounded;
    }

    public void setDateFounded(OffsetDateTime dateFounded) {
        this.dateFounded = dateFounded;
    }

    public AllianceResponse executorCorporationId(Integer executorCorporationId) {
        this.executorCorporationId = executorCorporationId;
        return this;
    }

    @ApiModelProperty(value="the executor corporation ID, if this alliance is not closed")
    public Integer getExecutorCorporationId() {
        return this.executorCorporationId;
    }

    public void setExecutorCorporationId(Integer executorCorporationId) {
        this.executorCorporationId = executorCorporationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllianceResponse allianceResponse = (AllianceResponse)o;
        return Objects.equals(this.ticker, allianceResponse.ticker) && Objects.equals(this.creatorCorporationId, allianceResponse.creatorCorporationId) && Objects.equals(this.creatorId, allianceResponse.creatorId) && Objects.equals(this.name, allianceResponse.name) && Objects.equals(this.factionId, allianceResponse.factionId) && Objects.equals(this.dateFounded, allianceResponse.dateFounded) && Objects.equals(this.executorCorporationId, allianceResponse.executorCorporationId);
    }

    public int hashCode() {
        return Objects.hash(this.ticker, this.creatorCorporationId, this.creatorId, this.name, this.factionId, this.dateFounded, this.executorCorporationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AllianceResponse {\n");
        sb.append("    ticker: ").append(this.toIndentedString(this.ticker)).append("\n");
        sb.append("    creatorCorporationId: ").append(this.toIndentedString(this.creatorCorporationId)).append("\n");
        sb.append("    creatorId: ").append(this.toIndentedString(this.creatorId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        sb.append("    dateFounded: ").append(this.toIndentedString(this.dateFounded)).append("\n");
        sb.append("    executorCorporationId: ").append(this.toIndentedString(this.executorCorporationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

