/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The aggressor corporation or alliance that declared this war, only contains either corporation_id or alliance_id")
public class Aggressor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALLIANCE_ID = "alliance_id";
    @SerializedName(value="alliance_id")
    private Integer allianceId;
    public static final String SERIALIZED_NAME_CORPORATION_ID = "corporation_id";
    @SerializedName(value="corporation_id")
    private Integer corporationId;
    public static final String SERIALIZED_NAME_ISK_DESTROYED = "isk_destroyed";
    @SerializedName(value="isk_destroyed")
    private Float iskDestroyed;
    public static final String SERIALIZED_NAME_SHIPS_KILLED = "ships_killed";
    @SerializedName(value="ships_killed")
    private Integer shipsKilled;

    public Aggressor allianceId(Integer allianceId) {
        this.allianceId = allianceId;
        return this;
    }

    @ApiModelProperty(value="Alliance ID if and only if the aggressor is an alliance")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer allianceId) {
        this.allianceId = allianceId;
    }

    public Aggressor corporationId(Integer corporationId) {
        this.corporationId = corporationId;
        return this;
    }

    @ApiModelProperty(value="Corporation ID if and only if the aggressor is a corporation")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer corporationId) {
        this.corporationId = corporationId;
    }

    public Aggressor iskDestroyed(Float iskDestroyed) {
        this.iskDestroyed = iskDestroyed;
        return this;
    }

    @ApiModelProperty(required=true, value="ISK value of ships the aggressor has destroyed")
    public Float getIskDestroyed() {
        return this.iskDestroyed;
    }

    public void setIskDestroyed(Float iskDestroyed) {
        this.iskDestroyed = iskDestroyed;
    }

    public Aggressor shipsKilled(Integer shipsKilled) {
        this.shipsKilled = shipsKilled;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of ships the aggressor has killed")
    public Integer getShipsKilled() {
        return this.shipsKilled;
    }

    public void setShipsKilled(Integer shipsKilled) {
        this.shipsKilled = shipsKilled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Aggressor aggressor = (Aggressor)o;
        return Objects.equals(this.allianceId, aggressor.allianceId) && Objects.equals(this.corporationId, aggressor.corporationId) && Objects.equals(this.iskDestroyed, aggressor.iskDestroyed) && Objects.equals(this.shipsKilled, aggressor.shipsKilled);
    }

    public int hashCode() {
        return Objects.hash(this.allianceId, this.corporationId, this.iskDestroyed, this.shipsKilled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Aggressor {\n");
        sb.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        sb.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        sb.append("    iskDestroyed: ").append(this.toIndentedString(this.iskDestroyed)).append("\n");
        sb.append("    shipsKilled: ").append(this.toIndentedString(this.shipsKilled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

