/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 0.8.9
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CharacterFleetResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * Member’s role in fleet
     */
    @JsonAdapter(RoleEnum.Adapter.class)
    public enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),

        SQUAD_COMMANDER("squad_commander"),

        SQUAD_MEMBER("squad_member"),

        WING_COMMANDER("wing_commander");

        private String value;

        RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter extends TypeAdapter<RoleEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public RoleEnum read(final JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(SERIALIZED_NAME_ROLE)
    private RoleEnum role;

    public static final String SERIALIZED_NAME_SQUAD_ID = "squad_id";
    @SerializedName(SERIALIZED_NAME_SQUAD_ID)
    private Long squadId;

    public static final String SERIALIZED_NAME_FLEET_ID = "fleet_id";
    @SerializedName(SERIALIZED_NAME_FLEET_ID)
    private Long fleetId;

    public static final String SERIALIZED_NAME_FLEET_BOSS_ID = "fleet_boss_id";
    @SerializedName(SERIALIZED_NAME_FLEET_BOSS_ID)
    private Long fleetBossId;

    public static final String SERIALIZED_NAME_WING_ID = "wing_id";
    @SerializedName(SERIALIZED_NAME_WING_ID)
    private Long wingId;

    public CharacterFleetResponse role(RoleEnum role) {
        this.role = role;
        return this;
    }

    /**
     * Member’s role in fleet
     * 
     * @return role
     **/
    @ApiModelProperty(required = true, value = "Member’s role in fleet")
    public RoleEnum getRole() {
        return role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public CharacterFleetResponse squadId(Long squadId) {
        this.squadId = squadId;
        return this;
    }

    /**
     * ID of the squad the member is in. If not applicable, will be set to -1
     * 
     * @return squadId
     **/
    @ApiModelProperty(required = true, value = "ID of the squad the member is in. If not applicable, will be set to -1")
    public Long getSquadId() {
        return squadId;
    }

    public void setSquadId(Long squadId) {
        this.squadId = squadId;
    }

    public CharacterFleetResponse fleetId(Long fleetId) {
        this.fleetId = fleetId;
        return this;
    }

    /**
     * The character&#39;s current fleet ID
     * 
     * @return fleetId
     **/
    @ApiModelProperty(required = true, value = "The character's current fleet ID")
    public Long getFleetId() {
        return fleetId;
    }

    public void setFleetId(Long fleetId) {
        this.fleetId = fleetId;
    }

    public CharacterFleetResponse fleetBossId(Long fleetBossId) {
        this.fleetBossId = fleetBossId;
        return this;
    }

    /**
     * Character ID of the current fleet boss
     * 
     * @return fleetBossId
     **/
    @ApiModelProperty(required = true, value = "Character ID of the current fleet boss")
    public Long getFleetBossId() {
        return fleetBossId;
    }

    public void setFleetBossId(Long fleetBossId) {
        this.fleetBossId = fleetBossId;
    }

    public CharacterFleetResponse wingId(Long wingId) {
        this.wingId = wingId;
        return this;
    }

    /**
     * ID of the wing the member is in. If not applicable, will be set to -1
     * 
     * @return wingId
     **/
    @ApiModelProperty(required = true, value = "ID of the wing the member is in. If not applicable, will be set to -1")
    public Long getWingId() {
        return wingId;
    }

    public void setWingId(Long wingId) {
        this.wingId = wingId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CharacterFleetResponse characterFleetResponse = (CharacterFleetResponse) o;
        return Objects.equals(this.role, characterFleetResponse.role)
                && Objects.equals(this.squadId, characterFleetResponse.squadId)
                && Objects.equals(this.fleetId, characterFleetResponse.fleetId)
                && Objects.equals(this.fleetBossId, characterFleetResponse.fleetBossId)
                && Objects.equals(this.wingId, characterFleetResponse.wingId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(role, squadId, fleetId, fleetBossId, wingId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterFleetResponse {\n");
        sb.append("    role: ").append(toIndentedString(role)).append("\n");
        sb.append("    squadId: ").append(toIndentedString(squadId)).append("\n");
        sb.append("    fleetId: ").append(toIndentedString(fleetId)).append("\n");
        sb.append("    fleetBossId: ").append(toIndentedString(fleetBossId)).append("\n");
        sb.append("    wingId: ").append(toIndentedString(wingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
