/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.SovereigntyCampaignParticipant;

@ApiModel(description="200 ok object")
public class SovereigntyCampaignsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "event_type";
    @SerializedName(value="event_type")
    private EventTypeEnum eventType;
    public static final String SERIALIZED_NAME_DEFENDER_ID = "defender_id";
    @SerializedName(value="defender_id")
    private Integer defenderId;
    public static final String SERIALIZED_NAME_ATTACKERS_SCORE = "attackers_score";
    @SerializedName(value="attackers_score")
    private Float attackersScore;
    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(value="solar_system_id")
    private Integer solarSystemId;
    public static final String SERIALIZED_NAME_STRUCTURE_ID = "structure_id";
    @SerializedName(value="structure_id")
    private Long structureId;
    public static final String SERIALIZED_NAME_DEFENDER_SCORE = "defender_score";
    @SerializedName(value="defender_score")
    private Float defenderScore;
    public static final String SERIALIZED_NAME_CAMPAIGN_ID = "campaign_id";
    @SerializedName(value="campaign_id")
    private Integer campaignId;
    public static final String SERIALIZED_NAME_CONSTELLATION_ID = "constellation_id";
    @SerializedName(value="constellation_id")
    private Integer constellationId;
    public static final String SERIALIZED_NAME_PARTICIPANTS = "participants";
    @SerializedName(value="participants")
    private List<SovereigntyCampaignParticipant> participants = new ArrayList<SovereigntyCampaignParticipant>();

    public SovereigntyCampaignsResponse startTime(OffsetDateTime offsetDateTime) {
        this.startTime = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Time the event is scheduled to start. ")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime offsetDateTime) {
        this.startTime = offsetDateTime;
    }

    public SovereigntyCampaignsResponse eventType(EventTypeEnum eventTypeEnum) {
        this.eventType = eventTypeEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of event this campaign is for. tcu_defense, ihub_defense and station_defense are referred to as \"Defense Events\", station_freeport as \"Freeport Events\". ")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventTypeEnum) {
        this.eventType = eventTypeEnum;
    }

    public SovereigntyCampaignsResponse defenderId(Integer n) {
        this.defenderId = n;
        return this;
    }

    @ApiModelProperty(value="Defending alliance, only present in Defense Events ")
    public Integer getDefenderId() {
        return this.defenderId;
    }

    public void setDefenderId(Integer n) {
        this.defenderId = n;
    }

    public SovereigntyCampaignsResponse attackersScore(Float f) {
        this.attackersScore = f;
        return this;
    }

    @ApiModelProperty(value="Score for all attacking parties, only present in Defense Events. ")
    public Float getAttackersScore() {
        return this.attackersScore;
    }

    public void setAttackersScore(Float f) {
        this.attackersScore = f;
    }

    public SovereigntyCampaignsResponse solarSystemId(Integer n) {
        this.solarSystemId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The solar system the structure is located in. ")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer n) {
        this.solarSystemId = n;
    }

    public SovereigntyCampaignsResponse structureId(Long l) {
        this.structureId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="The structure item ID that is related to this campaign. ")
    public Long getStructureId() {
        return this.structureId;
    }

    public void setStructureId(Long l) {
        this.structureId = l;
    }

    public SovereigntyCampaignsResponse defenderScore(Float f) {
        this.defenderScore = f;
        return this;
    }

    @ApiModelProperty(value="Score for the defending alliance, only present in Defense Events. ")
    public Float getDefenderScore() {
        return this.defenderScore;
    }

    public void setDefenderScore(Float f) {
        this.defenderScore = f;
    }

    public SovereigntyCampaignsResponse campaignId(Integer n) {
        this.campaignId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique ID for this campaign.")
    public Integer getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Integer n) {
        this.campaignId = n;
    }

    public SovereigntyCampaignsResponse constellationId(Integer n) {
        this.constellationId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The constellation in which the campaign will take place. ")
    public Integer getConstellationId() {
        return this.constellationId;
    }

    public void setConstellationId(Integer n) {
        this.constellationId = n;
    }

    public SovereigntyCampaignsResponse participants(List<SovereigntyCampaignParticipant> list) {
        this.participants = list;
        return this;
    }

    public SovereigntyCampaignsResponse addParticipantsItem(SovereigntyCampaignParticipant sovereigntyCampaignParticipant) {
        if (this.participants == null) {
            this.participants = new ArrayList<SovereigntyCampaignParticipant>();
        }
        this.participants.add(sovereigntyCampaignParticipant);
        return this;
    }

    @ApiModelProperty(value="Alliance participating and their respective scores, only present in Freeport Events. ")
    public List<SovereigntyCampaignParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<SovereigntyCampaignParticipant> list) {
        this.participants = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SovereigntyCampaignsResponse sovereigntyCampaignsResponse = (SovereigntyCampaignsResponse)object;
        return Objects.equals(this.startTime, sovereigntyCampaignsResponse.startTime) && Objects.equals((Object)this.eventType, (Object)sovereigntyCampaignsResponse.eventType) && Objects.equals(this.defenderId, sovereigntyCampaignsResponse.defenderId) && Objects.equals(this.attackersScore, sovereigntyCampaignsResponse.attackersScore) && Objects.equals(this.solarSystemId, sovereigntyCampaignsResponse.solarSystemId) && Objects.equals(this.structureId, sovereigntyCampaignsResponse.structureId) && Objects.equals(this.defenderScore, sovereigntyCampaignsResponse.defenderScore) && Objects.equals(this.campaignId, sovereigntyCampaignsResponse.campaignId) && Objects.equals(this.constellationId, sovereigntyCampaignsResponse.constellationId) && Objects.equals(this.participants, sovereigntyCampaignsResponse.participants);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startTime, this.eventType, this.defenderId, this.attackersScore, this.solarSystemId, this.structureId, this.defenderScore, this.campaignId, this.constellationId, this.participants});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class SovereigntyCampaignsResponse {\n");
        stringBuilder.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        stringBuilder.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        stringBuilder.append("    defenderId: ").append(this.toIndentedString(this.defenderId)).append("\n");
        stringBuilder.append("    attackersScore: ").append(this.toIndentedString(this.attackersScore)).append("\n");
        stringBuilder.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        stringBuilder.append("    structureId: ").append(this.toIndentedString(this.structureId)).append("\n");
        stringBuilder.append("    defenderScore: ").append(this.toIndentedString(this.defenderScore)).append("\n");
        stringBuilder.append("    campaignId: ").append(this.toIndentedString(this.campaignId)).append("\n");
        stringBuilder.append("    constellationId: ").append(this.toIndentedString(this.constellationId)).append("\n");
        stringBuilder.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventTypeEnum {
        TCU_DEFENSE("tcu_defense"),
        IHUB_DEFENSE("ihub_defense"),
        STATION_DEFENSE("station_defense"),
        STATION_FREEPORT("station_freeport");

        private String value;

        private EventTypeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventTypeEnum fromValue(String string) {
            for (EventTypeEnum eventTypeEnum : EventTypeEnum.values()) {
                if (!eventTypeEnum.value.equals(string)) continue;
                return eventTypeEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<EventTypeEnum> {
            public void write(JsonWriter jsonWriter, EventTypeEnum eventTypeEnum) throws IOException {
                jsonWriter.value(eventTypeEnum.getValue());
            }

            public EventTypeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return EventTypeEnum.fromValue(string);
            }
        }
    }
}

