/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="recipient object")
public class Recipient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    private Integer recipientId;
    public static final String SERIALIZED_NAME_RECIPIENT_TYPE = "recipient_type";
    @SerializedName(value="recipient_type")
    private RecipientTypeEnum recipientType;

    public Recipient recipientId(Integer n) {
        this.recipientId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="recipient_id integer")
    public Integer getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(Integer n) {
        this.recipientId = n;
    }

    public Recipient recipientType(RecipientTypeEnum recipientTypeEnum) {
        this.recipientType = recipientTypeEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="recipient_type string")
    public RecipientTypeEnum getRecipientType() {
        return this.recipientType;
    }

    public void setRecipientType(RecipientTypeEnum recipientTypeEnum) {
        this.recipientType = recipientTypeEnum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Recipient recipient = (Recipient)object;
        return Objects.equals(this.recipientId, recipient.recipientId) && Objects.equals((Object)this.recipientType, (Object)recipient.recipientType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recipientId, this.recipientType});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class Recipient {\n");
        stringBuilder.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        stringBuilder.append("    recipientType: ").append(this.toIndentedString((Object)this.recipientType)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecipientTypeEnum {
        ALLIANCE("alliance"),
        CHARACTER("character"),
        CORPORATION("corporation"),
        MAILING_LIST("mailing_list");

        private String value;

        private RecipientTypeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecipientTypeEnum fromValue(String string) {
            for (RecipientTypeEnum recipientTypeEnum : RecipientTypeEnum.values()) {
                if (!recipientTypeEnum.value.equals(string)) continue;
                return recipientTypeEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecipientTypeEnum> {
            public void write(JsonWriter jsonWriter, RecipientTypeEnum recipientTypeEnum) throws IOException {
                jsonWriter.value(recipientTypeEnum.getValue());
            }

            public RecipientTypeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return RecipientTypeEnum.fromValue(string);
            }
        }
    }
}

