/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Per route status")
public class EsiStatusResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ENDPOINT = "endpoint";
    @SerializedName(value="endpoint")
    private String endpoint;
    public static final String SERIALIZED_NAME_ROUTE = "route";
    @SerializedName(value="route")
    private String route;
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    private String method;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();

    public EsiStatusResponse endpoint(String string) {
        this.endpoint = string;
        return this;
    }

    @ApiModelProperty(required=true, value="ESI Endpoint cluster advertising this route")
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String string) {
        this.endpoint = string;
    }

    public EsiStatusResponse route(String string) {
        this.route = string;
        return this;
    }

    @ApiModelProperty(required=true, value="Swagger defined route, not including version prefix")
    public String getRoute() {
        return this.route;
    }

    public void setRoute(String string) {
        this.route = string;
    }

    public EsiStatusResponse method(String string) {
        this.method = string;
        return this;
    }

    @ApiModelProperty(required=true, value="Swagger defined method")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public EsiStatusResponse status(StatusEnum statusEnum) {
        this.status = statusEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="Vague route status. Green is good, yellow is degraded, meaning slow or potentially dropping requests. Red means most requests are not succeeding and/or are very slow (5s+) on average.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum statusEnum) {
        this.status = statusEnum;
    }

    public EsiStatusResponse tags(List<String> list) {
        this.tags = list;
        return this;
    }

    public EsiStatusResponse addTagsItem(String string) {
        this.tags.add(string);
        return this;
    }

    @ApiModelProperty(required=true, value="Swagger tags applicable to this route")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> list) {
        this.tags = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EsiStatusResponse esiStatusResponse = (EsiStatusResponse)object;
        return Objects.equals(this.endpoint, esiStatusResponse.endpoint) && Objects.equals(this.route, esiStatusResponse.route) && Objects.equals(this.method, esiStatusResponse.method) && Objects.equals((Object)this.status, (Object)esiStatusResponse.status) && Objects.equals(this.tags, esiStatusResponse.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endpoint, this.route, this.method, this.status, this.tags});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class EsiStatusResponse {\n");
        stringBuilder.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        stringBuilder.append("    route: ").append(this.toIndentedString(this.route)).append("\n");
        stringBuilder.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        stringBuilder.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        stringBuilder.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        GREEN("green"),
        YELLOW("yellow"),
        RED("red");

        private String value;

        private StatusEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String string) {
            for (StatusEnum statusEnum : StatusEnum.values()) {
                if (!statusEnum.value.equals(string)) continue;
                return statusEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum statusEnum) throws IOException {
                jsonWriter.value(statusEnum.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return StatusEnum.fromValue(string);
            }
        }
    }
}

