/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.StructureService;

@ApiModel(description="200 ok object")
public class CorporationStructuresResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CORPORATION_ID = "corporation_id";
    @SerializedName(value="corporation_id")
    private Integer corporationId;
    public static final String SERIALIZED_NAME_SYSTEM_ID = "system_id";
    @SerializedName(value="system_id")
    private Integer systemId;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_FUEL_EXPIRES = "fuel_expires";
    @SerializedName(value="fuel_expires")
    private OffsetDateTime fuelExpires;
    public static final String SERIALIZED_NAME_REINFORCE_HOUR = "reinforce_hour";
    @SerializedName(value="reinforce_hour")
    private Integer reinforceHour;
    public static final String SERIALIZED_NAME_STRUCTURE_ID = "structure_id";
    @SerializedName(value="structure_id")
    private Long structureId;
    public static final String SERIALIZED_NAME_SERVICES = "services";
    @SerializedName(value="services")
    private List<StructureService> services = new ArrayList<StructureService>();
    public static final String SERIALIZED_NAME_STATE_TIMER_END = "state_timer_end";
    @SerializedName(value="state_timer_end")
    private OffsetDateTime stateTimerEnd;
    public static final String SERIALIZED_NAME_STATE_TIMER_START = "state_timer_start";
    @SerializedName(value="state_timer_start")
    private OffsetDateTime stateTimerStart;
    public static final String SERIALIZED_NAME_PROFILE_ID = "profile_id";
    @SerializedName(value="profile_id")
    private Integer profileId;
    public static final String SERIALIZED_NAME_NEXT_REINFORCE_WEEKDAY = "next_reinforce_weekday";
    @SerializedName(value="next_reinforce_weekday")
    private Integer nextReinforceWeekday;
    public static final String SERIALIZED_NAME_REINFORCE_WEEKDAY = "reinforce_weekday";
    @SerializedName(value="reinforce_weekday")
    private Integer reinforceWeekday;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_UNANCHORS_AT = "unanchors_at";
    @SerializedName(value="unanchors_at")
    private OffsetDateTime unanchorsAt;
    public static final String SERIALIZED_NAME_NEXT_REINFORCE_APPLY = "next_reinforce_apply";
    @SerializedName(value="next_reinforce_apply")
    private OffsetDateTime nextReinforceApply;
    public static final String SERIALIZED_NAME_NEXT_REINFORCE_HOUR = "next_reinforce_hour";
    @SerializedName(value="next_reinforce_hour")
    private Integer nextReinforceHour;

    public CorporationStructuresResponse corporationId(Integer n) {
        this.corporationId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the corporation that owns the structure")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer n) {
        this.corporationId = n;
    }

    public CorporationStructuresResponse systemId(Integer n) {
        this.systemId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The solar system the structure is in")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer n) {
        this.systemId = n;
    }

    public CorporationStructuresResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The type id of the structure")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CorporationStructuresResponse fuelExpires(OffsetDateTime offsetDateTime) {
        this.fuelExpires = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="Date on which the structure will run out of fuel")
    public OffsetDateTime getFuelExpires() {
        return this.fuelExpires;
    }

    public void setFuelExpires(OffsetDateTime offsetDateTime) {
        this.fuelExpires = offsetDateTime;
    }

    public CorporationStructuresResponse reinforceHour(Integer n) {
        this.reinforceHour = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The hour of day that determines the four hour window when the structure will randomly exit its reinforcement periods and become vulnerable to attack against its armor and/or hull. The structure will become vulnerable at a random time that is +/- 2 hours centered on the value of this property")
    public Integer getReinforceHour() {
        return this.reinforceHour;
    }

    public void setReinforceHour(Integer n) {
        this.reinforceHour = n;
    }

    public CorporationStructuresResponse structureId(Long l) {
        this.structureId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="The Item ID of the structure")
    public Long getStructureId() {
        return this.structureId;
    }

    public void setStructureId(Long l) {
        this.structureId = l;
    }

    public CorporationStructuresResponse services(List<StructureService> list) {
        this.services = list;
        return this;
    }

    public CorporationStructuresResponse addServicesItem(StructureService structureService) {
        if (this.services == null) {
            this.services = new ArrayList<StructureService>();
        }
        this.services.add(structureService);
        return this;
    }

    @ApiModelProperty(value="Contains a list of service upgrades, and their state")
    public List<StructureService> getServices() {
        return this.services;
    }

    public void setServices(List<StructureService> list) {
        this.services = list;
    }

    public CorporationStructuresResponse stateTimerEnd(OffsetDateTime offsetDateTime) {
        this.stateTimerEnd = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="Date at which the structure will move to it's next state")
    public OffsetDateTime getStateTimerEnd() {
        return this.stateTimerEnd;
    }

    public void setStateTimerEnd(OffsetDateTime offsetDateTime) {
        this.stateTimerEnd = offsetDateTime;
    }

    public CorporationStructuresResponse stateTimerStart(OffsetDateTime offsetDateTime) {
        this.stateTimerStart = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="Date at which the structure entered it's current state")
    public OffsetDateTime getStateTimerStart() {
        return this.stateTimerStart;
    }

    public void setStateTimerStart(OffsetDateTime offsetDateTime) {
        this.stateTimerStart = offsetDateTime;
    }

    public CorporationStructuresResponse profileId(Integer n) {
        this.profileId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the ACL profile for this citadel")
    public Integer getProfileId() {
        return this.profileId;
    }

    public void setProfileId(Integer n) {
        this.profileId = n;
    }

    public CorporationStructuresResponse nextReinforceWeekday(Integer n) {
        this.nextReinforceWeekday = n;
        return this;
    }

    @ApiModelProperty(value="The requested change to reinforce_weekday that will take effect at the time shown by next_reinforce_apply")
    public Integer getNextReinforceWeekday() {
        return this.nextReinforceWeekday;
    }

    public void setNextReinforceWeekday(Integer n) {
        this.nextReinforceWeekday = n;
    }

    public CorporationStructuresResponse reinforceWeekday(Integer n) {
        this.reinforceWeekday = n;
        return this;
    }

    @ApiModelProperty(value="The day of the week when the structure exits its final reinforcement period and becomes vulnerable to attack against its hull. Monday is 0 and Sunday is 6")
    public Integer getReinforceWeekday() {
        return this.reinforceWeekday;
    }

    public void setReinforceWeekday(Integer n) {
        this.reinforceWeekday = n;
    }

    public CorporationStructuresResponse state(StateEnum stateEnum) {
        this.state = stateEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="state string")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.state = stateEnum;
    }

    public CorporationStructuresResponse unanchorsAt(OffsetDateTime offsetDateTime) {
        this.unanchorsAt = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="Date at which the structure will unanchor")
    public OffsetDateTime getUnanchorsAt() {
        return this.unanchorsAt;
    }

    public void setUnanchorsAt(OffsetDateTime offsetDateTime) {
        this.unanchorsAt = offsetDateTime;
    }

    public CorporationStructuresResponse nextReinforceApply(OffsetDateTime offsetDateTime) {
        this.nextReinforceApply = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="The date and time when the structure's newly requested reinforcement times (e.g. next_reinforce_hour and next_reinforce_day) will take effect")
    public OffsetDateTime getNextReinforceApply() {
        return this.nextReinforceApply;
    }

    public void setNextReinforceApply(OffsetDateTime offsetDateTime) {
        this.nextReinforceApply = offsetDateTime;
    }

    public CorporationStructuresResponse nextReinforceHour(Integer n) {
        this.nextReinforceHour = n;
        return this;
    }

    @ApiModelProperty(value="The requested change to reinforce_hour that will take effect at the time shown by next_reinforce_apply")
    public Integer getNextReinforceHour() {
        return this.nextReinforceHour;
    }

    public void setNextReinforceHour(Integer n) {
        this.nextReinforceHour = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationStructuresResponse corporationStructuresResponse = (CorporationStructuresResponse)object;
        return Objects.equals(this.corporationId, corporationStructuresResponse.corporationId) && Objects.equals(this.systemId, corporationStructuresResponse.systemId) && Objects.equals(this.typeId, corporationStructuresResponse.typeId) && Objects.equals(this.fuelExpires, corporationStructuresResponse.fuelExpires) && Objects.equals(this.reinforceHour, corporationStructuresResponse.reinforceHour) && Objects.equals(this.structureId, corporationStructuresResponse.structureId) && Objects.equals(this.services, corporationStructuresResponse.services) && Objects.equals(this.stateTimerEnd, corporationStructuresResponse.stateTimerEnd) && Objects.equals(this.stateTimerStart, corporationStructuresResponse.stateTimerStart) && Objects.equals(this.profileId, corporationStructuresResponse.profileId) && Objects.equals(this.nextReinforceWeekday, corporationStructuresResponse.nextReinforceWeekday) && Objects.equals(this.reinforceWeekday, corporationStructuresResponse.reinforceWeekday) && Objects.equals((Object)this.state, (Object)corporationStructuresResponse.state) && Objects.equals(this.unanchorsAt, corporationStructuresResponse.unanchorsAt) && Objects.equals(this.nextReinforceApply, corporationStructuresResponse.nextReinforceApply) && Objects.equals(this.nextReinforceHour, corporationStructuresResponse.nextReinforceHour);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.corporationId, this.systemId, this.typeId, this.fuelExpires, this.reinforceHour, this.structureId, this.services, this.stateTimerEnd, this.stateTimerStart, this.profileId, this.nextReinforceWeekday, this.reinforceWeekday, this.state, this.unanchorsAt, this.nextReinforceApply, this.nextReinforceHour});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationStructuresResponse {\n");
        stringBuilder.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        stringBuilder.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    fuelExpires: ").append(this.toIndentedString(this.fuelExpires)).append("\n");
        stringBuilder.append("    reinforceHour: ").append(this.toIndentedString(this.reinforceHour)).append("\n");
        stringBuilder.append("    structureId: ").append(this.toIndentedString(this.structureId)).append("\n");
        stringBuilder.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        stringBuilder.append("    stateTimerEnd: ").append(this.toIndentedString(this.stateTimerEnd)).append("\n");
        stringBuilder.append("    stateTimerStart: ").append(this.toIndentedString(this.stateTimerStart)).append("\n");
        stringBuilder.append("    profileId: ").append(this.toIndentedString(this.profileId)).append("\n");
        stringBuilder.append("    nextReinforceWeekday: ").append(this.toIndentedString(this.nextReinforceWeekday)).append("\n");
        stringBuilder.append("    reinforceWeekday: ").append(this.toIndentedString(this.reinforceWeekday)).append("\n");
        stringBuilder.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        stringBuilder.append("    unanchorsAt: ").append(this.toIndentedString(this.unanchorsAt)).append("\n");
        stringBuilder.append("    nextReinforceApply: ").append(this.toIndentedString(this.nextReinforceApply)).append("\n");
        stringBuilder.append("    nextReinforceHour: ").append(this.toIndentedString(this.nextReinforceHour)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ANCHOR_VULNERABLE("anchor_vulnerable"),
        ANCHORING("anchoring"),
        ARMOR_REINFORCE("armor_reinforce"),
        ARMOR_VULNERABLE("armor_vulnerable"),
        DEPLOY_VULNERABLE("deploy_vulnerable"),
        FITTING_INVULNERABLE("fitting_invulnerable"),
        HULL_REINFORCE("hull_reinforce"),
        HULL_VULNERABLE("hull_vulnerable"),
        ONLINE_DEPRECATED("online_deprecated"),
        ONLINING_VULNERABLE("onlining_vulnerable"),
        SHIELD_VULNERABLE("shield_vulnerable"),
        UNANCHORED("unanchored"),
        UNKNOWN("unknown");

        private String value;

        private StateEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String string) {
            for (StateEnum stateEnum : StateEnum.values()) {
                if (!stateEnum.value.equals(string)) continue;
                return stateEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum stateEnum) throws IOException {
                jsonWriter.value(stateEnum.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return StateEnum.fromValue(string);
            }
        }
    }
}

