/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CorporationOrdersHistoryResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ISSUED_BY = "issued_by";
    @SerializedName(value="issued_by")
    private Integer issuedBy;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_REGION_ID = "region_id";
    @SerializedName(value="region_id")
    private Integer regionId;
    public static final String SERIALIZED_NAME_RANGE = "range";
    @SerializedName(value="range")
    private RangeEnum range;
    public static final String SERIALIZED_NAME_VOLUME_TOTAL = "volume_total";
    @SerializedName(value="volume_total")
    private Integer volumeTotal;
    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(value="location_id")
    private Long locationId;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private Integer duration;
    public static final String SERIALIZED_NAME_MIN_VOLUME = "min_volume";
    @SerializedName(value="min_volume")
    private Integer minVolume;
    public static final String SERIALIZED_NAME_IS_BUY_ORDER = "is_buy_order";
    @SerializedName(value="is_buy_order")
    private Boolean isBuyOrder;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private Double price;
    public static final String SERIALIZED_NAME_WALLET_DIVISION = "wallet_division";
    @SerializedName(value="wallet_division")
    private Integer walletDivision;
    public static final String SERIALIZED_NAME_ESCROW = "escrow";
    @SerializedName(value="escrow")
    private Double escrow;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_ISSUED = "issued";
    @SerializedName(value="issued")
    private OffsetDateTime issued;
    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(value="order_id")
    private Long orderId;
    public static final String SERIALIZED_NAME_VOLUME_REMAIN = "volume_remain";
    @SerializedName(value="volume_remain")
    private Integer volumeRemain;

    public CorporationOrdersHistoryResponse issuedBy(Integer n) {
        this.issuedBy = n;
        return this;
    }

    @ApiModelProperty(value="The character who issued this order")
    public Integer getIssuedBy() {
        return this.issuedBy;
    }

    public void setIssuedBy(Integer n) {
        this.issuedBy = n;
    }

    public CorporationOrdersHistoryResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The type ID of the item transacted in this order")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CorporationOrdersHistoryResponse regionId(Integer n) {
        this.regionId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the region where order was placed")
    public Integer getRegionId() {
        return this.regionId;
    }

    public void setRegionId(Integer n) {
        this.regionId = n;
    }

    public CorporationOrdersHistoryResponse range(RangeEnum rangeEnum) {
        this.range = rangeEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="Valid order range, numbers are ranges in jumps")
    public RangeEnum getRange() {
        return this.range;
    }

    public void setRange(RangeEnum rangeEnum) {
        this.range = rangeEnum;
    }

    public CorporationOrdersHistoryResponse volumeTotal(Integer n) {
        this.volumeTotal = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity of items required or offered at time order was placed")
    public Integer getVolumeTotal() {
        return this.volumeTotal;
    }

    public void setVolumeTotal(Integer n) {
        this.volumeTotal = n;
    }

    public CorporationOrdersHistoryResponse locationId(Long l) {
        this.locationId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the location where order was placed")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long l) {
        this.locationId = l;
    }

    public CorporationOrdersHistoryResponse duration(Integer n) {
        this.duration = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of days the order was valid for (starting from the issued date). An order expires at time issued + duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer n) {
        this.duration = n;
    }

    public CorporationOrdersHistoryResponse minVolume(Integer n) {
        this.minVolume = n;
        return this;
    }

    @ApiModelProperty(value="For buy orders, the minimum quantity that will be accepted in a matching sell order")
    public Integer getMinVolume() {
        return this.minVolume;
    }

    public void setMinVolume(Integer n) {
        this.minVolume = n;
    }

    public CorporationOrdersHistoryResponse isBuyOrder(Boolean bl) {
        this.isBuyOrder = bl;
        return this;
    }

    @ApiModelProperty(value="True if the order is a bid (buy) order")
    public Boolean getIsBuyOrder() {
        return this.isBuyOrder;
    }

    public void setIsBuyOrder(Boolean bl) {
        this.isBuyOrder = bl;
    }

    public CorporationOrdersHistoryResponse price(Double d) {
        this.price = d;
        return this;
    }

    @ApiModelProperty(required=true, value="Cost per unit for this order")
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double d) {
        this.price = d;
    }

    public CorporationOrdersHistoryResponse walletDivision(Integer n) {
        this.walletDivision = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The corporation wallet division used for this order")
    public Integer getWalletDivision() {
        return this.walletDivision;
    }

    public void setWalletDivision(Integer n) {
        this.walletDivision = n;
    }

    public CorporationOrdersHistoryResponse escrow(Double d) {
        this.escrow = d;
        return this;
    }

    @ApiModelProperty(value="For buy orders, the amount of ISK in escrow")
    public Double getEscrow() {
        return this.escrow;
    }

    public void setEscrow(Double d) {
        this.escrow = d;
    }

    public CorporationOrdersHistoryResponse state(StateEnum stateEnum) {
        this.state = stateEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="Current order state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.state = stateEnum;
    }

    public CorporationOrdersHistoryResponse issued(OffsetDateTime offsetDateTime) {
        this.issued = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time when this order was issued")
    public OffsetDateTime getIssued() {
        return this.issued;
    }

    public void setIssued(OffsetDateTime offsetDateTime) {
        this.issued = offsetDateTime;
    }

    public CorporationOrdersHistoryResponse orderId(Long l) {
        this.orderId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique order ID")
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long l) {
        this.orderId = l;
    }

    public CorporationOrdersHistoryResponse volumeRemain(Integer n) {
        this.volumeRemain = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity of items still required or offered")
    public Integer getVolumeRemain() {
        return this.volumeRemain;
    }

    public void setVolumeRemain(Integer n) {
        this.volumeRemain = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationOrdersHistoryResponse corporationOrdersHistoryResponse = (CorporationOrdersHistoryResponse)object;
        return Objects.equals(this.issuedBy, corporationOrdersHistoryResponse.issuedBy) && Objects.equals(this.typeId, corporationOrdersHistoryResponse.typeId) && Objects.equals(this.regionId, corporationOrdersHistoryResponse.regionId) && Objects.equals((Object)this.range, (Object)corporationOrdersHistoryResponse.range) && Objects.equals(this.volumeTotal, corporationOrdersHistoryResponse.volumeTotal) && Objects.equals(this.locationId, corporationOrdersHistoryResponse.locationId) && Objects.equals(this.duration, corporationOrdersHistoryResponse.duration) && Objects.equals(this.minVolume, corporationOrdersHistoryResponse.minVolume) && Objects.equals(this.isBuyOrder, corporationOrdersHistoryResponse.isBuyOrder) && Objects.equals(this.price, corporationOrdersHistoryResponse.price) && Objects.equals(this.walletDivision, corporationOrdersHistoryResponse.walletDivision) && Objects.equals(this.escrow, corporationOrdersHistoryResponse.escrow) && Objects.equals((Object)this.state, (Object)corporationOrdersHistoryResponse.state) && Objects.equals(this.issued, corporationOrdersHistoryResponse.issued) && Objects.equals(this.orderId, corporationOrdersHistoryResponse.orderId) && Objects.equals(this.volumeRemain, corporationOrdersHistoryResponse.volumeRemain);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.issuedBy, this.typeId, this.regionId, this.range, this.volumeTotal, this.locationId, this.duration, this.minVolume, this.isBuyOrder, this.price, this.walletDivision, this.escrow, this.state, this.issued, this.orderId, this.volumeRemain});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationOrdersHistoryResponse {\n");
        stringBuilder.append("    issuedBy: ").append(this.toIndentedString(this.issuedBy)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    regionId: ").append(this.toIndentedString(this.regionId)).append("\n");
        stringBuilder.append("    range: ").append(this.toIndentedString((Object)this.range)).append("\n");
        stringBuilder.append("    volumeTotal: ").append(this.toIndentedString(this.volumeTotal)).append("\n");
        stringBuilder.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        stringBuilder.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        stringBuilder.append("    minVolume: ").append(this.toIndentedString(this.minVolume)).append("\n");
        stringBuilder.append("    isBuyOrder: ").append(this.toIndentedString(this.isBuyOrder)).append("\n");
        stringBuilder.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        stringBuilder.append("    walletDivision: ").append(this.toIndentedString(this.walletDivision)).append("\n");
        stringBuilder.append("    escrow: ").append(this.toIndentedString(this.escrow)).append("\n");
        stringBuilder.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        stringBuilder.append("    issued: ").append(this.toIndentedString(this.issued)).append("\n");
        stringBuilder.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        stringBuilder.append("    volumeRemain: ").append(this.toIndentedString(this.volumeRemain)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        CANCELLED("cancelled"),
        EXPIRED("expired");

        private String value;

        private StateEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String string) {
            for (StateEnum stateEnum : StateEnum.values()) {
                if (!stateEnum.value.equals(string)) continue;
                return stateEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum stateEnum) throws IOException {
                jsonWriter.value(stateEnum.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return StateEnum.fromValue(string);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RangeEnum {
        _1("1"),
        _10("10"),
        _2("2"),
        _20("20"),
        _3("3"),
        _30("30"),
        _4("4"),
        _40("40"),
        _5("5"),
        REGION("region"),
        SOLARSYSTEM("solarsystem"),
        STATION("station");

        private String value;

        private RangeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RangeEnum fromValue(String string) {
            for (RangeEnum rangeEnum : RangeEnum.values()) {
                if (!rangeEnum.value.equals(string)) continue;
                return rangeEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<RangeEnum> {
            public void write(JsonWriter jsonWriter, RangeEnum rangeEnum) throws IOException {
                jsonWriter.value(rangeEnum.getValue());
            }

            public RangeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return RangeEnum.fromValue(string);
            }
        }
    }
}

