/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterWalletJournalResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private OffsetDateTime date;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_CONTEXT_ID_TYPE = "context_id_type";
    @SerializedName(value="context_id_type")
    private ContextIdTypeEnum contextIdType;
    public static final String SERIALIZED_NAME_FIRST_PARTY_ID = "first_party_id";
    @SerializedName(value="first_party_id")
    private Integer firstPartyId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TAX = "tax";
    @SerializedName(value="tax")
    private Double tax;
    public static final String SERIALIZED_NAME_TAX_RECEIVER_ID = "tax_receiver_id";
    @SerializedName(value="tax_receiver_id")
    private Integer taxReceiverId;
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private Double balance;
    public static final String SERIALIZED_NAME_CONTEXT_ID = "context_id";
    @SerializedName(value="context_id")
    private Long contextId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Long id;
    public static final String SERIALIZED_NAME_REF_TYPE = "ref_type";
    @SerializedName(value="ref_type")
    private RefTypeEnum refType;
    public static final String SERIALIZED_NAME_SECOND_PARTY_ID = "second_party_id";
    @SerializedName(value="second_party_id")
    private Integer secondPartyId;

    public CharacterWalletJournalResponse date(OffsetDateTime offsetDateTime) {
        this.date = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time of transaction")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime offsetDateTime) {
        this.date = offsetDateTime;
    }

    public CharacterWalletJournalResponse reason(String string) {
        this.reason = string;
        return this;
    }

    @ApiModelProperty(value="The user stated reason for the transaction. Only applies to some ref_types")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public CharacterWalletJournalResponse amount(Double d) {
        this.amount = d;
        return this;
    }

    @ApiModelProperty(value="The amount of ISK given or taken from the wallet as a result of the given transaction. Positive when ISK is deposited into the wallet and negative when ISK is withdrawn")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double d) {
        this.amount = d;
    }

    public CharacterWalletJournalResponse contextIdType(ContextIdTypeEnum contextIdTypeEnum) {
        this.contextIdType = contextIdTypeEnum;
        return this;
    }

    @ApiModelProperty(value="The type of the given context_id if present")
    public ContextIdTypeEnum getContextIdType() {
        return this.contextIdType;
    }

    public void setContextIdType(ContextIdTypeEnum contextIdTypeEnum) {
        this.contextIdType = contextIdTypeEnum;
    }

    public CharacterWalletJournalResponse firstPartyId(Integer n) {
        this.firstPartyId = n;
        return this;
    }

    @ApiModelProperty(value="The id of the first party involved in the transaction. This attribute has no consistency and is different or non existant for particular ref_types. The description attribute will help make sense of what this attribute means. For more info about the given ID it can be dropped into the /universe/names/ ESI route to determine its type and name")
    public Integer getFirstPartyId() {
        return this.firstPartyId;
    }

    public void setFirstPartyId(Integer n) {
        this.firstPartyId = n;
    }

    public CharacterWalletJournalResponse description(String string) {
        this.description = string;
        return this;
    }

    @ApiModelProperty(required=true, value="The reason for the transaction, mirrors what is seen in the client")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public CharacterWalletJournalResponse tax(Double d) {
        this.tax = d;
        return this;
    }

    @ApiModelProperty(value="Tax amount received. Only applies to tax related transactions")
    public Double getTax() {
        return this.tax;
    }

    public void setTax(Double d) {
        this.tax = d;
    }

    public CharacterWalletJournalResponse taxReceiverId(Integer n) {
        this.taxReceiverId = n;
        return this;
    }

    @ApiModelProperty(value="The corporation ID receiving any tax paid. Only applies to tax related transactions")
    public Integer getTaxReceiverId() {
        return this.taxReceiverId;
    }

    public void setTaxReceiverId(Integer n) {
        this.taxReceiverId = n;
    }

    public CharacterWalletJournalResponse balance(Double d) {
        this.balance = d;
        return this;
    }

    @ApiModelProperty(value="Wallet balance after transaction occurred")
    public Double getBalance() {
        return this.balance;
    }

    public void setBalance(Double d) {
        this.balance = d;
    }

    public CharacterWalletJournalResponse contextId(Long l) {
        this.contextId = l;
        return this;
    }

    @ApiModelProperty(value="An ID that gives extra context to the particular transaction. Because of legacy reasons the context is completely different per ref_type and means different things. It is also possible to not have a context_id")
    public Long getContextId() {
        return this.contextId;
    }

    public void setContextId(Long l) {
        this.contextId = l;
    }

    public CharacterWalletJournalResponse id(Long l) {
        this.id = l;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique journal reference ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public CharacterWalletJournalResponse refType(RefTypeEnum refTypeEnum) {
        this.refType = refTypeEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="\"The transaction type for the given. transaction. Different transaction types will populate different attributes.\"")
    public RefTypeEnum getRefType() {
        return this.refType;
    }

    public void setRefType(RefTypeEnum refTypeEnum) {
        this.refType = refTypeEnum;
    }

    public CharacterWalletJournalResponse secondPartyId(Integer n) {
        this.secondPartyId = n;
        return this;
    }

    @ApiModelProperty(value="The id of the second party involved in the transaction. This attribute has no consistency and is different or non existant for particular ref_types. The description attribute will help make sense of what this attribute means. For more info about the given ID it can be dropped into the /universe/names/ ESI route to determine its type and name")
    public Integer getSecondPartyId() {
        return this.secondPartyId;
    }

    public void setSecondPartyId(Integer n) {
        this.secondPartyId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterWalletJournalResponse characterWalletJournalResponse = (CharacterWalletJournalResponse)object;
        return Objects.equals(this.date, characterWalletJournalResponse.date) && Objects.equals(this.reason, characterWalletJournalResponse.reason) && Objects.equals(this.amount, characterWalletJournalResponse.amount) && Objects.equals((Object)this.contextIdType, (Object)characterWalletJournalResponse.contextIdType) && Objects.equals(this.firstPartyId, characterWalletJournalResponse.firstPartyId) && Objects.equals(this.description, characterWalletJournalResponse.description) && Objects.equals(this.tax, characterWalletJournalResponse.tax) && Objects.equals(this.taxReceiverId, characterWalletJournalResponse.taxReceiverId) && Objects.equals(this.balance, characterWalletJournalResponse.balance) && Objects.equals(this.contextId, characterWalletJournalResponse.contextId) && Objects.equals(this.id, characterWalletJournalResponse.id) && Objects.equals((Object)this.refType, (Object)characterWalletJournalResponse.refType) && Objects.equals(this.secondPartyId, characterWalletJournalResponse.secondPartyId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.date, this.reason, this.amount, this.contextIdType, this.firstPartyId, this.description, this.tax, this.taxReceiverId, this.balance, this.contextId, this.id, this.refType, this.secondPartyId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterWalletJournalResponse {\n");
        stringBuilder.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        stringBuilder.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        stringBuilder.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        stringBuilder.append("    contextIdType: ").append(this.toIndentedString((Object)this.contextIdType)).append("\n");
        stringBuilder.append("    firstPartyId: ").append(this.toIndentedString(this.firstPartyId)).append("\n");
        stringBuilder.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        stringBuilder.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        stringBuilder.append("    taxReceiverId: ").append(this.toIndentedString(this.taxReceiverId)).append("\n");
        stringBuilder.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        stringBuilder.append("    contextId: ").append(this.toIndentedString(this.contextId)).append("\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    refType: ").append(this.toIndentedString((Object)this.refType)).append("\n");
        stringBuilder.append("    secondPartyId: ").append(this.toIndentedString(this.secondPartyId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RefTypeEnum {
        ACCELERATION_GATE_FEE("acceleration_gate_fee"),
        ADVERTISEMENT_LISTING_FEE("advertisement_listing_fee"),
        AGENT_DONATION("agent_donation"),
        AGENT_LOCATION_SERVICES("agent_location_services"),
        AGENT_MISCELLANEOUS("agent_miscellaneous"),
        AGENT_MISSION_COLLATERAL_PAID("agent_mission_collateral_paid"),
        AGENT_MISSION_COLLATERAL_REFUNDED("agent_mission_collateral_refunded"),
        AGENT_MISSION_REWARD("agent_mission_reward"),
        AGENT_MISSION_REWARD_CORPORATION_TAX("agent_mission_reward_corporation_tax"),
        AGENT_MISSION_TIME_BONUS_REWARD("agent_mission_time_bonus_reward"),
        AGENT_MISSION_TIME_BONUS_REWARD_CORPORATION_TAX("agent_mission_time_bonus_reward_corporation_tax"),
        AGENT_SECURITY_SERVICES("agent_security_services"),
        AGENT_SERVICES_RENDERED("agent_services_rendered"),
        AGENTS_PREWARD("agents_preward"),
        ALLIANCE_MAINTAINANCE_FEE("alliance_maintainance_fee"),
        ALLIANCE_REGISTRATION_FEE("alliance_registration_fee"),
        ASSET_SAFETY_RECOVERY_TAX("asset_safety_recovery_tax"),
        BOUNTY("bounty"),
        BOUNTY_PRIZE("bounty_prize"),
        BOUNTY_PRIZE_CORPORATION_TAX("bounty_prize_corporation_tax"),
        BOUNTY_PRIZES("bounty_prizes"),
        BOUNTY_REIMBURSEMENT("bounty_reimbursement"),
        BOUNTY_SURCHARGE("bounty_surcharge"),
        BROKERS_FEE("brokers_fee"),
        CLONE_ACTIVATION("clone_activation"),
        CLONE_TRANSFER("clone_transfer"),
        CONTRABAND_FINE("contraband_fine"),
        CONTRACT_AUCTION_BID("contract_auction_bid"),
        CONTRACT_AUCTION_BID_CORP("contract_auction_bid_corp"),
        CONTRACT_AUCTION_BID_REFUND("contract_auction_bid_refund"),
        CONTRACT_AUCTION_SOLD("contract_auction_sold"),
        CONTRACT_BROKERS_FEE("contract_brokers_fee"),
        CONTRACT_BROKERS_FEE_CORP("contract_brokers_fee_corp"),
        CONTRACT_COLLATERAL("contract_collateral"),
        CONTRACT_COLLATERAL_DEPOSITED_CORP("contract_collateral_deposited_corp"),
        CONTRACT_COLLATERAL_PAYOUT("contract_collateral_payout"),
        CONTRACT_COLLATERAL_REFUND("contract_collateral_refund"),
        CONTRACT_DEPOSIT("contract_deposit"),
        CONTRACT_DEPOSIT_CORP("contract_deposit_corp"),
        CONTRACT_DEPOSIT_REFUND("contract_deposit_refund"),
        CONTRACT_DEPOSIT_SALES_TAX("contract_deposit_sales_tax"),
        CONTRACT_PRICE("contract_price"),
        CONTRACT_PRICE_PAYMENT_CORP("contract_price_payment_corp"),
        CONTRACT_REVERSAL("contract_reversal"),
        CONTRACT_REWARD("contract_reward"),
        CONTRACT_REWARD_DEPOSITED("contract_reward_deposited"),
        CONTRACT_REWARD_DEPOSITED_CORP("contract_reward_deposited_corp"),
        CONTRACT_REWARD_REFUND("contract_reward_refund"),
        CONTRACT_SALES_TAX("contract_sales_tax"),
        COPYING("copying"),
        CORPORATE_REWARD_PAYOUT("corporate_reward_payout"),
        CORPORATE_REWARD_TAX("corporate_reward_tax"),
        CORPORATION_ACCOUNT_WITHDRAWAL("corporation_account_withdrawal"),
        CORPORATION_BULK_PAYMENT("corporation_bulk_payment"),
        CORPORATION_DIVIDEND_PAYMENT("corporation_dividend_payment"),
        CORPORATION_LIQUIDATION("corporation_liquidation"),
        CORPORATION_LOGO_CHANGE_COST("corporation_logo_change_cost"),
        CORPORATION_PAYMENT("corporation_payment"),
        CORPORATION_REGISTRATION_FEE("corporation_registration_fee"),
        COURIER_MISSION_ESCROW("courier_mission_escrow"),
        CSPA("cspa"),
        CSPAOFFLINEREFUND("cspaofflinerefund"),
        DATACORE_FEE("datacore_fee"),
        DNA_MODIFICATION_FEE("dna_modification_fee"),
        DOCKING_FEE("docking_fee"),
        DUEL_WAGER_ESCROW("duel_wager_escrow"),
        DUEL_WAGER_PAYMENT("duel_wager_payment"),
        DUEL_WAGER_REFUND("duel_wager_refund"),
        FACTORY_SLOT_RENTAL_FEE("factory_slot_rental_fee"),
        GM_CASH_TRANSFER("gm_cash_transfer"),
        INDUSTRY_JOB_TAX("industry_job_tax"),
        INFRASTRUCTURE_HUB_MAINTENANCE("infrastructure_hub_maintenance"),
        INHERITANCE("inheritance"),
        INSURANCE("insurance"),
        ITEM_TRADER_PAYMENT("item_trader_payment"),
        JUMP_CLONE_ACTIVATION_FEE("jump_clone_activation_fee"),
        JUMP_CLONE_INSTALLATION_FEE("jump_clone_installation_fee"),
        KILL_RIGHT_FEE("kill_right_fee"),
        LP_STORE("lp_store"),
        MANUFACTURING("manufacturing"),
        MARKET_ESCROW("market_escrow"),
        MARKET_FINE_PAID("market_fine_paid"),
        MARKET_TRANSACTION("market_transaction"),
        MEDAL_CREATION("medal_creation"),
        MEDAL_ISSUED("medal_issued"),
        MISSION_COMPLETION("mission_completion"),
        MISSION_COST("mission_cost"),
        MISSION_EXPIRATION("mission_expiration"),
        MISSION_REWARD("mission_reward"),
        OFFICE_RENTAL_FEE("office_rental_fee"),
        OPERATION_BONUS("operation_bonus"),
        OPPORTUNITY_REWARD("opportunity_reward"),
        PLANETARY_CONSTRUCTION("planetary_construction"),
        PLANETARY_EXPORT_TAX("planetary_export_tax"),
        PLANETARY_IMPORT_TAX("planetary_import_tax"),
        PLAYER_DONATION("player_donation"),
        PLAYER_TRADING("player_trading"),
        PROJECT_DISCOVERY_REWARD("project_discovery_reward"),
        PROJECT_DISCOVERY_TAX("project_discovery_tax"),
        REACTION("reaction"),
        RELEASE_OF_IMPOUNDED_PROPERTY("release_of_impounded_property"),
        REPAIR_BILL("repair_bill"),
        REPROCESSING_TAX("reprocessing_tax"),
        RESEARCHING_MATERIAL_PRODUCTIVITY("researching_material_productivity"),
        RESEARCHING_TECHNOLOGY("researching_technology"),
        RESEARCHING_TIME_PRODUCTIVITY("researching_time_productivity"),
        RESOURCE_WARS_REWARD("resource_wars_reward"),
        REVERSE_ENGINEERING("reverse_engineering"),
        SECURITY_PROCESSING_FEE("security_processing_fee"),
        SHARES("shares"),
        SKILL_PURCHASE("skill_purchase"),
        SOVEREIGNITY_BILL("sovereignity_bill"),
        STORE_PURCHASE("store_purchase"),
        STORE_PURCHASE_REFUND("store_purchase_refund"),
        STRUCTURE_GATE_JUMP("structure_gate_jump"),
        TRANSACTION_TAX("transaction_tax"),
        UPKEEP_ADJUSTMENT_FEE("upkeep_adjustment_fee"),
        WAR_ALLY_CONTRACT("war_ally_contract"),
        WAR_FEE("war_fee"),
        WAR_FEE_SURRENDER("war_fee_surrender");

        private String value;

        private RefTypeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RefTypeEnum fromValue(String string) {
            for (RefTypeEnum refTypeEnum : RefTypeEnum.values()) {
                if (!refTypeEnum.value.equals(string)) continue;
                return refTypeEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<RefTypeEnum> {
            public void write(JsonWriter jsonWriter, RefTypeEnum refTypeEnum) throws IOException {
                jsonWriter.value(refTypeEnum.getValue());
            }

            public RefTypeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return RefTypeEnum.fromValue(string);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContextIdTypeEnum {
        STRUCTURE_ID("structure_id"),
        STATION_ID("station_id"),
        MARKET_TRANSACTION_ID("market_transaction_id"),
        CHARACTER_ID("character_id"),
        CORPORATION_ID("corporation_id"),
        ALLIANCE_ID("alliance_id"),
        EVE_SYSTEM("eve_system"),
        INDUSTRY_JOB_ID("industry_job_id"),
        CONTRACT_ID("contract_id"),
        PLANET_ID("planet_id"),
        SYSTEM_ID("system_id"),
        TYPE_ID("type_id");

        private String value;

        private ContextIdTypeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContextIdTypeEnum fromValue(String string) {
            for (ContextIdTypeEnum contextIdTypeEnum : ContextIdTypeEnum.values()) {
                if (!contextIdTypeEnum.value.equals(string)) continue;
                return contextIdTypeEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<ContextIdTypeEnum> {
            public void write(JsonWriter jsonWriter, ContextIdTypeEnum contextIdTypeEnum) throws IOException {
                jsonWriter.value(contextIdTypeEnum.getValue());
            }

            public ContextIdTypeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return ContextIdTypeEnum.fromValue(string);
            }
        }
    }
}

