/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterFleetResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private RoleEnum role;
    public static final String SERIALIZED_NAME_SQUAD_ID = "squad_id";
    @SerializedName(value="squad_id")
    private Long squadId;
    public static final String SERIALIZED_NAME_FLEET_ID = "fleet_id";
    @SerializedName(value="fleet_id")
    private Long fleetId;
    public static final String SERIALIZED_NAME_FLEET_BOSS_ID = "fleet_boss_id";
    @SerializedName(value="fleet_boss_id")
    private Long fleetBossId;
    public static final String SERIALIZED_NAME_WING_ID = "wing_id";
    @SerializedName(value="wing_id")
    private Long wingId;

    public CharacterFleetResponse role(RoleEnum roleEnum) {
        this.role = roleEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="Member\u2019s role in fleet")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum roleEnum) {
        this.role = roleEnum;
    }

    public CharacterFleetResponse squadId(Long l) {
        this.squadId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the squad the member is in. If not applicable, will be set to -1")
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(Long l) {
        this.squadId = l;
    }

    public CharacterFleetResponse fleetId(Long l) {
        this.fleetId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="The character's current fleet ID")
    public Long getFleetId() {
        return this.fleetId;
    }

    public void setFleetId(Long l) {
        this.fleetId = l;
    }

    public CharacterFleetResponse fleetBossId(Long l) {
        this.fleetBossId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="Character ID of the current fleet boss")
    public Long getFleetBossId() {
        return this.fleetBossId;
    }

    public void setFleetBossId(Long l) {
        this.fleetBossId = l;
    }

    public CharacterFleetResponse wingId(Long l) {
        this.wingId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the wing the member is in. If not applicable, will be set to -1")
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(Long l) {
        this.wingId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterFleetResponse characterFleetResponse = (CharacterFleetResponse)object;
        return Objects.equals((Object)this.role, (Object)characterFleetResponse.role) && Objects.equals(this.squadId, characterFleetResponse.squadId) && Objects.equals(this.fleetId, characterFleetResponse.fleetId) && Objects.equals(this.fleetBossId, characterFleetResponse.fleetBossId) && Objects.equals(this.wingId, characterFleetResponse.wingId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.squadId, this.fleetId, this.fleetBossId, this.wingId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterFleetResponse {\n");
        stringBuilder.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        stringBuilder.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        stringBuilder.append("    fleetId: ").append(this.toIndentedString(this.fleetId)).append("\n");
        stringBuilder.append("    fleetBossId: ").append(this.toIndentedString(this.fleetBossId)).append("\n");
        stringBuilder.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member"),
        WING_COMMANDER("wing_commander");

        private String value;

        private RoleEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String string) {
            for (RoleEnum roleEnum : RoleEnum.values()) {
                if (!roleEnum.value.equals(string)) continue;
                return roleEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum roleEnum) throws IOException {
                jsonWriter.value(roleEnum.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return RoleEnum.fromValue(string);
            }
        }
    }
}

