/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterBlueprintsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Integer quantity;
    public static final String SERIALIZED_NAME_MATERIAL_EFFICIENCY = "material_efficiency";
    @SerializedName(value="material_efficiency")
    private Integer materialEfficiency;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private Long itemId;
    public static final String SERIALIZED_NAME_LOCATION_FLAG = "location_flag";
    @SerializedName(value="location_flag")
    private LocationFlagEnum locationFlag;
    public static final String SERIALIZED_NAME_TIME_EFFICIENCY = "time_efficiency";
    @SerializedName(value="time_efficiency")
    private Integer timeEfficiency;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_RUNS = "runs";
    @SerializedName(value="runs")
    private Integer runs;
    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(value="location_id")
    private Long locationId;

    public CharacterBlueprintsResponse quantity(Integer n) {
        this.quantity = n;
        return this;
    }

    @ApiModelProperty(required=true, value="A range of numbers with a minimum of -2 and no maximum value where -1 is an original and -2 is a copy. It can be a positive integer if it is a stack of blueprint originals fresh from the market (e.g. no activities performed on them yet).")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer n) {
        this.quantity = n;
    }

    public CharacterBlueprintsResponse materialEfficiency(Integer n) {
        this.materialEfficiency = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Material Efficiency Level of the blueprint.")
    public Integer getMaterialEfficiency() {
        return this.materialEfficiency;
    }

    public void setMaterialEfficiency(Integer n) {
        this.materialEfficiency = n;
    }

    public CharacterBlueprintsResponse itemId(Long l) {
        this.itemId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique ID for this item.")
    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long l) {
        this.itemId = l;
    }

    public CharacterBlueprintsResponse locationFlag(LocationFlagEnum locationFlagEnum) {
        this.locationFlag = locationFlagEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of the location_id")
    public LocationFlagEnum getLocationFlag() {
        return this.locationFlag;
    }

    public void setLocationFlag(LocationFlagEnum locationFlagEnum) {
        this.locationFlag = locationFlagEnum;
    }

    public CharacterBlueprintsResponse timeEfficiency(Integer n) {
        this.timeEfficiency = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Time Efficiency Level of the blueprint.")
    public Integer getTimeEfficiency() {
        return this.timeEfficiency;
    }

    public void setTimeEfficiency(Integer n) {
        this.timeEfficiency = n;
    }

    public CharacterBlueprintsResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="type_id integer")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CharacterBlueprintsResponse runs(Integer n) {
        this.runs = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of runs remaining if the blueprint is a copy, -1 if it is an original.")
    public Integer getRuns() {
        return this.runs;
    }

    public void setRuns(Integer n) {
        this.runs = n;
    }

    public CharacterBlueprintsResponse locationId(Long l) {
        this.locationId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="References a solar system, station or item_id if this blueprint is located within a container. If the return value is an item_id, then the Character AssetList API must be queried to find the container using the given item_id to determine the correct location of the Blueprint.")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long l) {
        this.locationId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterBlueprintsResponse characterBlueprintsResponse = (CharacterBlueprintsResponse)object;
        return Objects.equals(this.quantity, characterBlueprintsResponse.quantity) && Objects.equals(this.materialEfficiency, characterBlueprintsResponse.materialEfficiency) && Objects.equals(this.itemId, characterBlueprintsResponse.itemId) && Objects.equals((Object)this.locationFlag, (Object)characterBlueprintsResponse.locationFlag) && Objects.equals(this.timeEfficiency, characterBlueprintsResponse.timeEfficiency) && Objects.equals(this.typeId, characterBlueprintsResponse.typeId) && Objects.equals(this.runs, characterBlueprintsResponse.runs) && Objects.equals(this.locationId, characterBlueprintsResponse.locationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quantity, this.materialEfficiency, this.itemId, this.locationFlag, this.timeEfficiency, this.typeId, this.runs, this.locationId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterBlueprintsResponse {\n");
        stringBuilder.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        stringBuilder.append("    materialEfficiency: ").append(this.toIndentedString(this.materialEfficiency)).append("\n");
        stringBuilder.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        stringBuilder.append("    locationFlag: ").append(this.toIndentedString((Object)this.locationFlag)).append("\n");
        stringBuilder.append("    timeEfficiency: ").append(this.toIndentedString(this.timeEfficiency)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    runs: ").append(this.toIndentedString(this.runs)).append("\n");
        stringBuilder.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LocationFlagEnum {
        AUTOFIT("AutoFit"),
        CARGO("Cargo"),
        CORPSEBAY("CorpseBay"),
        DRONEBAY("DroneBay"),
        FLEETHANGAR("FleetHangar"),
        DELIVERIES("Deliveries"),
        HIDDENMODIFIERS("HiddenModifiers"),
        HANGAR("Hangar"),
        HANGARALL("HangarAll"),
        LOSLOT0("LoSlot0"),
        LOSLOT1("LoSlot1"),
        LOSLOT2("LoSlot2"),
        LOSLOT3("LoSlot3"),
        LOSLOT4("LoSlot4"),
        LOSLOT5("LoSlot5"),
        LOSLOT6("LoSlot6"),
        LOSLOT7("LoSlot7"),
        MEDSLOT0("MedSlot0"),
        MEDSLOT1("MedSlot1"),
        MEDSLOT2("MedSlot2"),
        MEDSLOT3("MedSlot3"),
        MEDSLOT4("MedSlot4"),
        MEDSLOT5("MedSlot5"),
        MEDSLOT6("MedSlot6"),
        MEDSLOT7("MedSlot7"),
        HISLOT0("HiSlot0"),
        HISLOT1("HiSlot1"),
        HISLOT2("HiSlot2"),
        HISLOT3("HiSlot3"),
        HISLOT4("HiSlot4"),
        HISLOT5("HiSlot5"),
        HISLOT6("HiSlot6"),
        HISLOT7("HiSlot7"),
        ASSETSAFETY("AssetSafety"),
        LOCKED("Locked"),
        UNLOCKED("Unlocked"),
        IMPLANT("Implant"),
        QUAFEBAY("QuafeBay"),
        RIGSLOT0("RigSlot0"),
        RIGSLOT1("RigSlot1"),
        RIGSLOT2("RigSlot2"),
        RIGSLOT3("RigSlot3"),
        RIGSLOT4("RigSlot4"),
        RIGSLOT5("RigSlot5"),
        RIGSLOT6("RigSlot6"),
        RIGSLOT7("RigSlot7"),
        SHIPHANGAR("ShipHangar"),
        SPECIALIZEDFUELBAY("SpecializedFuelBay"),
        SPECIALIZEDOREHOLD("SpecializedOreHold"),
        SPECIALIZEDGASHOLD("SpecializedGasHold"),
        SPECIALIZEDMINERALHOLD("SpecializedMineralHold"),
        SPECIALIZEDSALVAGEHOLD("SpecializedSalvageHold"),
        SPECIALIZEDSHIPHOLD("SpecializedShipHold"),
        SPECIALIZEDSMALLSHIPHOLD("SpecializedSmallShipHold"),
        SPECIALIZEDMEDIUMSHIPHOLD("SpecializedMediumShipHold"),
        SPECIALIZEDLARGESHIPHOLD("SpecializedLargeShipHold"),
        SPECIALIZEDINDUSTRIALSHIPHOLD("SpecializedIndustrialShipHold"),
        SPECIALIZEDAMMOHOLD("SpecializedAmmoHold"),
        SPECIALIZEDCOMMANDCENTERHOLD("SpecializedCommandCenterHold"),
        SPECIALIZEDPLANETARYCOMMODITIESHOLD("SpecializedPlanetaryCommoditiesHold"),
        SPECIALIZEDMATERIALBAY("SpecializedMaterialBay"),
        SUBSYSTEMSLOT0("SubSystemSlot0"),
        SUBSYSTEMSLOT1("SubSystemSlot1"),
        SUBSYSTEMSLOT2("SubSystemSlot2"),
        SUBSYSTEMSLOT3("SubSystemSlot3"),
        SUBSYSTEMSLOT4("SubSystemSlot4"),
        SUBSYSTEMSLOT5("SubSystemSlot5"),
        SUBSYSTEMSLOT6("SubSystemSlot6"),
        SUBSYSTEMSLOT7("SubSystemSlot7"),
        FIGHTERBAY("FighterBay"),
        FIGHTERTUBE0("FighterTube0"),
        FIGHTERTUBE1("FighterTube1"),
        FIGHTERTUBE2("FighterTube2"),
        FIGHTERTUBE3("FighterTube3"),
        FIGHTERTUBE4("FighterTube4"),
        MODULE("Module");

        private String value;

        private LocationFlagEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LocationFlagEnum fromValue(String string) {
            for (LocationFlagEnum locationFlagEnum : LocationFlagEnum.values()) {
                if (!locationFlagEnum.value.equals(string)) continue;
                return locationFlagEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<LocationFlagEnum> {
            public void write(JsonWriter jsonWriter, LocationFlagEnum locationFlagEnum) throws IOException {
                jsonWriter.value(locationFlagEnum.getValue());
            }

            public LocationFlagEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return LocationFlagEnum.fromValue(string);
            }
        }
    }
}

