/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.auth;

import java.util.List;
import java.util.Map;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.auth.Authentication;

public class HttpBearerAuth
implements Authentication {
    private final String scheme;
    private String bearerToken;

    public HttpBearerAuth(String string) {
        this.scheme = string;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String string) {
        this.bearerToken = string;
    }

    @Override
    public void applyToParams(List<Pair> list, Map<String, String> map) {
        if (this.bearerToken == null) {
            return;
        }
        map.put("Authorization", (this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + this.bearerToken);
    }

    private static String upperCaseBearer(String string) {
        return "bearer".equalsIgnoreCase(string) ? "Bearer" : string;
    }
}

