/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import java.util.ArrayList;
import java.util.HashMap;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiClientBuilder;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.api.MetaApi;
import net.troja.eve.esi.auth.OAuth;
import net.troja.eve.esi.model.CharacterInfo;
import okhttp3.Call;

public class SsoApi {
    private static final String URI_REVOKE = "https://login.eveonline.com";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String DATASOURCE = "tranquility";
    protected static final String DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private final ApiClient revokeApiClient = new ApiClientBuilder().build();
    private ApiClient apiClient;
    private MetaApi metaApi;

    public SsoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SsoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.metaApi = new MetaApi(apiClient);
        this.revokeApiClient.setBasePath(URI_REVOKE);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.metaApi.setApiClient(apiClient);
    }

    public CharacterInfo getCharacterInfo() throws ApiException {
        return new CharacterInfo(this.metaApi.getVerify(null, null, DATASOURCE, null, null));
    }

    public void revokeRefreshToken(String string) throws ApiException {
        this.postRevokeToken(string, REFRESH_TOKEN);
    }

    public void revokeAccessToken(String string) throws ApiException {
        this.postRevokeToken(string, ACCESS_TOKEN);
    }

    private Call postRevokeTokenCall(String string, String string2, ApiCallback apiCallback) throws ApiException {
        Object object = new Object();
        OAuth oAuth = (OAuth)this.apiClient.getAuthentication("evesso");
        String string3 = "/v2/oauth/revoke";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/x-www-form-urlencoded");
        hashMap.put("Host", "login.eveonline.com");
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("token_type_hint", string2);
        hashMap2.put("client_id", oAuth.getClientId());
        hashMap2.put("token", string);
        String[] stringArray = new String[]{"application/json"};
        String string4 = this.revokeApiClient.selectHeaderAccept(stringArray);
        if (string4 != null) {
            hashMap.put("Accept", string4);
        }
        String[] stringArray2 = new String[]{"application/x-www-form-urlencoded"};
        String string5 = this.revokeApiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string5);
        String[] stringArray3 = new String[]{};
        return this.revokeApiClient.buildCall(string3, "POST", arrayList, arrayList2, object, hashMap, hashMap2, stringArray3, apiCallback);
    }

    private Call postRevokeTokenValidateBeforeCall(String string, String string2, ApiCallback apiCallback) throws ApiException {
        return this.postRevokeTokenCall(string, string2, apiCallback);
    }

    private void postRevokeToken(String string, String string2) throws ApiException {
        this.postRevokeTokenWithHttpInfo(string, string2);
    }

    private ApiResponse<Void> postRevokeTokenWithHttpInfo(String string, String string2) throws ApiException {
        Call call = this.postRevokeTokenValidateBeforeCall(string, string2, null);
        return this.revokeApiClient.execute(call);
    }
}

