/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import java.io.IOException;
import net.troja.eve.esi.ApiCallback;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody responseBody;
    private final ApiCallback callback;
    private BufferedSource bufferedSource;

    public ProgressResponseBody(ResponseBody responseBody, ApiCallback apiCallback) {
        this.responseBody = responseBody;
        this.callback = apiCallback;
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(Buffer buffer, long l) throws IOException {
                long l2 = super.read(buffer, l);
                this.totalBytesRead += l2 != -1L ? l2 : 0L;
                ProgressResponseBody.this.callback.onDownloadProgress(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength(), l2 == -1L);
                return l2;
            }
        };
    }
}

