/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import java.io.IOException;
import net.troja.eve.esi.ApiCallback;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProgressRequestBody
extends RequestBody {
    private final RequestBody requestBody;
    private final ApiCallback callback;

    public ProgressRequestBody(RequestBody requestBody, ApiCallback apiCallback) {
        this.requestBody = requestBody;
        this.callback = apiCallback;
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        BufferedSink bufferedSink2 = Okio.buffer((Sink)this.sink((Sink)bufferedSink));
        this.requestBody.writeTo(bufferedSink2);
        bufferedSink2.flush();
    }

    private Sink sink(Sink sink) {
        return new ForwardingSink(sink){
            long bytesWritten;
            long contentLength;
            {
                this.bytesWritten = 0L;
                this.contentLength = 0L;
            }

            public void write(Buffer buffer, long l) throws IOException {
                super.write(buffer, l);
                if (this.contentLength == 0L) {
                    this.contentLength = ProgressRequestBody.this.contentLength();
                }
                this.bytesWritten += l;
                ProgressRequestBody.this.callback.onUploadProgress(this.bytesWritten, this.contentLength, this.bytesWritten == this.contentLength);
            }
        };
    }
}

