/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

class GzipRequestInterceptor
implements Interceptor {
    GzipRequestInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.body() == null || request.header("Content-Encoding") != null) {
            return chain.proceed(request);
        }
        Request request2 = request.newBuilder().header("Content-Encoding", "gzip").method(request.method(), this.forceContentLength(this.gzip(request.body()))).build();
        return chain.proceed(request2);
    }

    private RequestBody forceContentLength(final RequestBody requestBody) throws IOException {
        final Buffer buffer = new Buffer();
        requestBody.writeTo((BufferedSink)buffer);
        return new RequestBody(){

            public MediaType contentType() {
                return requestBody.contentType();
            }

            public long contentLength() {
                return buffer.size();
            }

            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(buffer.snapshot());
            }
        };
    }

    private RequestBody gzip(final RequestBody requestBody) {
        return new RequestBody(){

            public MediaType contentType() {
                return requestBody.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink bufferedSink) throws IOException {
                BufferedSink bufferedSink2 = Okio.buffer((Sink)new GzipSink((Sink)bufferedSink));
                requestBody.writeTo(bufferedSink2);
                bufferedSink2.close();
            }
        };
    }
}

