/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.JSON;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;
import net.troja.eve.esi.StringUtil;
import net.troja.eve.esi.auth.ApiKeyAuth;
import net.troja.eve.esi.auth.Authentication;
import net.troja.eve.esi.auth.HttpBasicAuth;
import net.troja.eve.esi.auth.OAuth;
import net.troja.eve.esi.auth.OAuthFlow;
import net.troja.eve.esi.auth.RetryingOAuth;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;

public class ApiClient {
    private String basePath = "https://esi.evetech.net";
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private DateFormat dateFormat;
    private DateFormat datetimeFormat;
    private boolean lenientDatetimeFormat;
    private int dateLength;
    private InputStream sslCaCert;
    private boolean verifyingSsl;
    private KeyManager[] keyManagers;
    private OkHttpClient httpClient;
    private JSON json;
    private HttpLoggingInterceptor loggingInterceptor;

    public ApiClient() {
        this.init();
        this.authentications.put("evesso", new OAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public ApiClient(String string) {
        this(string, null, null);
    }

    public ApiClient(String string, Map<String, String> map) {
        this(string, null, map);
    }

    public ApiClient(String string, String string2, Map<String, String> map) {
        this.init();
        RetryingOAuth retryingOAuth = new RetryingOAuth("", string, OAuthFlow.implicit, string2, map);
        this.authentications.put("evesso", retryingOAuth);
        this.httpClient.interceptors().add(retryingOAuth);
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    private void init() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addNetworkInterceptor(this.getProgressInterceptor());
        this.httpClient = builder.build();
        this.verifyingSsl = true;
        this.json = new JSON();
        this.setUserAgent("OpenAPI-Generator/0.8.6/java");
        this.authentications = new HashMap<String, Authentication>();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String string) {
        this.basePath = string;
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient okHttpClient) {
        if (!this.httpClient.equals(okHttpClient)) {
            OkHttpClient.Builder builder = okHttpClient.newBuilder();
            Iterator iterator = this.httpClient.networkInterceptors().iterator();
            while (iterator.hasNext()) {
                builder.addNetworkInterceptor((Interceptor)iterator.next());
            }
            Iterator iterator2 = this.httpClient.interceptors().iterator();
            while (iterator2.hasNext()) {
                builder.addInterceptor((Interceptor)iterator2.next());
            }
            this.httpClient = builder.build();
        }
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public ApiClient setJSON(JSON jSON) {
        this.json = jSON;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ApiClient setVerifyingSsl(boolean bl) {
        this.verifyingSsl = bl;
        this.applySslSettings();
        return this;
    }

    public InputStream getSslCaCert() {
        return this.sslCaCert;
    }

    public ApiClient setSslCaCert(InputStream inputStream) {
        this.sslCaCert = inputStream;
        this.applySslSettings();
        return this;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public ApiClient setKeyManagers(KeyManager[] keyManagerArray) {
        this.keyManagers = keyManagerArray;
        this.applySslSettings();
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateTimeFormatter) {
        this.json.setOffsetDateTimeFormat(dateTimeFormatter);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateTimeFormatter) {
        this.json.setLocalDateFormat(dateTimeFormatter);
        return this;
    }

    public ApiClient setLenientOnJson(boolean bl) {
        this.json.setLenientOnJson(bl);
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String string) {
        return this.authentications.get(string);
    }

    public void setUsername(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)authentication).setUsername(string);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)authentication).setPassword(string);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)authentication).setApiKey(string);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)authentication).setApiKeyPrefix(string);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof OAuth)) continue;
            ((OAuth)authentication).setAccessToken(string);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String string) {
        this.addDefaultHeader("User-Agent", string);
        return this;
    }

    public ApiClient addDefaultHeader(String string, String string2) {
        this.defaultHeaderMap.put(string, string2);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean bl) {
        if (bl != this.debugging) {
            if (bl) {
                this.loggingInterceptor = new HttpLoggingInterceptor();
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                this.httpClient = this.httpClient.newBuilder().addInterceptor((Interceptor)this.loggingInterceptor).build();
            } else {
                this.httpClient.interceptors().remove(this.loggingInterceptor);
                this.loggingInterceptor = null;
            }
        }
        this.debugging = bl;
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String string) {
        this.tempFolderPath = string;
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.connectTimeoutMillis();
    }

    public ApiClient setConnectTimeout(int n) {
        this.httpClient = this.httpClient.newBuilder().connectTimeout((long)n, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getReadTimeout() {
        return this.httpClient.readTimeoutMillis();
    }

    public ApiClient setReadTimeout(int n) {
        this.httpClient = this.httpClient.newBuilder().readTimeout((long)n, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getWriteTimeout() {
        return this.httpClient.writeTimeoutMillis();
    }

    public ApiClient setWriteTimeout(int n) {
        this.httpClient = this.httpClient.newBuilder().writeTimeout((long)n, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenEndPoint() {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof RetryingOAuth)) continue;
            RetryingOAuth retryingOAuth = (RetryingOAuth)authentication;
            return retryingOAuth.getTokenRequestBuilder();
        }
        return null;
    }

    public String parameterToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Date || object instanceof OffsetDateTime || object instanceof LocalDate) {
            String string = this.json.serialize(object);
            return string.substring(1, string.length() - 1);
        }
        if (object instanceof Collection) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object e : (Collection)object) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(String.valueOf(e));
            }
            return stringBuilder.toString();
        }
        return String.valueOf(object);
    }

    public List<Pair> parameterToPair(String string, Object object) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        if (string == null || string.isEmpty() || object == null || object instanceof Collection) {
            return arrayList;
        }
        arrayList.add(new Pair(string, this.parameterToString(object)));
        return arrayList;
    }

    public List<Pair> parameterToPairs(String string, String string2, Collection collection) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        if (string2 == null || string2.isEmpty() || collection == null || collection.isEmpty()) {
            return arrayList;
        }
        if ("multi".equals(string)) {
            for (Object e : collection) {
                arrayList.add(new Pair(string2, this.escapeString(this.parameterToString(e))));
            }
            return arrayList;
        }
        String string3 = ",";
        if ("ssv".equals(string)) {
            string3 = this.escapeString(" ");
        } else if ("tsv".equals(string)) {
            string3 = this.escapeString("\t");
        } else if ("pipes".equals(string)) {
            string3 = this.escapeString("|");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : collection) {
            stringBuilder.append(string3);
            stringBuilder.append(this.escapeString(this.parameterToString(e)));
        }
        arrayList.add(new Pair(string2, stringBuilder.substring(string3.length())));
        return arrayList;
    }

    public String collectionPathParameterToString(String string, Collection collection) {
        if ("multi".equals(string)) {
            return this.parameterToString(collection);
        }
        String string2 = ",";
        if ("ssv".equals(string)) {
            string2 = " ";
        } else if ("tsv".equals(string)) {
            string2 = "\t";
        } else if ("pipes".equals(string)) {
            string2 = "|";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : collection) {
            stringBuilder.append(string2);
            stringBuilder.append(this.parameterToString(e));
        }
        return stringBuilder.substring(string2.length());
    }

    public String sanitizeFilename(String string) {
        return string.replaceAll(".*[/\\\\]", "");
    }

    public boolean isJsonMime(String string) {
        String string2 = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return string != null && (string.matches(string2) || string.equals("*/*"));
    }

    public String selectHeaderAccept(String[] stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        for (String string : stringArray) {
            if (!this.isJsonMime(string)) continue;
            return string;
        }
        return StringUtil.join(stringArray, ",");
    }

    public String selectHeaderContentType(String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].equals("*/*")) {
            return "application/json";
        }
        for (String string : stringArray) {
            if (!this.isJsonMime(string)) continue;
            return string;
        }
        return stringArray[0];
    }

    public String escapeString(String string) {
        try {
            return URLEncoder.encode(string, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public <T> T deserialize(Response response, Type type) throws ApiException {
        String string;
        if (response == null || type == null) {
            return null;
        }
        if ("byte[]".equals(type.toString())) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException iOException) {
                throw new ApiException(iOException);
            }
        }
        if (type.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        try {
            string = response.body() != null ? response.body().string() : null;
        }
        catch (IOException iOException) {
            throw new ApiException(iOException);
        }
        if (string == null || "".equals(string)) {
            return null;
        }
        String string2 = response.headers().get("Content-Type");
        if (string2 == null) {
            string2 = "application/json";
        }
        if (this.isJsonMime(string2)) {
            return this.json.deserialize(string, type);
        }
        if (type.equals(String.class)) {
            return (T)string;
        }
        throw new ApiException("Content type \"" + string2 + "\" is not supported for type: " + type, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), string);
    }

    public RequestBody serialize(Object object, String string) throws ApiException {
        if (object instanceof byte[]) {
            return RequestBody.create((MediaType)MediaType.parse((String)string), (byte[])((byte[])object));
        }
        if (object instanceof File) {
            return RequestBody.create((MediaType)MediaType.parse((String)string), (File)((File)object));
        }
        if (this.isJsonMime(string)) {
            String string2 = object != null ? this.json.serialize(object) : null;
            return RequestBody.create((MediaType)MediaType.parse((String)string), (String)string2);
        }
        throw new ApiException("Content type \"" + string + "\" is not supported");
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink((File)file));
            bufferedSink.writeAll((Source)response.body().source());
            bufferedSink.close();
            return file;
        }
        catch (IOException iOException) {
            throw new ApiException(iOException);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Object object;
        Object object2;
        String string = null;
        String string2 = response.header("Content-Disposition");
        if (string2 != null && !"".equals(string2) && ((Matcher)(object2 = ((Pattern)(object = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?"))).matcher(string2))).find()) {
            string = this.sanitizeFilename(((Matcher)object2).group(1));
        }
        object = null;
        object2 = null;
        if (string == null) {
            object = "download-";
            object2 = "";
        } else {
            int n = string.lastIndexOf(".");
            if (n == -1) {
                object = string + "-";
            } else {
                object = string.substring(0, n) + "-";
                object2 = string.substring(n);
            }
            if (((String)object).length() < 3) {
                object = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile((String)object, (String)object2);
        }
        return File.createTempFile((String)object, (String)object2, new File(this.tempFolderPath));
    }

    public <T> ApiResponse<T> execute(Call call) throws ApiException {
        return this.execute(call, null);
    }

    public <T> ApiResponse<T> execute(Call call, Type type) throws ApiException {
        try {
            Response response = call.execute();
            T t = this.handleResponse(response, type);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), t);
        }
        catch (IOException iOException) {
            throw new ApiException(iOException);
        }
    }

    public <T> void executeAsync(Call call, ApiCallback<T> apiCallback) {
        this.executeAsync(call, null, apiCallback);
    }

    public <T> void executeAsync(Call call, final Type type, final ApiCallback<T> apiCallback) {
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException iOException) {
                apiCallback.onFailure(new ApiException(iOException), 0, null);
            }

            public void onResponse(Call call, Response response) throws IOException {
                Object t;
                try {
                    t = ApiClient.this.handleResponse(response, type);
                }
                catch (ApiException apiException) {
                    apiCallback.onFailure(apiException, response.code(), response.headers().toMultimap());
                    return;
                }
                apiCallback.onSuccess(t, response.code(), response.headers().toMultimap());
            }
        });
    }

    public <T> T handleResponse(Response response, Type type) throws ApiException {
        if (response.isSuccessful()) {
            if (type == null || response.code() == 204) {
                if (response.body() != null) {
                    try {
                        response.body().close();
                    }
                    catch (Exception exception) {
                        throw new ApiException(response.message(), (Throwable)exception, response.code(), response.headers().toMultimap());
                    }
                }
                return null;
            }
            return this.deserialize(response, type);
        }
        String string = null;
        if (response.body() != null) {
            try {
                string = response.body().string();
            }
            catch (IOException iOException) {
                throw new ApiException(response.message(), (Throwable)iOException, response.code(), response.headers().toMultimap());
            }
        }
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), string);
    }

    public Call buildCall(String string, String string2, List<Pair> list, List<Pair> list2, Object object, Map<String, String> map, Map<String, Object> map2, String[] stringArray, ApiCallback apiCallback) throws ApiException {
        Request request = this.buildRequest(string, string2, list, list2, object, map, map2, stringArray, apiCallback);
        return this.httpClient.newCall(request);
    }

    public Request buildRequest(String string, String string2, List<Pair> list, List<Pair> list2, Object object, Map<String, String> map, Map<String, Object> map2, String[] stringArray, ApiCallback apiCallback) throws ApiException {
        this.updateParamsForAuth(stringArray, list, map);
        String string3 = this.buildUrl(string, list, list2);
        Request.Builder builder = new Request.Builder().url(string3);
        this.processHeaderParams(map, builder);
        String string4 = map.get("Content-Type");
        if (string4 == null) {
            string4 = "application/json";
        }
        Object object2 = !HttpMethod.permitsRequestBody((String)string2) ? null : ("application/x-www-form-urlencoded".equals(string4) ? this.buildRequestBodyFormEncoding(map2) : ("multipart/form-data".equals(string4) ? this.buildRequestBodyMultipart(map2) : (object == null ? ("DELETE".equals(string2) ? null : RequestBody.create((MediaType)MediaType.parse((String)string4), (String)"")) : this.serialize(object, string4))));
        builder.tag((Object)apiCallback);
        Request request = null;
        if (apiCallback != null && object2 != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody((RequestBody)object2, apiCallback);
            request = builder.method(string2, (RequestBody)progressRequestBody).build();
        } else {
            request = builder.method(string2, object2).build();
        }
        return request;
    }

    public String buildUrl(String string, List<Pair> list, List<Pair> list2) {
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.basePath).append(string);
        if (list != null && !list.isEmpty()) {
            string3 = string.contains("?") ? "&" : "?";
            for (Pair pair : list) {
                if (pair.getValue() == null) continue;
                if (string3 != null) {
                    stringBuilder.append(string3);
                    string3 = null;
                } else {
                    stringBuilder.append("&");
                }
                string2 = this.parameterToString(pair.getValue());
                stringBuilder.append(this.escapeString(pair.getName())).append("=").append(this.escapeString(string2));
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            string3 = stringBuilder.toString().contains("?") ? "&" : "?";
            for (Pair pair : list2) {
                if (pair.getValue() == null) continue;
                if (string3 != null) {
                    stringBuilder.append(string3);
                    string3 = null;
                } else {
                    stringBuilder.append("&");
                }
                string2 = this.parameterToString(pair.getValue());
                stringBuilder.append(this.escapeString(pair.getName())).append("=").append(string2);
            }
        }
        return stringBuilder.toString();
    }

    public void processHeaderParams(Map<String, String> map, Request.Builder builder) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.header(entry.getKey(), this.parameterToString(entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            builder.header(entry.getKey(), this.parameterToString(entry.getValue()));
        }
    }

    public void updateParamsForAuth(String[] stringArray, List<Pair> list, Map<String, String> map) {
        for (String string : stringArray) {
            Authentication authentication = this.authentications.get(string);
            if (authentication == null) {
                throw new RuntimeException("Authentication undefined: " + string);
            }
            authentication.applyToParams(list, map);
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> map) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder.add(entry.getKey(), this.parameterToString(entry.getValue()));
        }
        return builder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> map) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            File file;
            if (entry.getValue() instanceof File) {
                file = (File)entry.getValue();
                Headers headers = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entry.getKey() + "\"; filename=\"" + file.getName() + "\""});
                MediaType mediaType = MediaType.parse((String)this.guessContentTypeFromFile(file));
                builder.addPart(headers, RequestBody.create((MediaType)mediaType, (File)file));
                continue;
            }
            file = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entry.getKey() + "\""});
            builder.addPart((Headers)file, RequestBody.create(null, (String)this.parameterToString(entry.getValue())));
        }
        return builder.build();
    }

    public String guessContentTypeFromFile(File file) {
        String string = URLConnection.guessContentTypeFromName(file.getName());
        if (string == null) {
            return "application/octet-stream";
        }
        return string;
    }

    private Interceptor getProgressInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(request);
                if (request.tag() instanceof ApiCallback) {
                    ApiCallback apiCallback = (ApiCallback)request.tag();
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), apiCallback)).build();
                }
                return response;
            }
        };
    }

    private void applySslSettings() {
        try {
            SSLContext sSLContext;
            TrustManager[] trustManagerArray = null;
            HostnameVerifier hostnameVerifier = null;
            if (!this.verifyingSsl) {
                trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                sSLContext = SSLContext.getInstance("TLS");
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                };
            } else if (this.sslCaCert != null) {
                sSLContext = null;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> collection = certificateFactory.generateCertificates(this.sslCaCert);
                if (collection.isEmpty()) {
                    throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                }
                KeyStore keyStore = this.newEmptyKeyStore((char[])sSLContext);
                int n = 0;
                for (Certificate certificate : collection) {
                    String string = "ca" + Integer.toString(n++);
                    keyStore.setCertificateEntry(string, certificate);
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            if (this.keyManagers != null || trustManagerArray != null) {
                sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(this.keyManagers, trustManagerArray, new SecureRandom());
                this.httpClient = this.httpClient.newBuilder().sslSocketFactory(sSLContext.getSocketFactory(), (X509TrustManager)trustManagerArray[0]).build();
            } else {
                this.httpClient = this.httpClient.newBuilder().sslSocketFactory(null, (X509TrustManager)trustManagerArray[0]).build();
            }
            this.httpClient = this.httpClient.newBuilder().hostnameVerifier(hostnameVerifier).build();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    private KeyStore newEmptyKeyStore(char[] cArray) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, cArray);
            return keyStore;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }
}

